/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph;

import com.teamscale.index.dataflow.controlflowgraph.Condition;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.visitor.IMeshWalker;

public class ControlFlowNode {
    public static final IMeshWalker<ControlFlowNode, NeverThrownRuntimeException> DOWN_WALKER = ControlFlowNode::getSuccessors;
    public static final IMeshWalker<ControlFlowNode, NeverThrownRuntimeException> UP_WALKER = ControlFlowNode::getPredecessors;
    public static final IMeshWalker<ControlFlowNode, NeverThrownRuntimeException> LAMBDA_WALKER = element -> {
        if (element.hasLambdas()) {
            ArrayList<ControlFlowNode> adjacentElements = new ArrayList<ControlFlowNode>(element.getSuccessors());
            adjacentElements.addAll((Collection<ControlFlowNode>)element.getLambdaEntries());
            return adjacentElements;
        }
        return element.getSuccessors();
    };
    private final VariableReadWriteInfo readWriteInfo;
    private final List<ControlFlowNode> successors = new ArrayList<ControlFlowNode>();
    private final List<ControlFlowNode> predecessors = new ArrayList<ControlFlowNode>();
    private final List<IToken> tokens;
    private Condition condition = null;
    private List<ControlFlowGraph> lambdas;
    private final boolean isAssumeNode;
    private boolean continuesWithLoopReturnEdge = false;
    private Integer id = null;

    public ControlFlowNode() {
        this.readWriteInfo = new VariableReadWriteInfo();
        this.tokens = null;
        this.isAssumeNode = false;
    }

    public ControlFlowNode(VariableReadWriteInfo assumes) {
        this.readWriteInfo = assumes;
        this.tokens = null;
        this.isAssumeNode = true;
    }

    public ControlFlowNode(List<IToken> tokens, VariableReadWriteInfo info) {
        this.tokens = tokens;
        this.readWriteInfo = info;
        this.isAssumeNode = false;
    }

    public boolean isConditional() {
        return this.condition != null;
    }

    public boolean isAssumeNode() {
        return this.isAssumeNode;
    }

    public boolean isAwaitNode() {
        return this.getTokens().stream().anyMatch(token -> token.getType() == ETokenType.AWAIT);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void makeConditional(Condition condition) {
        this.condition = condition;
    }

    public ControlFlowNode getYesBranch() {
        return this.successors.get(0);
    }

    public ControlFlowNode getNoBranch() {
        return this.successors.get(1);
    }

    public VariableReadWriteInfo getReadWriteInfo() {
        return this.readWriteInfo;
    }

    public List<ControlFlowNode> getSuccessors() {
        return this.successors;
    }

    public List<ControlFlowNode> getPredecessors() {
        return this.predecessors;
    }

    public boolean isSynthetic() {
        return this.tokens == null;
    }

    public List<IToken> getTokens() {
        if (this.tokens == null) {
            return CollectionUtils.emptyList();
        }
        return this.tokens;
    }

    public String toString() {
        if (this.isAssumeNode) {
            return "assume: " + StringUtils.concat(this.readWriteInfo.getAllWrites(), (String)"; ");
        }
        if (this.isSynthetic()) {
            return "SYNTHETIC";
        }
        return TokenStreamTextUtils.concatTokenTexts(this.tokens, (String)" ");
    }

    public static void link(ControlFlowNode predecessor, ControlFlowNode successor) {
        List<ControlFlowNode> siblings = predecessor.getSuccessors();
        if (siblings.size() > 1) {
            siblings.add(1, successor);
        } else {
            siblings.add(successor);
        }
        successor.getPredecessors().add(predecessor);
    }

    public static void link(ControlFlowNode predecessor, Set<ControlFlowNode> successors) {
        predecessor.getSuccessors().addAll(successors);
        successors.forEach(node -> node.getPredecessors().add(predecessor));
    }

    public static void weaveAfter(ControlFlowNode referenceNode, ControlFlowNode nodeToInsert) {
        for (ControlFlowNode successor : referenceNode.getSuccessors()) {
            successor.getPredecessors().remove(referenceNode);
            ControlFlowNode.link(nodeToInsert, successor);
        }
        referenceNode.getSuccessors().clear();
        ControlFlowNode.link(referenceNode, nodeToInsert);
    }

    public static void weaveBetween(ControlFlowNode node, ControlFlowNode successor, ControlFlowNode nodeToInsert) {
        CCSMAssert.isTrue((boolean)node.getSuccessors().contains(successor), (String)"Cannot weave node between two nodes that are not linked.");
        successor.getPredecessors().remove(node);
        int oldSuccessorIndex = node.getSuccessors().indexOf(successor);
        node.getSuccessors().set(oldSuccessorIndex, nodeToInsert);
        nodeToInsert.getPredecessors().add(node);
        ControlFlowNode.link(nodeToInsert, successor);
    }

    public void attachLambdaOrNestedFunction(ControlFlowGraph lambdaCfg) {
        if (this.lambdas == null) {
            this.lambdas = new ArrayList<ControlFlowGraph>();
        }
        this.lambdas.add(lambdaCfg);
    }

    public boolean hasLambdas() {
        return this.lambdas != null;
    }

    public UnmodifiableList<ControlFlowGraph> getLambdas() {
        if (!this.hasLambdas()) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.lambdas);
    }

    public UnmodifiableList<ControlFlowNode> getLambdaEntries() {
        return this.selectLambdaNodes(ControlFlowGraph::getRoot);
    }

    private UnmodifiableList<ControlFlowNode> selectLambdaNodes(Function<? super ControlFlowGraph, ? extends ControlFlowNode> nodeSelector) {
        if (!this.hasLambdas()) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable((List)CollectionUtils.map(this.lambdas, nodeSelector));
    }

    public void setContinuesWithLoopReturnEdge(boolean continuesWithLoopReturnEdge) {
        this.continuesWithLoopReturnEdge = continuesWithLoopReturnEdge;
    }

    public boolean continuesWithLoopReturnEdge() {
        return this.continuesWithLoopReturnEdge;
    }

    public int getId() {
        CCSMAssert.isTrue((this.id != null ? 1 : 0) != 0, (String)"ControlFlowGraph creation failed to set CFG node ids.");
        return this.id;
    }

    public Integer getIdAsNullable() {
        return this.id;
    }

    public void setId(int id) {
        if (this.id != null) {
            throw new IllegalStateException("Can't set ids of ControlFlowNode " + String.valueOf(this) + " twice. Old id: " + this.id + ", new id: " + id);
        }
        this.id = id;
    }
}

