/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.clike;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataflowHeuristicBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.AnonymousBlockRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.BreakRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.CLikeIfRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.CLikeSwitchRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.CLikeWhileRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.CodeLabelRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ContinueRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.DoWhileRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IgnoreRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.ReturnRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.SimpleStatementRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.TryCatchFinallyRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ParentEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityAndMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityOrMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.SimpleStatementMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.SubTypeMatcher;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import org.conqat.lib.commons.collections.PairList;

public abstract class CLikeDataFlowHeuristicBase
extends DataflowHeuristicBase {
    protected static final IShallowEntityMatcher BREAK_SUBTYPE = new SimpleStatementMatcher("break");
    protected static final IShallowEntityMatcher YIELD_SUBTYPE = new SimpleStatementMatcher("yield");
    private static final IShallowEntityMatcher CONTINUE_SUBTYPE = new SimpleStatementMatcher("continue");
    private static final IShallowEntityMatcher CODE_LABEL_SUBTYPE = new SubTypeMatcher("label");
    protected static final IShallowEntityMatcher FOR_SUBTYPE = new SubTypeMatcher("for");
    private static final IShallowEntityMatcher DO_LOOP_SUBTYPE = new SubTypeMatcher("do");
    private static final IShallowEntityMatcher WHILE_SUBTYPE = new SubTypeMatcher("while");
    private static final IShallowEntityMatcher SWITCH_SUBTYPE = new ShallowEntityOrMatcher(new SubTypeMatcher("switch"), new SubTypeMatcher("switch expression"));
    private static final IShallowEntityMatcher TRY_SUBTYPE = new SubTypeMatcher("try");
    private static final IShallowEntityMatcher CATCH_SUBTYPE = new SubTypeMatcher("catch");
    private static final IShallowEntityMatcher FINALLY_SUBTYPE = new SubTypeMatcher("finally");
    private static final IShallowEntityMatcher IF_SUBTYPE = new SubTypeMatcher("if");
    private static final IShallowEntityMatcher ELSE_IF_SUBTYPE = new SubTypeMatcher("else if");
    private static final IShallowEntityMatcher ELSE_SUBTYPE = new SubTypeMatcher("else");
    protected static final IShallowEntityMatcher CASE_SUBTYPE_BELOW_SWITCH = new ShallowEntityAndMatcher(new SubTypeMatcher("case"), new ParentEntityMatcher(SWITCH_SUBTYPE));
    protected static final IShallowEntityMatcher DEFAULT_SUBTYPE_BELOW_SWITCH = new ShallowEntityAndMatcher(new SubTypeMatcher("default"), new ParentEntityMatcher(SWITCH_SUBTYPE));
    protected static final IShallowEntityMatcher ALL_CASE_LABELS = new ShallowEntityOrMatcher(CASE_SUBTYPE_BELOW_SWITCH, DEFAULT_SUBTYPE_BELOW_SWITCH);
    private static final IShallowEntityMatcher ANONYMOUS_BLOCK = new SubTypeMatcher("anonymous block");
    private static final IShallowEntityMatcher SIMPLE_STATEMENTS = new ShallowEntityOrMatcher(new SubTypeMatcher("simple statement"), new SubTypeMatcher("empty statement"), new SubTypeMatcher("local variable"));
    protected static final IShallowEntityMatcher RETURN_OR_THROW_STATEMENTS = new ShallowEntityOrMatcher(new SimpleStatementMatcher("return"), new SimpleStatementMatcher("throw"));
    private static final IShallowEntityMatcher UNINTERESTING_ENTITIES = new IShallowEntityMatcher(){

        @Override
        public boolean matches(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.META || entity.getType() == EShallowEntityType.TYPE;
        }
    };

    protected static void addDefaultRules(PairList<IShallowEntityMatcher, IControlFlowRule> rules) {
        rules.add((Object)ANONYMOUS_BLOCK, (Object)new AnonymousBlockRule());
        rules.add((Object)SWITCH_SUBTYPE, (Object)new CLikeSwitchRule());
        rules.add((Object)RETURN_OR_THROW_STATEMENTS, (Object)new ReturnRule());
        rules.add((Object)CONTINUE_SUBTYPE, (Object)new ContinueRule());
        rules.add((Object)BREAK_SUBTYPE, (Object)new BreakRule());
        rules.add((Object)DO_LOOP_SUBTYPE, (Object)new DoWhileRule());
        rules.add((Object)WHILE_SUBTYPE, (Object)new CLikeWhileRule());
        rules.add((Object)TRY_SUBTYPE, (Object)new TryCatchFinallyRule(CATCH_SUBTYPE, FINALLY_SUBTYPE));
        rules.add((Object)IF_SUBTYPE, (Object)new CLikeIfRule(ELSE_IF_SUBTYPE, ELSE_SUBTYPE));
        rules.add((Object)CODE_LABEL_SUBTYPE, (Object)new CodeLabelRule());
        rules.add((Object)SIMPLE_STATEMENTS, (Object)new SimpleStatementRule(true));
        rules.add((Object)UNINTERESTING_ENTITIES, (Object)new IgnoreRule());
    }

    protected boolean hasMethodBody(ShallowEntity entity) {
        return !entity.getSubtype().contains("abstract");
    }

    protected static boolean isEntrypoint(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return true;
        }
        return !ShallowParsingUtils.isLambdaMethod((ShallowEntity)entity) || parent.getType() == EShallowEntityType.ATTRIBUTE;
    }
}

