/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.ShallowEntityOrMatcher;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class CaseLabelRule
implements IControlFlowRule {
    protected final boolean canFallThrough;
    private final IShallowEntityMatcher defaultMatcher;
    private final IShallowEntityMatcher breakMatcher;
    private final IShallowEntityMatcher returnMatcher;
    private final ShallowEntityOrMatcher allCaseLabelsMatcher;
    private final String caseLabelPrefix;
    private final String caseLabelSuffix;

    public CaseLabelRule(boolean canFallThrough, IShallowEntityMatcher caseMatcher, IShallowEntityMatcher defaultMatcher, IShallowEntityMatcher breakMatcher, IShallowEntityMatcher returnMatcher, String caseLabelPrefix, String caseLabelSuffix) {
        this.caseLabelPrefix = caseLabelPrefix;
        this.caseLabelSuffix = caseLabelSuffix;
        this.allCaseLabelsMatcher = new ShallowEntityOrMatcher(caseMatcher, defaultMatcher);
        this.canFallThrough = canFallThrough;
        this.defaultMatcher = defaultMatcher;
        this.breakMatcher = breakMatcher;
        this.returnMatcher = returnMatcher;
    }

    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        ShallowEntity caseLabelEntity = entities.get(0);
        List<ShallowEntity> caseEntities = this.extractCaseEntities(entities);
        IControlFlowRule.Result caseBodyNodes = this.transformCase(creator, context, caseEntities);
        String label = this.extractCaseLabel((List<IToken>)caseLabelEntity.ownStartTokens());
        ControlFlowNode caseEntryNode = this.getCaseEntryNode(caseBodyNodes, caseLabelEntity, context, creator);
        context.getCaseLabelManager().addJumpTargetNode(label, caseEntryNode);
        if (this.shouldCreateSyntheticBreak(caseEntities, entities)) {
            ControlFlowNode breakNode = context.createSyntheticNode();
            for (ControlFlowNode exitNode : caseBodyNodes.getExitNodes()) {
                ControlFlowNode.link(exitNode, breakNode);
            }
            context.getBreakNodes().add(breakNode);
        }
        UnmodifiableList exitNodes = caseBodyNodes.getExitNodes();
        if (!this.canFallThrough) {
            context.getBreakNodes().addAll(caseBodyNodes.getExitNodes());
            exitNodes = CollectionUtils.emptyList();
        }
        if (this.defaultMatcher.matches(caseLabelEntity)) {
            context.setDefaultCaseEntryNode(caseBodyNodes.getEntryNode());
        } else {
            context.getCaseEntryNodes().add(caseEntryNode);
        }
        return new IControlFlowRule.Result(1 + caseEntities.size(), caseEntryNode, (List<ControlFlowNode>)exitNodes);
    }

    protected IControlFlowRule.Result transformCase(ControlFlowCreator creator, DataFlowContext context, List<ShallowEntity> caseEntities) throws ConQATException {
        return creator.transform(caseEntities);
    }

    private ControlFlowNode getCaseEntryNode(IControlFlowRule.Result caseBodyNodes, ShallowEntity caseStatement, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        ControlFlowNode caseEntryNode = this.createEntryNodeForCaseStatementEntity(caseStatement, context, creator);
        if (caseEntryNode == null) {
            caseEntryNode = caseBodyNodes.getEntryNode();
        } else {
            ControlFlowNode.link(caseEntryNode, caseBodyNodes.getEntryNode());
        }
        return caseEntryNode;
    }

    protected ControlFlowNode createEntryNodeForCaseStatementEntity(ShallowEntity caseStatement, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        return null;
    }

    private String extractCaseLabel(List<IToken> tokens) {
        StringBuffer sb = new StringBuffer();
        for (IToken token : tokens) {
            sb.append(token.getText());
        }
        String label = sb.toString();
        label = StringUtils.stripPrefix((String)label, (String)this.caseLabelPrefix);
        label = StringUtils.stripSuffix((String)label, (String)this.caseLabelSuffix);
        return label;
    }

    private boolean shouldCreateSyntheticBreak(List<ShallowEntity> caseEntities, List<ShallowEntity> entities) {
        if (!this.canFallThrough) {
            return false;
        }
        ShallowEntity lastEntity = (ShallowEntity)CollectionUtils.getLast(caseEntities);
        if (lastEntity != null && (this.breakMatcher.matches(lastEntity) || this.returnMatcher.matches(lastEntity))) {
            return false;
        }
        boolean isLastCaseInSwitchStatement = caseEntities.size() == entities.size() - 1;
        return isLastCaseInSwitchStatement;
    }

    private List<ShallowEntity> extractCaseEntities(List<ShallowEntity> entities) {
        ShallowEntity entity;
        ArrayList<ShallowEntity> caseStatements = new ArrayList<ShallowEntity>();
        for (int i = 1; i < entities.size() && !this.allCaseLabelsMatcher.matches(entity = entities.get(i)); ++i) {
            caseStatements.add(entity);
        }
        return caseStatements;
    }
}

