/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysisglobal;

import com.teamscale.index.dataflow.taintpropagation.analysisglobal.TaintPathsMap;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;

class TaintPathsAggregator {
    boolean reachedPathsThreshold = false;
    private TaintPathsMap pathsFromToMap;
    private int maxPathsBetweenStatements;
    private Set<TaintGraphReferenceBase> pathEnds;
    private final HashMap<TaintGraphReferenceBase, TreeSet<List<TaintGraphReferenceBase>>> completePathCache = new HashMap();

    TaintPathsAggregator(int maxPathsBetweenStatements, TaintPathsMap pathsFromToMap, Set<TaintGraphReferenceBase> pathEnds) {
        this.pathsFromToMap = pathsFromToMap;
        this.maxPathsBetweenStatements = maxPathsBetweenStatements;
        this.pathEnds = pathEnds;
    }

    private TreeSet<List<TaintGraphReferenceBase>> getCompletePathsFromTo(TaintGraphReferenceBase pathStart, Set<TaintGraphReferenceBase> ignoreNodes) {
        TreeSet<List<TaintGraphReferenceBase>> completePaths = new TreeSet<List<TaintGraphReferenceBase>>(CollectionUtils.getListComparator());
        TreeSet<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>> startKeys = new TreeSet<Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>>(CollectionUtils.getPairComparator());
        startKeys.addAll(this.pathsFromToMap.getKeysStartingIn(pathStart));
        CounterSet pathsPerEndCounter = new CounterSet();
        for (Pair pair : startKeys) {
            if (ignoreNodes.contains(pair.getSecond())) continue;
            completePaths.addAll(this.getDirectPathsToEndNodes(pathStart, (Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>)pair));
            TreeSet<List<TaintGraphReferenceBase>> continuingPaths = null;
            if (this.completePathCache.containsKey(pair.getSecond())) {
                continuingPaths = this.completePathCache.get(pair.getSecond());
            } else {
                continuingPaths = this.getCompletePathsFromTo((TaintGraphReferenceBase)pair.getSecond(), CollectionUtils.unionSet(Collections.singleton(pathStart), (Collection[])new Collection[]{ignoreNodes}));
                this.completePathCache.put((TaintGraphReferenceBase)pair.getSecond(), continuingPaths);
            }
            for (List<TaintGraphReferenceBase> continuingPath : continuingPaths) {
                completePaths.addAll(this.getCompletePaths((CounterSet<TaintGraphReferenceBase>)pathsPerEndCounter, (Pair<TaintGraphReferenceBase, TaintGraphReferenceBase>)pair, continuingPath));
            }
        }
        return completePaths;
    }

    private List<List<TaintGraphReferenceBase>> getDirectPathsToEndNodes(TaintGraphReferenceBase pathStart, Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> pathKey) {
        ArrayList<List<TaintGraphReferenceBase>> directPaths = new ArrayList<List<TaintGraphReferenceBase>>();
        if (this.pathEnds.contains(pathKey.getSecond())) {
            for (List<TaintGraphReferenceBase> keyPath : this.pathsFromToMap.getPathsFromTo(pathKey)) {
                directPaths.add(TaintPathsMap.createPath(pathStart, keyPath, Collections.singletonList((TaintGraphReferenceBase)pathKey.getSecond())));
            }
        }
        return directPaths;
    }

    private Set<List<TaintGraphReferenceBase>> getCompletePaths(CounterSet<TaintGraphReferenceBase> pathsPerEndCounter, Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> startKey, List<TaintGraphReferenceBase> continuingPath) {
        TreeSet<List<TaintGraphReferenceBase>> completePaths = new TreeSet<List<TaintGraphReferenceBase>>(CollectionUtils.getListComparator());
        for (List<TaintGraphReferenceBase> storedPath : this.pathsFromToMap.getPathsFromTo(startKey)) {
            pathsPerEndCounter.inc((Object)((TaintGraphReferenceBase)CollectionUtils.getLast(continuingPath)));
            if (pathsPerEndCounter.getValue((Object)((TaintGraphReferenceBase)CollectionUtils.getLast(continuingPath))) > this.maxPathsBetweenStatements) {
                this.reachedPathsThreshold = true;
                continue;
            }
            completePaths.add(TaintPathsMap.createPath((TaintGraphReferenceBase)startKey.getFirst(), storedPath, continuingPath));
        }
        return completePaths;
    }

    TreeSet<List<TaintGraphReferenceBase>> getCompletePathsFromTo(TaintGraphReferenceBase pathStart) {
        return this.getCompletePathsFromTo(pathStart, Collections.emptySet());
    }
}

