/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.configuration.ETaintAnalysisOptions;
import com.teamscale.index.dataflow.DataflowAnalysisBase;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysisState;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphField;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphParameter;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.VariableTaintGraphReference;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.AbapLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class MethodTaintAnalysisInitializer {
    public static final String INITIAL_FIELD_SSA_NAME = "init";
    private EnumSet<ETaintAnalysisOptions> options;
    private TokenElementInfo element;
    private StringOffsetTransformer offsetTransformer;
    private LineOffsetConverter rawLineOffsetConverter;

    public MethodTaintAnalysisInitializer(TokenElementInfo element, EnumSet<ETaintAnalysisOptions> options) {
        this.options = options;
        this.element = element;
        this.offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
        this.rawLineOffsetConverter = new LineOffsetConverter(element.getText());
    }

    void initializeAnalysis(ControlFlowGraph cfg, Deque<DataflowAnalysisBase.WorkItem> initialWorkItemStack, Set<DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> analysisResultForInitializerMethods) {
        MethodTaintGraphGenerationAnalysisState initialState = (MethodTaintGraphGenerationAnalysisState)initialWorkItemStack.peek().getInput();
        this.initializeFileScopeVariables(cfg, analysisResultForInitializerMethods, initialState);
        if (!cfg.getEntities().isEmpty()) {
            String entitySubtype = cfg.getEntities().get(0).getSubtype();
            if (entitySubtype.equals("method implementation")) {
                this.initializeMethodImplementationParameters(cfg, initialState);
            } else if (entitySubtype.equals("form")) {
                this.initializeFormParameters(cfg, initialState);
            } else if (entitySubtype.equals("function")) {
                this.initializeFunctionParameters(cfg, initialState);
            }
        }
    }

    private void initializeFunctionParameters(ControlFlowGraph cfg, MethodTaintGraphGenerationAnalysisState state) {
        AbapLanguageFeatureParser featureParser = LanguageFeatureParser.ABAP;
        UnmodifiableList functionDeclarationTokens = cfg.getEntities().get(0).ownStartTokens();
        List parameters = featureParser.getTypeInfoForMethodParameters(cfg.getEntities().get(0), (List)functionDeclarationTokens);
        TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens((List<IToken>)functionDeclarationTokens, this.element, this.offsetTransformer, this.rawLineOffsetConverter);
        MethodTaintAnalysisInitializer.initializeParameters(parameters, location, state);
    }

    private void initializeFormParameters(ControlFlowGraph cfg, MethodTaintGraphGenerationAnalysisState state) {
        AbapLanguageFeatureParser featureParser = LanguageFeatureParser.ABAP;
        ShallowEntity formHeadEntity = cfg.getEntities().get(0);
        List parameters = featureParser.getTypeInfoForMethodParameters(formHeadEntity, (List)formHeadEntity.ownStartTokens());
        TextRegionLocation formHeadLocation = TaintAnalysisUtils.createLocationForTokens((List<IToken>)formHeadEntity.ownStartTokens(), this.element, this.offsetTransformer, this.rawLineOffsetConverter);
        int parameterIndex = 0;
        for (TypedVariable parameter : parameters) {
            ArrayList<TaintGraphParameter.EParameterModifier> parameterModifiers = new ArrayList<TaintGraphParameter.EParameterModifier>();
            if (parameter.hasModifier(ETokenType.USING)) {
                parameterModifiers.add(TaintGraphParameter.EParameterModifier.USING);
            } else if (parameter.hasModifier(ETokenType.CHANGING)) {
                parameterModifiers.add(TaintGraphParameter.EParameterModifier.CHANGING);
            }
            String methodIdentifier = TaintAnalysisUtils.buildMethodIdentifier(this.element.getUniformPath(), cfg.getMethodName());
            boolean isOptional = parameter.hasModifier(ETokenType.OPTIONAL) || parameter.hasModifier(ETokenType.DEFAULT);
            state.putReferenceFor(parameter.getVariableName(), new TaintGraphParameter(parameter.getVariableName(), parameterIndex, isOptional, "0", parameterModifiers, (ElementLocation)formHeadLocation, methodIdentifier));
            ++parameterIndex;
        }
    }

    private void initializeMethodImplementationParameters(ControlFlowGraph cfg, MethodTaintGraphGenerationAnalysisState state) {
        AbapLanguageFeatureParser featureParser = LanguageFeatureParser.ABAP;
        List methodDeclarationTokens = featureParser.getDeclarationTokensForMethod(this.element.getShallowEntitiesWithoutPreprocessorTokens(), cfg.getEntities().get(0));
        if (methodDeclarationTokens != null) {
            List parameters = featureParser.getTypeInfoForMethodParameters(cfg.getEntities().get(0), methodDeclarationTokens);
            TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens(methodDeclarationTokens, this.element, this.offsetTransformer, this.rawLineOffsetConverter);
            MethodTaintAnalysisInitializer.initializeParameters(parameters, location, state);
        }
    }

    private static void initializeParameters(List<TypedVariable> parameters, TextRegionLocation location, MethodTaintGraphGenerationAnalysisState state) {
        String methodIdentifier = state.getMethodIdentifier();
        int parameterIndex = 0;
        for (TypedVariable parameter : parameters) {
            TaintGraphReferenceBase parameterRef;
            if (parameter.hasModifier(ETokenType.RETURNING)) {
                parameterRef = new VariableTaintGraphReference(parameter.getVariableName().toLowerCase(), "0", TaintGraphReferenceBase.EReferenceType.RETURN_VALUE, (ElementLocation)location, methodIdentifier);
                state.putReferenceFor(parameter.getVariableName().toLowerCase(), parameterRef);
                continue;
            }
            parameterRef = MethodTaintAnalysisInitializer.createParameterFromTypedVariable(location, parameterIndex, parameter, methodIdentifier);
            state.putReferenceFor(parameter.getVariableName().toLowerCase(), parameterRef);
            ++parameterIndex;
        }
    }

    private static TaintGraphParameter createParameterFromTypedVariable(TextRegionLocation location, int parameterIndex, TypedVariable parameter, String methodIdentifier) {
        ArrayList<TaintGraphParameter.EParameterModifier> parameterModifiers = new ArrayList<TaintGraphParameter.EParameterModifier>();
        if (parameter.hasModifier(ETokenType.IMPORTING)) {
            parameterModifiers.add(TaintGraphParameter.EParameterModifier.IMPORTING);
        } else if (parameter.hasModifier(ETokenType.EXPORTING)) {
            parameterModifiers.add(TaintGraphParameter.EParameterModifier.EXPORTING);
        } else if (parameter.hasModifier(ETokenType.CHANGING)) {
            parameterModifiers.add(TaintGraphParameter.EParameterModifier.CHANGING);
        } else if (parameter.hasModifier(ETokenType.TABLES)) {
            parameterModifiers.add(TaintGraphParameter.EParameterModifier.TABLES);
        }
        boolean isOptional = parameter.hasModifier(ETokenType.OPTIONAL) || parameter.hasModifier(ETokenType.DEFAULT);
        TaintGraphParameter parameterRef = new TaintGraphParameter(parameter.getVariableName().toLowerCase(), parameterIndex, isOptional, "0", parameterModifiers, (ElementLocation)location, methodIdentifier);
        return parameterRef;
    }

    private void initializeFileScopeVariables(ControlFlowGraph cfg, Set<DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> analysisResultsOfInitializerMethods, MethodTaintGraphGenerationAnalysisState state) {
        Predicate<String> skipGlobalVariable = variableName -> false;
        if (!this.options.contains((Object)ETaintAnalysisOptions.SUPPORT_SIDEEFFECTS_ON_UNUSED_FIELDS)) {
            Set<String> globalVariableIdsUsedInMethod = cfg.getUsedGlobalVariables();
            skipGlobalVariable = variableName -> !globalVariableIdsUsedInMethod.contains(variableName);
        }
        HashSet<TaintGraphField> fieldReferences = new HashSet<TaintGraphField>();
        for (DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> result : analysisResultsOfInitializerMethods) {
            fieldReferences.addAll(MethodTaintAnalysisInitializer.getFieldReferencesFromTaintGraphAnalysisResult(result));
        }
        for (TaintGraphField field : fieldReferences) {
            String name = field.getSimpleFieldName();
            if (skipGlobalVariable.test(name)) continue;
            TextRegionLocation newLocation = TaintAnalysisUtils.createLocationForTokens((List<IToken>)cfg.getEntities().get(0).ownStartTokens(), this.element, this.offsetTransformer, this.rawLineOffsetConverter);
            TaintGraphField clone = (TaintGraphField)field.cloneWithNewSSA(INITIAL_FIELD_SSA_NAME, (ElementLocation)newLocation);
            state.putReferenceFor(name, clone);
        }
    }

    private static Set<TaintGraphField> getFieldReferencesFromTaintGraphAnalysisResult(DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> result) {
        HashSet<TaintGraphField> fieldReferences = new HashSet<TaintGraphField>();
        for (ControlFlowNode outNode : result.getFacts().getFirstKeys()) {
            for (Map.Entry entry : result.getFacts().getSecondMap((Object)outNode).entrySet()) {
                if (((TaintGraphReferenceBase)entry.getKey()).getType() != TaintGraphReferenceBase.EReferenceType.FIELD) continue;
                fieldReferences.add((TaintGraphField)entry.getKey());
            }
        }
        return fieldReferences;
    }
}

