/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public abstract class TaintGraphReferenceBase
implements Serializable,
Comparable<TaintGraphReferenceBase> {
    private static final long serialVersionUID = 1L;
    private final String referenceName;
    private final String ssaIndex;
    protected final String referenceContainerMethodId;
    private final ElementLocation location;
    protected transient Integer hashCodeCache = null;

    public String getSsaIndex() {
        return this.ssaIndex;
    }

    public @Nullable ElementLocation getLocation() {
        return this.location;
    }

    public @Nullable String getUniformPath() {
        if (this.location == null) {
            return null;
        }
        return this.location.getUniformPath();
    }

    protected TaintGraphReferenceBase(String referenceName, String ssaIndex, ElementLocation location, String referenceContainerMethodId) {
        this.ssaIndex = ssaIndex;
        this.referenceName = referenceName;
        CCSMAssert.isNotNull((Object)referenceName);
        this.location = location;
        this.referenceContainerMethodId = referenceContainerMethodId;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            return ((TaintGraphReferenceBase)obj).getReferenceName().equals(this.getReferenceName()) && ((TaintGraphReferenceBase)obj).getSsaIndex().equals(this.getSsaIndex()) && ((TaintGraphReferenceBase)obj).referenceContainerMethodId.equals(this.referenceContainerMethodId);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            this.hashCodeCache = Objects.hash(this.getSsaIndex(), this.getReferenceName(), this.referenceContainerMethodId);
        }
        return this.hashCodeCache;
    }

    public abstract TaintGraphReferenceBase cloneWithNewSSA(String var1, ElementLocation var2);

    public abstract EReferenceType getType();

    public abstract String toFindingDescription();

    @Override
    public int compareTo(TaintGraphReferenceBase other) {
        if (this.hashCode() != other.hashCode()) {
            if (this.hashCode() > other.hashCode()) {
                return 1;
            }
            return -1;
        }
        if (this.equals(other)) {
            return 0;
        }
        int referenceNameComparison = this.getReferenceName().compareTo(other.getReferenceName());
        if (referenceNameComparison != 0) {
            return referenceNameComparison;
        }
        int ssaComparison = this.getSsaIndex().compareTo(other.getSsaIndex());
        if (ssaComparison != 0) {
            return referenceNameComparison;
        }
        int methodIdComparison = this.referenceContainerMethodId.compareTo(other.referenceContainerMethodId);
        if (methodIdComparison != 0) {
            return methodIdComparison;
        }
        CCSMAssert.fail((String)"Mismatch between compareTo and equals method in TaintGraphReferenceBase.");
        return 0;
    }

    @IndexValueClass
    public static enum EReferenceType {
        FIELD,
        LOCAL,
        PARAMETER,
        RETURN_VALUE,
        SOURCE,
        SINK,
        METHOD_CALL_INPUT,
        METHOD_CALL_RETURN,
        RFC_SOURCE;

        public static final Set<EReferenceType> SOURCE_REFERENCE_TYPES;

        static {
            SOURCE_REFERENCE_TYPES = EnumSet.of(SOURCE, RFC_SOURCE);
        }
    }
}

