/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap;

import com.teamscale.index.dependencies.DependencyExtractionSettings;
import com.teamscale.index.dependencies.ITypeLookupEnvironment;
import com.teamscale.index.dependencies.abap.AbapDependencyCollection;
import com.teamscale.index.dependencies.abap.AbapGlobalTypeResolutionUtils;
import com.teamscale.index.dependencies.abap.AbapTypeNameUtils;
import com.teamscale.index.dependencies.type.AttributeDefinition;
import com.teamscale.index.dependencies.type.DetailedMethodSignature;
import com.teamscale.index.dependencies.type.Type;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.abap.AbapMethodCallRecognizer;
import eu.cqse.check.framework.util.tokens.TokenStreamParser;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.pattern.EnumPatternMatcher;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class AbapCallDependencyExtractor {
    private final ParsedAbapElementPath parsedUniformPath;
    private final AbapDependencyCollection dependencyCollection;
    private final ITypeLookupEnvironment typeLookupEnvironment;
    private final boolean includeIntermediaryTypesInCallChain;
    private static final EnumSet<ETokenType> CHAINED_METHOD_CALL_TOKEN_TYPES = EnumSet.of(ETokenType.ARROW, ETokenType.EQGT);
    private static final EnumSet<ETokenType> ABAP_IDENTIFIER_TOKEN_TYPES = EnumSet.of(ETokenType.IDENTIFIER, ETokenType.CHARACTER_LITERAL, ETokenType.STRING_LITERAL);
    private static final BiPredicate<Integer, List<IToken>> METHOD_CALL_MATCHING_PREDICATE = (index, tokens) -> index + 1 < tokens.size() && ABAP_IDENTIFIER_TOKEN_TYPES.contains(((IToken)tokens.get((int)index)).getType()) && ((IToken)tokens.get(index + 1)).getType() == ETokenType.LPAREN && ((IToken)tokens.get((int)index)).getEndOffset() + 1 == ((IToken)tokens.get(index + 1)).getOffset();
    private static final TokenTypePattern FUNCTION_CALL_PATTERN = new TokenTypePattern("<CALL><FUNCTION>(<IDENTIFIER>|<CHARACTER_LITERAL>|<STRING_LITERAL>)");
    private static final TokenTypePattern STATIC_METHOD_CALL_PATTERN = new TokenTypePattern("(<CALL><METHOD>)?<LPAREN>?(<IDENTIFIER>|<CHARACTER_LITERAL>|<STRING_LITERAL>)<RPAREN>?<EQGT><LPAREN>?(<IDENTIFIER>|<CHARACTER_LITERAL>|<STRING_LITERAL>)<RPAREN>?");
    private static final Predicate<IToken> TOKEN_IS_LITERAL_OR_IDENTIFIER = token -> token.getType().getTokenClass() == ETokenType.ETokenClass.LITERAL || token.getType() == ETokenType.IDENTIFIER;

    public AbapCallDependencyExtractor(ParsedAbapElementPath parsedUniformPath, DependencyExtractionSettings settings, AbapDependencyCollection dependencyCollection, ITypeLookupEnvironment typeLookupEnvironment) {
        this.parsedUniformPath = parsedUniformPath;
        this.includeIntermediaryTypesInCallChain = settings.includeIntermediaryTypesInCallChain;
        this.dependencyCollection = dependencyCollection;
        this.typeLookupEnvironment = typeLookupEnvironment;
    }

    void processFunctionCalls(List<IToken> tokens) throws StorageException {
        for (List match : FUNCTION_CALL_PATTERN.matchAll(tokens)) {
            IToken token = (IToken)match.get(2);
            String referencedFunctionName = AbapGlobalTypeResolutionUtils.getReferencedAbapName(token);
            this.dependencyCollection.addDependencyToFunction(referencedFunctionName, token);
        }
    }

    void processClassMethodCalls(List<ShallowEntity> entities, ITypeLookupEnvironment typeLookupEnvironment) throws StorageException {
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            UnmodifiableList tokens = statement.ownStartTokens();
            EnumPatternMatcher matcher = STATIC_METHOD_CALL_PATTERN.matcher((List)tokens);
            if (!matcher.find() || matcher.start() > 0 && ((IToken)tokens.get(matcher.start() - 1)).getType() == ETokenType.TYPE) continue;
            UnmodifiableList matchingTokens = tokens.subList(matcher.start(), matcher.end());
            int indexOfClassNameTokenInMatch = CollectionUtils.indexOfFirstMatch((List)matchingTokens, TOKEN_IS_LITERAL_OR_IDENTIFIER);
            CCSMAssert.isTrue((indexOfClassNameTokenInMatch != -1 ? 1 : 0) != 0, () -> "Could not find classname in static call: " + ((IToken)tokens.getFirst()).getOriginId() + ":" + ((IToken)tokens.getFirst()).getLineNumber());
            IToken classNameToken = (IToken)matchingTokens.get(indexOfClassNameTokenInMatch);
            this.dependencyCollection.processTypeReference(AbapGlobalTypeResolutionUtils.getReferencedAbapName(classNameToken), classNameToken);
            Optional<Type> referencedType = AbapGlobalTypeResolutionUtils.lookupType(classNameToken.getText(), typeLookupEnvironment, EAbapObjectType.ALL_ABAP_DATA_TYPES);
            if (referencedType.isEmpty()) continue;
            int indexOfClassNameToken = TokenStreamUtils.indexOfByOffset((List)tokens, (int)classNameToken.getOffset());
            int indexOfArrowToken = TokenStreamUtils.firstTokenMatching((List)tokens, (int)indexOfClassNameToken, (ITokenMatcher)ETokenType.EQGT);
            Optional<PotentiallyUnknownType> returnType = this.processCallChainAndReturnFinalReturnType(referencedType.get(), (List<IToken>)tokens, indexOfArrowToken + 1);
            if (indexOfClassNameToken == 0 || !returnType.isPresent()) continue;
            this.dependencyCollection.addDependencyToReturnType(returnType.get(), (IToken)tokens.getFirst());
        }
    }

    void processInstanceMethodCall(List<ShallowEntity> entities, ITypeLookupEnvironment typeLookupEnvironment, ITypeResolution typeResolution) throws StorageException {
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            if (TokenStreamUtils.containsSequence((List)statement.ownStartTokens(), (ITokenMatcher[])AbapGlobalTypeResolutionUtils.CONSTRUCTOR_CALL_SEQUENCE)) {
                this.processConstructorCall(statement, typeLookupEnvironment);
                continue;
            }
            if (!TokenStreamUtils.containsTokenIndexPredicate((List)statement.ownStartTokens(), METHOD_CALL_MATCHING_PREDICATE)) continue;
            this.processNormalInstanceMethodCall(statement, typeResolution, typeLookupEnvironment);
        }
    }

    private Optional<PotentiallyUnknownType> processCallChainAndReturnFinalReturnType(Type initialSubjectType, List<IToken> tokens, int methodIdentifierStartTokenIndex) throws StorageException {
        Optional<PotentiallyUnknownType> subjectTypeInfo = Optional.of(new PotentiallyUnknownType(initialSubjectType, initialSubjectType.getName()));
        TokenStreamParser parser = new TokenStreamParser(tokens, methodIdentifierStartTokenIndex);
        while (subjectTypeInfo.isPresent() && !parser.isDone()) {
            if (!subjectTypeInfo.get().preciseTypeIsKnown()) {
                return Optional.empty();
            }
            Type subjectType = subjectTypeInfo.get().preciseType;
            parser.consumeAnyOf(EnumSet.of(ETokenType.EQGT, ETokenType.ARROW));
            int iterationStartIndex = parser.getConsumedTokenCount();
            if (parser.previousTokenTypeIs(ETokenType.EQGT)) {
                subjectTypeInfo = this.processStaticCallAndGetReturnType(subjectType, parser);
            } else if (parser.previousTokenTypeIs(ETokenType.ARROW)) {
                subjectTypeInfo = this.processInstanceCallAndGetReturnType(subjectType, parser);
            } else if (iterationStartIndex == 0 || parser.previousTokenTypeIs(ETokenType.EQ)) {
                subjectTypeInfo = this.processInstanceCallAndGetReturnType(subjectTypeInfo.get().preciseType, parser);
            } else {
                return Optional.empty();
            }
            if (parser.isAnyOf(EnumSet.of(ETokenType.DOT))) {
                return subjectTypeInfo;
            }
            if (!this.includeIntermediaryTypesInCallChain || parser.isDone() || !subjectTypeInfo.isPresent()) continue;
            this.dependencyCollection.addDependencyToReturnType(subjectTypeInfo.get(), (IToken[])CollectionUtils.toArray(tokens.subList(iterationStartIndex, parser.getConsumedTokenCount()), IToken.class));
        }
        return subjectTypeInfo;
    }

    private Optional<PotentiallyUnknownType> processStaticCallAndGetReturnType(Type subjectType, TokenStreamParser parser) throws StorageException {
        Optional<Object> returnTypeName;
        Optional firstIdentifier = parser.consumeOneOrZeroOf(ABAP_IDENTIFIER_TOKEN_TYPES);
        if (firstIdentifier.isEmpty()) {
            return Optional.empty();
        }
        Optional<Object> returnType = Optional.empty();
        if (parser.currentType() == ETokenType.LPAREN) {
            Optional<DetailedMethodSignature> calledSignature = AbapGlobalTypeResolutionUtils.getCalledMethodSignature(((IToken)firstIdentifier.get()).getText(), subjectType, this.typeLookupEnvironment);
            returnTypeName = calledSignature.flatMap(AbapGlobalTypeResolutionUtils::getMethodReturnType);
            if (returnTypeName.isPresent()) {
                returnType = AbapGlobalTypeResolutionUtils.findType((String)returnTypeName.get(), subjectType.getName(), this.typeLookupEnvironment);
            }
            if (calledSignature.isPresent()) {
                this.parseParameterListAndHandleDataDeclarations(parser, calledSignature.get());
            }
        } else if (CHAINED_METHOD_CALL_TOKEN_TYPES.contains(parser.currentType()) || parser.currentType() == ETokenType.DOT) {
            returnTypeName = AbapCallDependencyExtractor.getTypeOfAttribute(subjectType, ((IToken)firstIdentifier.get()).getText()).map(AbapGlobalTypeResolutionUtils::stripRefTo);
            returnType = returnTypeName.flatMap(typeName -> AbapGlobalTypeResolutionUtils.findType(typeName, this.parsedUniformPath, this.typeLookupEnvironment));
        } else {
            return Optional.empty();
        }
        return PotentiallyUnknownType.createFromOrEmpty(returnType.orElse(null), returnTypeName.orElse(null));
    }

    private Optional<PotentiallyUnknownType> processInstanceCallAndGetReturnType(Type subjectType, TokenStreamParser parser) throws StorageException {
        Optional<Object> returnTypeName = Optional.empty();
        Optional<Object> returnType = Optional.empty();
        Optional firstIdentifier = parser.consumeOneOrZeroOf(ABAP_IDENTIFIER_TOKEN_TYPES);
        Optional secondIdentifier = Optional.empty();
        if (parser.consumeOneOrZeroOf(ETokenType.TILDE).isPresent()) {
            secondIdentifier = parser.consumeOneOrZeroOf(ABAP_IDENTIFIER_TOKEN_TYPES);
        }
        if (firstIdentifier.isPresent() && secondIdentifier.isPresent()) {
            IToken targetTypeToken = (IToken)firstIdentifier.get();
            IToken methodNameToken = (IToken)secondIdentifier.get();
            Optional<Type> subjectInterfaceType = this.lookupTypeInTypeList(targetTypeToken.getText(), this.typeLookupEnvironment);
            if (subjectInterfaceType.isEmpty()) {
                return Optional.empty();
            }
            Optional<DetailedMethodSignature> calledSignature = AbapGlobalTypeResolutionUtils.getCalledMethodSignature(methodNameToken.getText(), subjectInterfaceType.get(), this.typeLookupEnvironment);
            returnTypeName = calledSignature.flatMap(AbapGlobalTypeResolutionUtils::getMethodReturnType);
            returnType = returnTypeName.flatMap(typeName -> this.lookupTypeInTypeList((String)typeName, this.typeLookupEnvironment));
            if (calledSignature.isPresent()) {
                this.parseParameterListAndHandleDataDeclarations(parser, calledSignature.get());
            }
        } else if (firstIdentifier.isPresent() && parser.currentType() == ETokenType.LPAREN) {
            IToken methodNameToken = (IToken)firstIdentifier.get();
            Optional<DetailedMethodSignature> calledSignature = AbapGlobalTypeResolutionUtils.getCalledMethodSignature(methodNameToken.getText(), subjectType, this.typeLookupEnvironment);
            returnTypeName = calledSignature.flatMap(AbapGlobalTypeResolutionUtils::getMethodReturnType);
            returnType = returnTypeName.flatMap(typeName -> AbapGlobalTypeResolutionUtils.findType(typeName, subjectType.getName(), this.typeLookupEnvironment));
            if (calledSignature.isPresent()) {
                this.parseParameterListAndHandleDataDeclarations(parser, calledSignature.get());
            }
        } else if (firstIdentifier.isPresent() && CHAINED_METHOD_CALL_TOKEN_TYPES.contains(parser.currentType())) {
            returnTypeName = AbapCallDependencyExtractor.getTypeOfAttribute(subjectType, ((IToken)firstIdentifier.get()).getText()).map(AbapGlobalTypeResolutionUtils::stripRefTo);
            returnType = returnTypeName.flatMap(typeName -> AbapGlobalTypeResolutionUtils.findType(typeName, subjectType.getName(), this.typeLookupEnvironment));
        }
        return PotentiallyUnknownType.createFromOrEmpty(returnType.orElse(null), returnTypeName.orElse(null));
    }

    private void parseParameterListAndHandleDataDeclarations(TokenStreamParser parser, DetailedMethodSignature calledSignature) throws StorageException {
        Pair parameterTokens = parser.skipBalancedParentheses();
        if (!((Boolean)parameterTokens.getFirst()).booleanValue()) {
            return;
        }
        List tokens = (List)parameterTokens.getSecond();
        Optional methodCall = AbapMethodCallRecognizer.parseParameterList((List)tokens, (String)calledSignature.methodName);
        if (methodCall.isEmpty()) {
            return;
        }
        List dataDeclarationIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence((List)tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.DATA, ETokenType.LPAREN});
        for (Map.Entry importingParameter : ((AbapMethodCallRecognizer.MethodCallInfo)methodCall.get()).getImportingParameters().entrySet()) {
            String parameterValue = (String)importingParameter.getValue();
            if (!parameterValue.toUpperCase().contains("DATA (")) continue;
            String parameterName = parameterValue.substring("DATA (".length(), parameterValue.length() - 1).trim();
            Optional<Integer> parameterNameTokenIndex = dataDeclarationIndices.stream().filter(index -> ((IToken)tokens.get(index + 2)).getText().equalsIgnoreCase(parameterName)).findFirst();
            Optional<String> importingType = AbapCallDependencyExtractor.getExportingParameterTypeName(calledSignature, (String)importingParameter.getKey());
            if (!importingType.isPresent() || !parameterNameTokenIndex.isPresent()) continue;
            this.dependencyCollection.processTypeReference(importingType.get(), tokens.subList(parameterNameTokenIndex.get(), parameterNameTokenIndex.get() + 4).toArray(new IToken[0]));
        }
    }

    private static Optional<String> getTypeOfAttribute(Type subjectType, String attributeName) {
        return subjectType.getAttributeByName(attributeName).map(AttributeDefinition::getType);
    }

    private void processConstructorCall(ShallowEntity statement, ITypeLookupEnvironment typeLookupEnvironment) throws AssertionError, StorageException {
        int startIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)statement.ownStartTokens(), (int)0, (ETokenType[])AbapGlobalTypeResolutionUtils.CONSTRUCTOR_CALL_SEQUENCE);
        CCSMAssert.isTrue((startIndex != -1 ? 1 : 0) != 0, (String)("called with non-matching shallow entity: " + String.valueOf(statement)));
        IToken constructedTypeNameToken = (IToken)statement.ownStartTokens().get(startIndex + 1);
        String constructedTypeName = constructedTypeNameToken.getText();
        if (constructedTypeName.equals("#")) {
            return;
        }
        Optional<Type> constructedType = this.lookupTypeInTypeList(constructedTypeName, typeLookupEnvironment);
        if (constructedType.isPresent()) {
            this.dependencyCollection.addDependencyToResolvedType(constructedType.get(), (IToken)statement.ownStartTokens().get(startIndex));
            int startAfterConstructorIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)statement.ownStartTokens(), (int)startIndex, (ETokenType[])new ETokenType[]{ETokenType.RPAREN});
            Optional<PotentiallyUnknownType> returnType = this.processCallChainAndReturnFinalReturnType(constructedType.get(), (List<IToken>)statement.ownStartTokens(), startAfterConstructorIndex + 2);
            if (startAfterConstructorIndex != 0 && returnType.isPresent()) {
                this.dependencyCollection.addDependencyToReturnType(returnType.get(), constructedTypeNameToken);
            }
        } else {
            this.dependencyCollection.addDependency(constructedTypeName, (IToken)statement.ownStartTokens().get(startIndex), (EnumSet<EAbapObjectType>)EAbapObjectType.ALL_OO_TYPES);
        }
    }

    private Optional<Type> lookupTypeInTypeList(String typeName, ITypeLookupEnvironment typeLookupEnvironment) {
        Optional<Type> type = AbapGlobalTypeResolutionUtils.lookupType(typeName, typeLookupEnvironment, EAbapObjectType.ALL_ABAP_DATA_TYPES);
        if (type.isPresent()) {
            return type;
        }
        return this.lookupInnerTypeInIncludesOfOwnObject(typeName, typeLookupEnvironment);
    }

    private Optional<Type> lookupInnerTypeInIncludesOfOwnObject(String typeName, ITypeLookupEnvironment typeLookupEnvironment) {
        String innerTypeName = AbapTypeNameUtils.buildInnerTypeName(this.parsedUniformPath, typeName, null);
        return AbapGlobalTypeResolutionUtils.lookupType(innerTypeName, typeLookupEnvironment, EAbapObjectType.ALL_ABAP_DATA_TYPES);
    }

    private void processNormalInstanceMethodCall(ShallowEntity statement, ITypeResolution typeResolution, ITypeLookupEnvironment typeLookupEnvironment) throws StorageException {
        int methodNameTokenIndex = TokenStreamUtils.firstTokenMatchingIndexPredicate((List)statement.ownStartTokens(), (int)0, METHOD_CALL_MATCHING_PREDICATE);
        int methodIdentifierTokenIndex = AbapCallDependencyExtractor.determineStartIndexOfMethodIdentifier((List<IToken>)statement.ownStartTokens(), methodNameTokenIndex);
        CCSMAssert.isTrue((methodNameTokenIndex != -1 ? 1 : 0) != 0, (String)("called with non-matching shallow entity: " + String.valueOf(statement)));
        Optional<Type> subjectType = this.determineCallSubjectType(methodNameTokenIndex, statement, typeResolution, typeLookupEnvironment);
        if (subjectType.isEmpty()) {
            return;
        }
        IToken methodNameToken = (IToken)statement.ownStartTokens().get(methodNameTokenIndex);
        Optional<PotentiallyUnknownType> returnType = this.processCallChainAndReturnFinalReturnType(subjectType.get(), (List<IToken>)statement.ownStartTokens(), methodIdentifierTokenIndex);
        if (returnType.isPresent() && TokenStreamUtils.containsAny((List)statement.ownStartTokens(), (int)0, (int)methodIdentifierTokenIndex, (ETokenType[])new ETokenType[]{ETokenType.EQ})) {
            this.dependencyCollection.addDependencyToReturnType(returnType.get(), methodNameToken);
        }
    }

    private static int determineStartIndexOfMethodIdentifier(List<IToken> tokens, int methodNameTokenIndex) {
        for (int i = methodNameTokenIndex; i >= 0; --i) {
            if (!EnumSet.of(ETokenType.EQ, ETokenType.ARROW, ETokenType.EQGT).contains(tokens.get(i).getType())) continue;
            return i + 1;
        }
        return 0;
    }

    private Optional<Type> determineCallSubjectType(int methodNameTokenIndex, ShallowEntity statement, ITypeResolution typeResolution, ITypeLookupEnvironment typeLookupEnvironment) {
        UnmodifiableList statementTokens = statement.ownStartTokens();
        int callSymbolTokenIndex = AbapCallDependencyExtractor.previousTokenMatchingIndexPredicate((UnmodifiableList<IToken>)statementTokens, methodNameTokenIndex, (index, predicateTokens) -> EnumSet.of(ETokenType.ARROW, ETokenType.GTEQ, ETokenType.EQ).contains(((IToken)predicateTokens.get((int)index)).getType()));
        if (callSymbolTokenIndex == -1 || ((IToken)statementTokens.get(callSymbolTokenIndex)).getType() == ETokenType.EQ) {
            return this.determineCurrentType(statement, typeLookupEnvironment);
        }
        if (callSymbolTokenIndex == 0) {
            return Optional.empty();
        }
        String instanceIdentifierName = ((IToken)statementTokens.get(callSymbolTokenIndex - 1)).getText();
        if (instanceIdentifierName.equalsIgnoreCase("ME")) {
            return this.determineCurrentType(statement, typeLookupEnvironment);
        }
        if (instanceIdentifierName.equalsIgnoreCase("SUPER")) {
            Optional<Type> parentType = this.determineCurrentType(statement, typeLookupEnvironment);
            return parentType.flatMap(type -> this.getFirstSuperType((Type)type, typeLookupEnvironment));
        }
        TypedVariable subjectTypeInfo = typeResolution.getTypeLookup(statement).getTypeInfo(instanceIdentifierName);
        if (subjectTypeInfo == null) {
            return Optional.empty();
        }
        return this.lookupTypeInTypeList(AbapGlobalTypeResolutionUtils.stripRefTo(subjectTypeInfo.getTypeNameWithoutGenericTypeParameter()), typeLookupEnvironment);
    }

    private static int previousTokenMatchingIndexPredicate(UnmodifiableList<IToken> tokens, int methodNameTokenIndex, BiPredicate<Integer, List<IToken>> matcher) {
        for (int i = methodNameTokenIndex; i >= 0; --i) {
            if (!matcher.test(i, (List<IToken>)tokens)) continue;
            return i;
        }
        return -1;
    }

    private Optional<Type> determineCurrentType(ShallowEntity statement, ITypeLookupEnvironment typeLookupEnvironment) {
        Optional parentTypeEntity = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)statement, entity -> entity.getType() == EShallowEntityType.TYPE);
        if (parentTypeEntity.isEmpty()) {
            return Optional.empty();
        }
        return this.lookupTypeInTypeList(((ShallowEntity)parentTypeEntity.get()).getName(), typeLookupEnvironment);
    }

    private Optional<Type> getFirstSuperType(Type type, ITypeLookupEnvironment typeLookupEnvironment) {
        List<String> supertypes = type.getSuperTypes();
        if (supertypes.isEmpty()) {
            return Optional.empty();
        }
        return this.lookupTypeInTypeList(supertypes.getFirst(), typeLookupEnvironment);
    }

    private static Optional<String> getExportingParameterTypeName(DetailedMethodSignature signature, String parameterName) {
        for (TypedVariable parameter : signature.parameters) {
            if (!parameter.getModifiers().stream().anyMatch(modifier -> modifier.getType() == ETokenType.EXPORTING) || !parameter.getVariableName().equalsIgnoreCase(parameterName)) continue;
            if (!parameter.getTypeNameWithoutGenericTypeParameter().equals("<unknown type>")) {
                return Optional.of(AbapGlobalTypeResolutionUtils.stripRefTo(parameter.getTypeNameWithoutGenericTypeParameter()));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static class PotentiallyUnknownType {
        public final @Nullable Type preciseType;
        public final String typeName;

        public PotentiallyUnknownType(@Nullable Type preciseType, String typeName) {
            this.preciseType = preciseType;
            this.typeName = Objects.requireNonNull(typeName, "typeName");
        }

        private static Optional<PotentiallyUnknownType> createFromOrEmpty(@Nullable Type preciseType, @Nullable String typeName) {
            if (typeName == null) {
                return Optional.empty();
            }
            return Optional.of(new PotentiallyUnknownType(preciseType, typeName));
        }

        public boolean preciseTypeIsKnown() {
            return this.preciseType != null;
        }
    }
}

