/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.dart;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

public class DartDependencyExtractor
extends DependencyExtractorBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws StorageException {
        ArrayList<TypeDependencies> dependencies = new ArrayList<TypeDependencies>();
        if (this.uniformPath.endsWith("pubspec.yaml")) {
            return dependencies;
        }
        ListMap dependenciesOfCurrentFile = new ListMap();
        String currentFileAsType = DartDependencyExtractor.formatPathAsType(this.uniformPath);
        ShallowEntity.traverse(tokenElementInfo.getRawShallowEntities(), entity -> {
            if (!DartDependencyExtractor.isImport(entity)) {
                return false;
            }
            Optional<IToken> importToken = DartDependencyExtractor.getStringTokenOfImport(entity);
            if (importToken.isEmpty()) {
                LOGGER.warn("Import statement in {} has unexpected format, ignoring: {}", (Object)this.uniformPath, (Object)TokenStreamTextUtils.concatTokenTexts((List)entity.includedTokens()));
                return false;
            }
            String importUri = StringUtils.removeDoubleQuotes((String)StringUtils.removeSingleQuotes((String)importToken.get().getText()));
            if (importUri.startsWith("package:")) {
                this.processPackageImport(importToken.get(), importUri, currentFileAsType, (ListMap<String, ElementLocation>)dependenciesOfCurrentFile);
            } else if (importUri.startsWith("dart:")) {
                this.processDartFrameworkImport(importToken.get(), importUri, (ListMap<String, ElementLocation>)dependenciesOfCurrentFile);
            } else if (!importUri.contains(":")) {
                this.processRelativeImport(importToken.get(), importUri, (ListMap<String, ElementLocation>)dependenciesOfCurrentFile);
            } else {
                LOGGER.warn("Unknown or unsupported Dart import in file {}: {}", (Object)this.uniformPath, (Object)importUri);
            }
            return false;
        });
        dependencies.add(new TypeDependencies(currentFileAsType, (ListMap<String, ElementLocation>)dependenciesOfCurrentFile));
        return dependencies;
    }

    private static @NonNull Optional<IToken> getStringTokenOfImport(ShallowEntity entity) {
        return entity.includedTokens().stream().filter(token -> token.getType() == ETokenType.STRING_LITERAL).findFirst();
    }

    private static boolean isImport(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("import");
    }

    private void processPackageImport(IToken importToken, String rawImport, String currentFileAsType, ListMap<String, ElementLocation> dependenciesOfCurrentFile) {
        String importWithoutPackageKeyword = StringUtils.stripPrefix((String)rawImport, (String)"package:");
        String packageName = StringUtils.getFirstPart((String)importWithoutPackageKeyword, (String)"/");
        try {
            Optional<String> rootPathOfPackageDeclaredInRepo = this.dependencyExtractionIndexes.dartPackagePathsIndex.getUniformPathForPackageName(packageName);
            if (rootPathOfPackageDeclaredInRepo.isPresent()) {
                String dependencyAsType;
                Object uniformPathOfDependency = rootPathOfPackageDeclaredInRepo.get();
                if (!((String)uniformPathOfDependency).isEmpty()) {
                    uniformPathOfDependency = (String)uniformPathOfDependency + "/";
                }
                if (!currentFileAsType.equals(dependencyAsType = DartDependencyExtractor.formatPathAsType((String)(uniformPathOfDependency = (String)uniformPathOfDependency + StringUtils.stripPrefix((String)rawImport, (String)("package:" + packageName + "/")))))) {
                    this.addDependencyIfEnabled(dependenciesOfCurrentFile, dependencyAsType, importToken);
                }
            } else if (this.settings.includeThirdPartyDependencies) {
                this.addDependencyIfEnabled(dependenciesOfCurrentFile, DartDependencyExtractor.formatPathAsType(importWithoutPackageKeyword), importToken);
            }
        }
        catch (StorageException e) {
            LOGGER.error("Error reading from dart paths index", (Throwable)e);
        }
    }

    private void processDartFrameworkImport(IToken importToken, String importUri, ListMap<String, ElementLocation> dependenciesOfCurrentFile) {
        this.addDependencyIfEnabled(dependenciesOfCurrentFile, DartDependencyExtractor.formatPathAsType(importUri), importToken);
    }

    private void processRelativeImport(IToken importToken, String importUri, ListMap<String, ElementLocation> dependenciesOfCurrentFile) {
        importUri = StringUtils.stripPrefix((String)importUri, (String)"./");
        String importedFilePath = UniformPathUtils.resolveRelativePath((String)this.uniformPath, (String)importUri);
        this.addDependencyIfEnabled(dependenciesOfCurrentFile, DartDependencyExtractor.formatPathAsType(importedFilePath), importToken);
    }

    private void addDependencyIfEnabled(ListMap<String, ElementLocation> dependenciesOfCurrentFile, String typePath, IToken importToken) {
        if (this.settings.includeThirdPartyDependencies || this.typeLookupEnvironment.isKnownType(typePath)) {
            dependenciesOfCurrentFile.add((Object)typePath, (Object)DartDependencyExtractor.createLocation(this.uniformPath, importToken));
        }
    }

    private static String formatPathAsType(String path) {
        return StringUtils.stripSuffix((String)path, (String)".dart").replace(".", "_").replace("/", ".");
    }
}

