/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.iec;

import com.teamscale.index.dependencies.TypeExtractorBase;
import com.teamscale.index.dependencies.type.Type;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class StructuredTextTypeExtractor
extends TypeExtractorBase {
    private static final Set<ETokenType> TYPE_DECLARATION_KEYWORDS = CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.ALGORITHM, ETokenType.ALGORITHM_BLOCK, ETokenType.FUNCTION, ETokenType.FUNCTION_BLOCK, ETokenType.PROGRAM});

    @Override
    public List<Type> extractTypes(String uniformPath, String content, ELanguage language) {
        ArrayList<String> typeNames = new ArrayList<String>();
        List tokens = ScannerUtils.getTokens((String)content, (ELanguage)language, (String)uniformPath);
        IToken previousToken = null;
        for (IToken token : tokens) {
            if (token.getType().isIdentifier() && previousToken != null && TYPE_DECLARATION_KEYWORDS.contains(previousToken.getType())) {
                typeNames.add(token.getText());
            }
            previousToken = token;
        }
        typeNames.addAll(StructuredTextTypeExtractor.extractTypesFromTypedefStatements(tokens, language));
        return StructuredTextTypeExtractor.toTypes(typeNames);
    }

    private static List<String> extractTypesFromTypedefStatements(List<IToken> tokens, ELanguage language) {
        List ast;
        try {
            ast = ShallowParserFactory.createParser((ELanguage)language).parseTopLevel(tokens);
        }
        catch (ShallowParserException e) {
            return Collections.emptyList();
        }
        ArrayList<String> structTypeNames = new ArrayList<String>();
        List typeEntities = ShallowEntityTraversalUtils.listMatchingEntitiesRecursive((List)ast, entity -> entity.getType() == EShallowEntityType.META && "TYPE".equals(entity.getSubtype()));
        for (ShallowEntity typeEntity : typeEntities) {
            for (ShallowEntity typedef : typeEntity.getChildrenOfType(EShallowEntityType.ATTRIBUTE)) {
                if (!"typedef".equals(typedef.getSubtype())) continue;
                structTypeNames.add(typedef.getName());
            }
        }
        return structTypeNames;
    }
}

