/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.javascript;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.javascript.ContextAwareJavascriptDependencyExtractor;
import com.teamscale.index.dependencies.javascript.JavascriptDependencyExtractor;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CommonJSDependencyExtractor
extends ContextAwareJavascriptDependencyExtractor {
    public CommonJSDependencyExtractor(JavascriptDependencyExtractor extractorContext) {
        super(extractorContext);
    }

    @Override
    public ListMap<String, ElementLocation> getDependenciesLocations(TokenElementInfo tokenElementInfo) {
        ListMap locations = new ListMap();
        UnmodifiableList<IToken> tokens = tokenElementInfo.getTokens();
        int i = 0;
        while (i + 3 < tokens.size()) {
            if (CommonJSDependencyExtractor.isRequireCall(tokens, i)) {
                List<String> possiblyIncurredDependency;
                String importString = ((IToken)tokens.get(i + 2)).getText();
                int index = i;
                if (CommonJSDependencyExtractor.callIsFollowedByMemberAccess(tokens, i + 4)) {
                    possiblyIncurredDependency = this.extractorContext.resolveSingleDependency(importString, ((IToken)tokens.get(i + 5)).getText());
                    i += 2;
                } else {
                    possiblyIncurredDependency = this.extractorContext.resolveStarDependency(importString);
                }
                possiblyIncurredDependency.forEach(type -> locations.add(type, (Object)DependencyExtractorBase.createLocation(tokenElementInfo.getUniformPath(), (IToken)tokens.get(index), (IToken)tokens.get(index + 3))));
                i += 3;
            }
            ++i;
        }
        return locations;
    }

    private static boolean callIsFollowedByMemberAccess(List<IToken> tokens, int indexOfPossibleMemberAccess) {
        return indexOfPossibleMemberAccess + 1 < tokens.size() && tokens.get(indexOfPossibleMemberAccess).getType() == ETokenType.DOT && tokens.get(indexOfPossibleMemberAccess + 1).getType() == ETokenType.IDENTIFIER;
    }

    private static boolean isRequireCall(List<IToken> tokens, int i) {
        return (i == 0 || tokens.get(i - 1).getType() != ETokenType.DOT) && tokens.get(i).getType() == ETokenType.IDENTIFIER && tokens.get(i).getText().equals("require") && tokens.get(i + 1).getType() == ETokenType.LPAREN && tokens.get(i + 2).getType() == ETokenType.STRING_LITERAL && tokens.get(i + 3).getType() == ETokenType.RPAREN;
    }
}

