/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.commons.StreamUtils;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.IOutgoingExternalAnalysisArchive;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.ZipFileUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OutgoingExternalAnalysisArchive
implements IOutgoingExternalAnalysisArchive {
    private final String targetPath;
    private final byte[] content;
    private final long dataSize;

    public OutgoingExternalAnalysisArchive(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration, Collection<ExternalAnalysisImportInfoReport> reports) throws IOException {
        this.targetPath = OutgoingExternalAnalysisArchive.buildTargetPath(session, projectConfiguration);
        try (ByteArrayOutputStream contentStream = new ByteArrayOutputStream();){
            this.dataSize = StreamUtils.writeWithByteCounter((OutputStream)contentStream, stream -> OutgoingExternalAnalysisArchive.writeArchive(reports, stream));
            this.content = contentStream.toByteArray();
        }
    }

    @Override
    public InputStream getDataStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public String getTargetPath() {
        return this.targetPath;
    }

    private static String buildTargetPath(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration) {
        ArrayList<Object> pathElements = new ArrayList<Object>();
        ExternalStorageBackend externalStorage = Objects.requireNonNull(session.getTargetStorage());
        pathElements.add(StringUtils.strip((String)externalStorage.uploadPathPrefix(), (String)"/"));
        pathElements.add(projectConfiguration.getExternalStorageProjectMappingId().toString());
        if (!StringUtils.isEmpty((String)session.getRevision())) {
            pathElements.addAll(OutgoingExternalAnalysisArchive.buildRevisionBasedTargetPath(Objects.requireNonNull(session.getRevision())));
        } else {
            pathElements.addAll(OutgoingExternalAnalysisArchive.getTimestampAndBranchBasedTargetPathElements(session.getCommit()));
        }
        pathElements.addAll(List.of("__partitions__", session.getPartition(), "__reports__", session.getSessionId() + ".zip"));
        return pathElements.stream().filter(Predicate.not(StringUtils::isEmpty)).collect(Collectors.joining("/"));
    }

    private static List<String> getTimestampAndBranchBasedTargetPathElements(CommitDescriptor commit) {
        return List.of("__branches__", commit.getBranchName(), "__timestamps__", Long.toString(commit.getTimestamp()));
    }

    private static List<String> buildRevisionBasedTargetPath(String revision) {
        return List.of("__revisions__", revision);
    }

    private static void writeArchive(Collection<ExternalAnalysisImportInfoReport> reports, OutputStream stream) throws IOException {
        try (ZipArchiveOutputStream archive = new ZipArchiveOutputStream(stream);){
            for (ExternalAnalysisImportInfoReport report : reports) {
                Pair pathSplitByFileEnding = StringUtils.splitAtLast((String)report.getReportUniformPath(), (char)'.');
                long hash = XXHashUtils.xxhash64((String)report.getData());
                String uniqueReportUniformPath = (String)pathSplitByFileEnding.getFirst() + "_" + hash + "." + (String)pathSplitByFileEnding.getSecond();
                ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)archive, (String)String.join((CharSequence)"/", report.getReportFormat(), uniqueReportUniformPath), (CharSequence)report.getData());
            }
        }
    }
}

