/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration.commit_clustering;

import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitAndPartition;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitCluster;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitClusteringStrategyBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ClusterByCodeCommitStrategy
extends CommitClusteringStrategyBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    protected @Nullable List<CommitCluster> clusterCommitsOnBranch(LinkedList<CommitAndPartition> uploadCommits, @Nullable LinkedList<CommitDescriptor> codeCommits) {
        if (CollectionUtils.isNullOrEmpty(codeCommits)) {
            LOGGER.error("Unable to cluster commits on branch {}, no relevant code commits found", (Object)uploadCommits.getFirst().commit().getBranchName());
            return null;
        }
        ArrayList<CommitCluster> commitClusters = new ArrayList<CommitCluster>();
        CommitDescriptor targetCodeCommit = codeCommits.poll();
        while (!uploadCommits.isEmpty()) {
            long uploadTimestamp = uploadCommits.peek().commit().getTimestamp();
            while (!codeCommits.isEmpty() && codeCommits.peek().getTimestamp() <= uploadTimestamp) {
                targetCodeCommit = codeCommits.poll();
            }
            if (codeCommits.isEmpty()) {
                commitClusters.add(new CommitCluster(targetCodeCommit, uploadCommits));
                return commitClusters;
            }
            ArrayList<CommitAndPartition> cluster = new ArrayList<CommitAndPartition>();
            while (!uploadCommits.isEmpty() && uploadCommits.peek().commit().getTimestamp() < Objects.requireNonNull(codeCommits.peek()).getTimestamp()) {
                cluster.add(uploadCommits.poll());
            }
            commitClusters.add(new CommitCluster(targetCodeCommit, cluster));
        }
        return commitClusters;
    }
}

