/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.info;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.report.EReportFormat;
import net.jpountz.xxhash.StreamingXXHash64;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisImportInfoReport
extends ExternalAnalysisImportInfo<String> {
    private static final long serialVersionUID = 1L;
    private static final String RAW_REPORTS_PATH_PREFIX = "##raw-reports-uniform-path##-";
    private static final String PATH_PREFIX_PROPERTY = "pathPrefix";
    private static final String REPORT_FORMAT_PROPERTY = "reportFormat";
    private static final String REPORT_CONTENT_PROPERTY = "reportContent";
    @JsonProperty(value="reportContent")
    private final String reportContent;
    @JsonProperty(value="pathPrefix")
    private final String pathPrefix;
    @JsonProperty(value="reportFormat")
    private final String reportFormat;

    @JsonCreator
    public ExternalAnalysisImportInfoReport(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="pathPrefix") String pathPrefix, @JsonProperty(value="reportFormat") String reportFormat, @JsonProperty(value="reportContent") String reportContent) {
        super(uniformPath);
        this.reportFormat = reportFormat;
        this.pathPrefix = StringUtils.emptyIfNull((String)pathPrefix);
        this.reportContent = reportContent;
    }

    @Override
    public String getData() {
        return this.reportContent;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    @Override
    public ExternalAnalysisResult<String> createAnalysisResult() {
        throw new UnsupportedOperationException("This method should never be called. Raw reports need to be parsed into regular reports instead.");
    }

    public static boolean isRawReportPath(String uniformPath) {
        return uniformPath.startsWith(RAW_REPORTS_PATH_PREFIX);
    }

    public String toString() {
        return "ExternalAnalysisImportInfoReport{reportContent=" + this.reportContent + ", pathPrefix='" + this.pathPrefix + ", reportFormat='" + this.reportFormat + "}";
    }

    public String getReportUniformPath() {
        CCSMAssert.isTrue((this.getReportUniformPaths().size() == 1 ? 1 : 0) != 0, (String)"Expected report uniform paths to exactly contain one path, but were %s: %s.".formatted(this.getReportUniformPaths().size(), this.getReportUniformPaths()));
        return this.getReportUniformPaths().iterator().next();
    }

    public static class Builder {
        private final StreamingXXHash64 hash = XXHashUtils.streamingHash64();
        private final String pathPrefix;
        private final EReportFormat reportFormat;
        private static final String DEFAULT_REPORT_DOWNLOAD_NAME = "report.txt";
        private final PairList<String, String> reports = new PairList();
        private @Nullable String repositoryId;

        public Builder(String pathPrefix, EReportFormat reportFormat) {
            this.pathPrefix = pathPrefix;
            this.reportFormat = reportFormat;
        }

        public Builder addReport(String filename, String report) {
            this.reports.add((Object)filename, (Object)report);
            int chunkSize = 1000;
            for (int i = 0; i < report.length(); i += chunkSize) {
                XXHashUtils.updateHash((StreamingXXHash64)this.hash, (String)report.substring(i, Math.min(report.length(), i + chunkSize)));
            }
            return this;
        }

        public Builder addRepositoryId(@Nullable String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public ExternalAnalysisImportInfos build() {
            String uniformPath = ExternalAnalysisImportInfoReport.RAW_REPORTS_PATH_PREFIX + Long.toHexString(this.hash.getValue());
            ExternalAnalysisImportInfos importInfos = new ExternalAnalysisImportInfos();
            for (Pair fileAndReport : this.reports) {
                ExternalAnalysisImportInfoReport reportInfo = new ExternalAnalysisImportInfoReport(uniformPath, this.pathPrefix, this.reportFormat.name(), (String)fileAndReport.getSecond());
                String filename = (String)fileAndReport.getFirst();
                if (StringUtils.isEmpty((String)filename)) {
                    filename = DEFAULT_REPORT_DOWNLOAD_NAME;
                }
                reportInfo.addUniformPath(filename);
                reportInfo.setRepositoryId(this.repositoryId);
                importInfos.addInfo(reportInfo);
            }
            return importInfos;
        }
    }
}

