/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.status;

import com.google.common.base.Preconditions;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ExternalAnalysisStatusIndexUtils {
    public static void deleteCommitStatusInfo(List<CommitDescriptor> commits, ExternalAnalysisStatusIndex statusIndex, ExternalAnalysisImportSessionIndex sessionIndex) throws StorageException {
        Set<String> sessionIds = sessionIndex.getSessionIdsForCommits(commits);
        sessionIndex.deleteSessions(sessionIds);
        statusIndex.runWithLock(lockedIndex -> {
            List<ExternalAnalysisStatusInfo> statusInfos = lockedIndex.getStatus(commits);
            lockedIndex.removeStatuses(statusInfos);
        });
    }

    public static void removeReanalyzableProcessingStepsFromUpload(ExternalAnalysisStatusInfo statusInfo) {
        Preconditions.checkArgument((boolean)statusInfo.isUpload());
        statusInfo.getProcessingSteps().removeIf(step -> !EnumSet.of(EExternalAnalysisProcessingStatus.UPLOADED, EExternalAnalysisProcessingStatus.STORED).contains((Object)step.getStatus()));
    }

    private ExternalAnalysisStatusIndexUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

