/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.findings.ClangTidyAndCppcheckRunnerBase;
import com.teamscale.index.findings.clangtidy.ProcessWrapper;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class IntegratedToolUtils {
    public static @NonNull CodeScopeAware<ListMap<String, IndexFinding>> splitFindingsByCodeScope(List<? extends BasicTokenElementInfo> filesToAnalyze, ListMap<String, IndexFinding> findings) {
        Map<String, CodeScopeName> codeScopeNameMap = filesToAnalyze.stream().collect(Collectors.toMap(BasicTokenElementInfo::getUniformPath, CodeScopeDetail::getCodeScopeNameFromTokenElement));
        CodeScopeAware findingsByCodeScope = CodeScopeAware.empty();
        for (String uniformPath : findings.getKeys()) {
            CodeScopeName codeScopeName = codeScopeNameMap.get(uniformPath);
            if (!findingsByCodeScope.contains(codeScopeName)) {
                findingsByCodeScope.setValue(codeScopeName, (Object)new ListMap());
            }
            List findingsForPath = (List)findings.getCollection((Object)uniformPath);
            ((ListMap)findingsByCodeScope.getValue(codeScopeName)).addAll((Object)uniformPath, (Collection)findingsForPath);
        }
        return findingsByCodeScope;
    }

    public static Pair<Integer, String> getNonAnalysisCommandLineOutput(String executableName, String ... options) {
        return IntegratedToolUtils.getNonAnalysisCommandLineOutput(executableName, false, options);
    }

    public static Pair<Integer, String> getNonAnalysisCommandLineOutput(String executableName, boolean preventJemallocUsage, String ... options) {
        ProcessWrapper process = new ProcessWrapper(executableName, preventJemallocUsage);
        for (String parameter : options) {
            process.addArgument(parameter);
        }
        StringBuffer combinedOut = new StringBuffer();
        process.setOutputConsumer(line -> combinedOut.append((String)line).append("\n"));
        process.setErrorConsumer(line -> combinedOut.append((String)line).append("\n"));
        int returnCode = process.runWithTimeout(1);
        return new Pair((Object)returnCode, (Object)combinedOut.toString());
    }

    public static void reportTimeout(String errorMessage, String fullErrorLog, String mainFile, List<File> toolSetupDirectories, String toolName, @Nullable File timeoutSetupBackupDir) {
        errorMessage = (String)errorMessage + " Timeout while analyzing translation unit " + mainFile + ". We may be missing findings.";
        if (timeoutSetupBackupDir == null) {
            ClangTidyAndCppcheckRunnerBase.LOGGER.error((String)errorMessage);
        } else {
            timeoutSetupBackupDir.mkdirs();
            try {
                Path tempDir = Files.createTempDirectory(timeoutSetupBackupDir.toPath(), "backup_" + toolName, new FileAttribute[0]);
                for (File sourceDirectory : toolSetupDirectories) {
                    FileUtils.copyDirectoryToDirectory((File)sourceDirectory, (File)tempDir.toFile());
                }
                FileSystemUtils.writeFile((Path)tempDir.resolve("errorLog.txt"), (String)fullErrorLog, (Charset)StandardCharsets.UTF_8);
                FileSystemUtils.writeFile((Path)tempDir.resolve("info.txt"), (String)("Backup of setup for " + toolName + " run on " + mainFile + "\nOriginal (temp) setup dir: " + String.valueOf(toolSetupDirectories.get(0))), (Charset)StandardCharsets.UTF_8);
                ClangTidyAndCppcheckRunnerBase.LOGGER.error((String)errorMessage + "\nBackup of the " + toolName + " setup copied to " + String.valueOf(tempDir));
            }
            catch (IOException e) {
                ClangTidyAndCppcheckRunnerBase.LOGGER.error((String)errorMessage + "\nFailed to create temporary directory for storing setup backup in " + timeoutSetupBackupDir.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private IntegratedToolUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

