/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;

public class PythonRunner {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PYTHON_EXEC = "python3";
    private final String executable;
    private final int outputLineLength;

    public PythonRunner(String executable, int outputLineLength) {
        this.executable = executable;
        this.outputLineLength = outputLineLength;
    }

    public PythonRunner(String executable) {
        this(executable, 0);
    }

    private @NonNull ProcessBuilder getProcessBuilder(@Nullable File workingDir, String[] parameters) {
        ProcessBuilder pb = new ProcessBuilder(PYTHON_EXEC, "-m", this.executable);
        Collections.addAll(pb.command(), parameters);
        if (this.outputLineLength > 0) {
            pb.environment().put("COLUMNS", String.valueOf(this.outputLineLength));
        }
        pb.directory(workingDir);
        return pb;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ProcessUtils.ExecutionResult exec(@Nullable File workingDir, int timeout, String ... parameters) throws IOException {
        ProcessBuilder processBuilder = this.getProcessBuilder(workingDir, parameters);
        LOGGER.debug(() -> "Executing: " + String.join((CharSequence)" ", processBuilder.command()));
        ProcessUtils.ExecutionResult result = ProcessUtils.executeOrThrow((ProcessBuilder)processBuilder, null, (int)timeout, IOException::new);
        LOGGER.debug(() -> "Execution result:\n--- STDOUT ---\n%s\n--- STDERR ---\n%s".formatted(result.getStdout(), result.getStderr()));
        return result;
    }

    public static @NonNull String executePythonVersionRaw() throws IOException {
        ProcessBuilder pb = new ProcessBuilder(PYTHON_EXEC, "--version");
        ProcessUtils.ExecutionResult result = ProcessUtils.executeOrThrow((ProcessBuilder)pb, null, (int)10, IOException::new);
        return result.getStdout().trim();
    }

    public String executeVersionInfoRaw() throws IOException {
        ProcessUtils.ExecutionResult result = this.exec(null, 10, "--version");
        return StringUtils.getFirstLine((String)result.getStdout().trim());
    }

    public static void verifyPythonExecutable() throws ConQATException {
        try {
            PythonRunner.executePythonVersionRaw();
        }
        catch (IOException e) {
            throw new ConQATException("Cannot execute 'python3'. Ensure that a compatible Python 3 is installed.", (Throwable)e);
        }
    }
}

