/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.bandit;

import com.teamscale.index.configuration.tools.BanditConfiguration;
import com.teamscale.index.findings.PythonRunner;
import com.teamscale.index.findings.bandit.BanditCSVReportParser;
import com.teamscale.index.findings.bandit.BanditConfigurationFileGenerator;
import com.teamscale.index.findings.bandit.FindingInfo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;

class BanditRunner {
    private static final String BANDIT_EXEC = "bandit";
    private static final String CONFIG_FILE_NAME = "bandit.yml";
    private static final PythonRunner PYTHON_RUNNER = new PythonRunner("bandit");

    BanditRunner() {
    }

    public static @NonNull Version executeVersionInfo() throws IOException, FormatException {
        String versionInfo = StringUtils.stripPrefix((String)PYTHON_RUNNER.executeVersionInfoRaw(), (String)"__main__.py");
        return Version.parseVersion((String)versionInfo);
    }

    public static @NonNull List<FindingInfo> executeAnalysis(@Nullable CanonicalFile workingDir) throws IOException, ConQATException {
        ProcessUtils.ExecutionResult executionResult = PYTHON_RUNNER.exec((File)workingDir, 0, "-c", CONFIG_FILE_NAME, "--format", "csv", "-r", "--exit-zero", "--ignore-nosec", ".");
        String analysisReport = executionResult.getStdout();
        if (StringUtils.isEmpty((String)analysisReport)) {
            return CollectionUtils.emptyList();
        }
        return BanditCSVReportParser.parse(analysisReport);
    }

    public static void prepareWorkingDirAndConfig(@NonNull CanonicalFile workingDir, @NonNull List<String> enabledChecks, @Nullable List<String> checkOptions, List<String> checkOptionValues, List<String> checkOptionTypes) throws IOException {
        FileSystemUtils.ensureDirectoryExists((File)workingDir);
        CanonicalFile configFile = new CanonicalFile((File)workingDir, CONFIG_FILE_NAME);
        List<String> checksWithoutPrefix = BanditRunner.stripPrefix(enabledChecks);
        BanditConfigurationFileGenerator generator = new BanditConfigurationFileGenerator(checksWithoutPrefix, checkOptions, checkOptionValues, checkOptionTypes);
        String configuration = generator.generateConfiguration();
        FileSystemUtils.writeFileUTF8((File)configFile, (String)configuration);
    }

    private static List<String> stripPrefix(List<String> checksWithPrefix) {
        return checksWithPrefix.stream().map(s -> StringUtils.getFirstPart((String)StringUtils.stripPrefix((String)s, (String)"bandit."), (String)".")).toList();
    }

    public static void verifyVersion() throws ConQATException {
        try {
            Version expectedVersion = BanditRunner.loadExpectedVersion();
            Version installedVersion = BanditRunner.executeVersionInfo();
            if (!expectedVersion.equals((Object)installedVersion)) {
                throw new ConQATException("Incompatible Bandit version detected. Required version: " + String.valueOf(expectedVersion) + " Detected version: " + String.valueOf(installedVersion));
            }
        }
        catch (FormatException e) {
            throw new ConQATException("Could not parse Bandit version. Ensure that a compatible Bandit version is installed.", (Throwable)e);
        }
        catch (IOException e) {
            PythonRunner.verifyPythonExecutable();
            throw new ConQATException("Error during Bandit execution. Ensure that compatible Python3 and Bandit versions are installed.", (Throwable)e);
        }
    }

    private static @NonNull Version loadExpectedVersion() throws FormatException {
        String expectedVersionRaw = Resource.of(BanditConfiguration.class, (String)"bandit/version.txt").getContent();
        expectedVersionRaw = StringUtils.stripPrefix((String)expectedVersionRaw, (String)BANDIT_EXEC);
        return Version.parseVersion((String)expectedVersionRaw);
    }
}

