/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolver;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.findings.calculation.AffectedFileDeltaCalculator;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.issues.PathIssueIndex;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.FirstLastCommit;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.RepositoryLogFileHistoryEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogFileUtils;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class AffectedFilesUtils {
    private static final List<EElementHistoryChangeType> CHANGE_TYPE_ORDER = List.of(EElementHistoryChangeType.DELETE, EElementHistoryChangeType.ADD, EElementHistoryChangeType.COPY, EElementHistoryChangeType.MOVE, EElementHistoryChangeType.EDIT, EElementHistoryChangeType.EXTERNAL_ANALYSIS_UPLOAD);

    public static List<TokenElementChurnWithOriginInfo> getAffectedFiles(ProjectStorageSystem projectStorageSystem, List<CommitDescriptor> commitDescriptors, @Nullable ECommitType commitType) throws StorageException {
        RepositoryLogFileIndex repositoryLogFileIndex = (RepositoryLogFileIndex)projectStorageSystem.openProjectIndex(RepositoryLogFileIndex.class, null);
        ArrayList<TokenElementChurnWithOriginInfo> result = new ArrayList<TokenElementChurnWithOriginInfo>();
        ListMap entriesByCommit = new ListMap();
        repositoryLogFileIndex.getEntriesByCommits(commitDescriptors).stream().filter(entry -> commitType == null || entry.getCommitType() == commitType).forEach(entry -> entriesByCommit.add((Object)entry.getCommit(), (Object)entry));
        for (CommitDescriptor commit : entriesByCommit.getKeys()) {
            List entries = (List)entriesByCommit.getCollection((Object)commit);
            ElementHistoryIndex historyIndex = (ElementHistoryIndex)projectStorageSystem.openProjectIndex(ElementHistoryIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
            result.addAll(AffectedFilesUtils.convertAll(RepositoryLogFileUtils.augmentWithHistoryInformation(entries, historyIndex)));
        }
        return AffectedFilesUtils.aggregateChurnEntries(result);
    }

    public static List<TokenElementChurnWithOriginInfo> getAffectedCodeFiles(ProjectStorageSystem projectStorageSystem, List<CommitDescriptor> commitDescriptors) throws StorageException {
        return AffectedFilesUtils.getAffectedFiles(projectStorageSystem, commitDescriptors, ECommitType.CODE_COMMIT);
    }

    public static List<TokenElementChurnWithOriginInfo> getAffectedFilesForIssue(TeamscaleIssueId issueId, ProjectStorageSystem projectStorageSystem) throws StorageException {
        List<CommitDescriptor> commitsForIssue;
        RepositoryCommitIssueMappingIndex commitMappingIndex = (RepositoryCommitIssueMappingIndex)projectStorageSystem.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        Optional<FirstLastCommit> firstAndLastCommitForIssue = commitMappingIndex.getFirstAndLastCommitForIssue(issueId);
        if (firstAndLastCommitForIssue.isEmpty()) {
            return Collections.emptyList();
        }
        CommitDescriptor startCommit = firstAndLastCommitForIssue.get().firstCommit;
        CommitDescriptor endCommit = firstAndLastCommitForIssue.get().lastCommit;
        CommitDescriptorIndex commitIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        List commitsInTimeRange = commitIndex.getCommitHistoryWithFirstParentCommits(endCommit, startCommit.getTimestamp() - 1L);
        if (AffectedFilesUtils.commitsAreConnected(commitsInTimeRange, commitsForIssue = commitMappingIndex.getCommitsForIssue(issueId))) {
            return AffectedFilesUtils.deriveAffectedFilesFromDelta(projectStorageSystem, commitIndex, startCommit, endCommit, commitsInTimeRange, issueId);
        }
        return AffectedFilesUtils.deriveAffectedFilesFromCommits(projectStorageSystem, commitsForIssue);
    }

    private static List<TokenElementChurnWithOriginInfo> deriveAffectedFilesFromDelta(ProjectStorageSystem projectStorageSystem, CommitDescriptorIndex commitIndex, CommitDescriptor startCommit, CommitDescriptor endCommit, List<ParentedCommitDescriptor> commitsInTimeRange, TeamscaleIssueId issueId) throws StorageException {
        PathIssueIndex pathIssueIndexAtEnd = (PathIssueIndex)projectStorageSystem.openProjectIndex(PathIssueIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)endCommit));
        List<UniformPath> referencedPaths = pathIssueIndexAtEnd.getReferencedPaths(issueId);
        CommitDescriptor parentOfStartCommit = UnresolvedCommitDescriptorUtils.resolveParent((CommitDescriptor)startCommit, (CommitDescriptorIndex)commitIndex);
        Map<UniformPath, String> startPathToContentHash = AffectedFilesUtils.getUniformPathToHashMapping(projectStorageSystem, referencedPaths, parentOfStartCommit);
        Map<UniformPath, String> endPathToContentHash = AffectedFilesUtils.getUniformPathToHashMapping(projectStorageSystem, referencedPaths, endCommit);
        return AffectedFileDeltaCalculator.calculateTokenElementChurnWithOriginInfo(projectStorageSystem, startPathToContentHash, endPathToContentHash, startCommit, endCommit, commitsInTimeRange, EChangeEntryOrigin.REPOSITORY_COMMIT);
    }

    private static List<TokenElementChurnWithOriginInfo> deriveAffectedFilesFromCommits(ProjectStorageSystem projectStorageSystem, List<CommitDescriptor> commitsForIssue) throws StorageException {
        commitsForIssue = CollectionUtils.filterWithException(commitsForIssue, commit -> !AffectedFilesUtils.isMergeCommit(commit, projectStorageSystem));
        return AffectedFilesUtils.getAffectedCodeFiles(projectStorageSystem, commitsForIssue);
    }

    private static boolean commitsAreConnected(List<ParentedCommitDescriptor> commitsBetweenStartAndEnd, List<CommitDescriptor> commitsForIssue) {
        HashSet<CommitDescriptor> commitDescriptorsBetweenStartAndEnd = new HashSet<CommitDescriptor>();
        for (ParentedCommitDescriptor commitBetweenStartAndEnd : commitsBetweenStartAndEnd) {
            commitDescriptorsBetweenStartAndEnd.add(new CommitDescriptor((CommitDescriptor)commitBetweenStartAndEnd));
        }
        for (CommitDescriptor commitFromIssue : commitsForIssue) {
            if (commitDescriptorsBetweenStartAndEnd.contains(commitFromIssue)) continue;
            return false;
        }
        return true;
    }

    private static Map<UniformPath, String> getUniformPathToHashMapping(ProjectStorageSystem projectStorageSystem, @Nullable List<UniformPath> uniformFilePaths, CommitDescriptor commit) throws StorageException {
        if (uniformFilePaths == null || uniformFilePaths.isEmpty()) {
            return Collections.emptyMap();
        }
        ContainerIndex containerIndex = (ContainerIndex)projectStorageSystem.openProjectIndex(ContainerIndex.class, "dir", HistoryAccessOption.readCommit((CommitDescriptor)commit));
        HashMap<UniformPath, String> uniformPathToHashMapping = new HashMap<UniformPath, String>();
        for (UniformPath uniformPath : uniformFilePaths) {
            String hash = AffectedFileDeltaCalculator.getHashFromParentContainer(uniformPath, containerIndex, commit);
            if (hash == null) continue;
            uniformPathToHashMapping.put(uniformPath, hash);
        }
        return uniformPathToHashMapping;
    }

    private static List<TokenElementChurnWithOriginInfo> convertAll(List<RepositoryLogFileHistoryEntry> entries) {
        return CollectionUtils.map(entries, entry -> {
            CommitDescriptor commitToOpenAt = entry.getCommit();
            if (entry.getChangeType() == EElementHistoryChangeType.DELETE) {
                commitToOpenAt = commitToOpenAt.cloneWithDecrementedTimestamp();
            }
            return new TokenElementChurnWithOriginInfo(commitToOpenAt, entry.getCommit(), (RepositoryLogFileHistoryEntry)((Object)entry));
        });
    }

    public static List<TokenElementChurnWithOriginInfo> aggregateChurnEntries(Collection<TokenElementChurnWithOriginInfo> logFileEntries) {
        HashMap<String, TokenElementChurnWithOriginInfo> aggregatedEntriesByPath = new HashMap<String, TokenElementChurnWithOriginInfo>();
        for (TokenElementChurnWithOriginInfo entry : CollectionUtils.sort(logFileEntries, TokenElementChurnWithOriginInfo.TIMESTAMP_COMPARATOR)) {
            TokenElementChurnWithOriginInfo predecessorInfo;
            String predecessorPath = entry.getUniformPath();
            if (EElementHistoryChangeType.ORIGIN_CHANGE.contains((Object)entry.getChangeType())) {
                predecessorPath = entry.getOriginPath();
            }
            if ((predecessorInfo = (TokenElementChurnWithOriginInfo)aggregatedEntriesByPath.get(predecessorPath)) == null) {
                aggregatedEntriesByPath.put(entry.getUniformPath(), entry);
                continue;
            }
            if (entry.getChangeType() == EElementHistoryChangeType.DELETE && EnumSet.of(EElementHistoryChangeType.ADD, EElementHistoryChangeType.COPY, EElementHistoryChangeType.MOVE).contains((Object)predecessorInfo.getChangeType())) {
                aggregatedEntriesByPath.remove(entry.getUniformPath());
                continue;
            }
            TokenElementChurnWithOriginInfo aggregatedInfo = AffectedFilesUtils.aggregateLogFileEntryChangeType(entry, predecessorInfo);
            if (entry.getChangeType() == EElementHistoryChangeType.MOVE) {
                aggregatedEntriesByPath.remove(entry.getOriginPath());
            }
            aggregatedEntriesByPath.put(entry.getUniformPath(), aggregatedInfo);
        }
        return CollectionUtils.sort(aggregatedEntriesByPath.values(), TokenElementChurnWithOriginInfo.PATH_COMPARATOR);
    }

    private static TokenElementChurnWithOriginInfo aggregateLogFileEntryChangeType(TokenElementChurnWithOriginInfo currentEntry, TokenElementChurnWithOriginInfo predecessorEntry) {
        boolean shouldOverwriteTypeCode;
        EElementHistoryChangeType currentAggregatedChangeType = currentEntry.getChangeType();
        EElementHistoryChangeType predecessorChangeType = predecessorEntry.getChangeType();
        boolean bl = shouldOverwriteTypeCode = CHANGE_TYPE_ORDER.indexOf((Object)currentAggregatedChangeType) >= CHANGE_TYPE_ORDER.indexOf((Object)predecessorChangeType);
        if (shouldOverwriteTypeCode) {
            if (predecessorChangeType == EElementHistoryChangeType.MOVE && currentEntry.getUniformPath().equals(predecessorEntry.getOriginPath())) {
                return new TokenElementChurnWithOriginInfo(currentEntry.getCommit(), currentEntry.getLatestCommitWithFilePresent(), predecessorEntry.getIntroductionCommit(), currentEntry.getUniformPath(), EElementHistoryChangeType.EDIT, currentEntry.getChangeEntryOrigin(), null, null);
            }
            return new TokenElementChurnWithOriginInfo(currentEntry.getCommit(), currentEntry.getLatestCommitWithFilePresent(), predecessorEntry.getIntroductionCommit(), currentEntry.getUniformPath(), predecessorChangeType, currentEntry.getChangeEntryOrigin(), predecessorEntry.getOriginPath(), predecessorEntry.getOriginCommit());
        }
        return currentEntry;
    }

    private static boolean isMergeCommit(CommitDescriptor commit, ProjectStorageSystem storageSystem) throws StorageException {
        Optional parentedCommitDescriptorOptional = new CommitResolver().getFirstActualCommitBeforeOrAt(commit, storageSystem);
        return parentedCommitDescriptorOptional.isPresent() && ((ParentedCommitDescriptor)parentedCommitDescriptorOptional.get()).isMergeCommit();
    }

    private AffectedFilesUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

