/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.findings.calculation.CodeFindingsRetriever;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.NonCodeBinarySizeElementFindingsRetriever;
import com.teamscale.index.findings.calculation.SpecItemFindingsRetriever;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public interface IFindingsRetriever {
    public static IFindingsRetriever getFindingsRetriever(boolean isOnlySpecItemFindings, boolean isOnlyNonCodePath, String branch, FindingsCalculationInfo calculationInfo) throws StorageException {
        ProjectStorageSystem projectStorageSystem = calculationInfo.projectStorageSystem();
        if (isOnlySpecItemFindings) {
            return SpecItemFindingsRetriever.create(branch, calculationInfo.projectId(), calculationInfo.indexLayer(), projectStorageSystem);
        }
        if (EFeatureToggle.ENABLE_BINARY_SIZE_ELEMENT_FINDINGS_FILTERING.isEnabled() && isOnlyNonCodePath) {
            return NonCodeBinarySizeElementFindingsRetriever.create(projectStorageSystem);
        }
        return new CodeFindingsRetriever(projectStorageSystem);
    }

    @Deprecated
    default public List<TrackedFinding> getFindings(@NonNull String uniformPath, @NonNull CommitDescriptor commit) throws StorageException {
        return this.getFindings(UniformPathCompatibilityUtil.convert((String)uniformPath), commit);
    }

    public List<TrackedFinding> getFindings(@NonNull UniformPath var1, @NonNull CommitDescriptor var2) throws StorageException;

    public List<@Nullable TrackedFinding> getFindings(List<String> var1, @NonNull CommitDescriptor var2) throws StorageException;

    @Deprecated
    default public Map<String, TrackedFinding> getFindingsById(@NonNull String uniformPath, @NonNull CommitDescriptor commit) throws StorageException {
        List<TrackedFinding> findings = this.getFindings(uniformPath, commit);
        return findings.stream().collect(Collectors.toMap(TrackedFinding::getId, Function.identity()));
    }

    default public Map<String, TrackedFinding> getFindingsById(@NonNull UniformPath uniformPath, @NonNull CommitDescriptor commit) throws StorageException {
        List<TrackedFinding> findings = this.getFindings(uniformPath, commit);
        return findings.stream().collect(Collectors.toMap(TrackedFinding::getId, Function.identity()));
    }

    @Deprecated
    default public Set<String> getFindingIds(@NonNull String uniformPath, @NonNull CommitDescriptor commit) throws StorageException {
        List<TrackedFinding> findings = this.getFindings(uniformPath, commit);
        return CollectionUtils.mapToSet(findings, TrackedFinding::getId);
    }

    default public Set<String> getFindingIds(@NonNull UniformPath uniformPath, @NonNull CommitDescriptor commit) throws StorageException {
        List<TrackedFinding> findings = this.getFindings(uniformPath, commit);
        return CollectionUtils.mapToSet(findings, TrackedFinding::getId);
    }

    public <T extends TrackedFinding> List<T> getFindingsInChangedCode(long var1, @NonNull CommitDescriptor var3, List<T> var4) throws StorageException;

    public Map<String, FindingBlacklistInfo> getFlaggedFindings(Collection<TrackedFinding> var1, @NonNull CommitDescriptor var2) throws StorageException;
}

