/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.cross_file_analysis;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.CodeScopeAwareObjectBuilder;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.findings.cross_file_analysis.BidirectionalByteArrayListIndex;
import com.teamscale.index.findings.cross_file_analysis.InPlaceByteArrayWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.BidirectionalListIndexBase;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="cross-file-analysis-findings", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={byte[].class})
public class CrossFileAnalysisFindingsIndex
extends IndexBase
implements IProjectIndex {
    private static final String LOCK_FOR_CONSISTENCY = "lockForConsistency";
    public static final String INDEX_NAME = "cross-file-analysis-findings";
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimpleCrudIndex<FindingHash, SerializedFinding> findingsHashIndex;
    private static final String FINDING_HASH_INDEX_ID = "f";
    private final SimpleCrudIndex<AnalysisPathIndexKey, ArrayList<AbbreviatedLocationPath>> analysisPathIndex;
    private static final String ANALYSIS_PATH_INDEX_ID = "ap";
    private final BidirectionalByteArrayListIndex pathsToFindingsIndex;
    private static final String PATH_TO_FINDINGS_INDEX_ID = "pf";

    public CrossFileAnalysisFindingsIndex(IStore store) {
        super(store, false);
        this.findingsHashIndex = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, FINDING_HASH_INDEX_ID), FindingHash.SERIALIZER, SerializedFinding.SERIALIZER);
        this.analysisPathIndex = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, ANALYSIS_PATH_INDEX_ID), AnalysisPathIndexKey.SERIALIZER, AbbreviatedLocationPath.LIST_SERIALIZER);
        this.pathsToFindingsIndex = new BidirectionalByteArrayListIndex((IStore)new DelegatingPartitionStore(store, PATH_TO_FINDINGS_INDEX_ID));
    }

    void storeFindings(Map<String, List<IndexFinding>> findingsByAnalysisPath, Set<String> analyzedPaths, List<String> deletedUniformPaths, String findingsIndexPartition) throws StorageException {
        Map<IndexFinding, FindingHashAndSerializedFinding> serializedFindings = this.serializeFindings(findingsByAnalysisPath.values().stream().flatMap(Collection::stream).toList());
        RunnableWithException storeFindingsRunnable = () -> this.storeFindingsInternal(findingsByAnalysisPath, analyzedPaths, deletedUniformPaths, findingsIndexPartition, serializedFindings);
        this.store.performWithLock(storeFindingsRunnable, LOCK_FOR_CONSISTENCY);
    }

    private void storeFindingsInternal(Map<String, List<IndexFinding>> findingsByAnalysisPath, Set<String> analyzedPaths, List<String> deletedUniformPaths, String findingsIndexPartition, Map<IndexFinding, FindingHashAndSerializedFinding> serializedFindings) throws StorageException {
        HashSet analyzedPathsWithoutFindings = CollectionUtils.differenceSet(analyzedPaths, (Collection[])new Collection[]{findingsByAnalysisPath.keySet()});
        IndexUpdateInformation updatedEntries = this.computeUpdatedEntriesInAnalysisPathAndPathToFindingsIndexes(findingsByAnalysisPath, findingsIndexPartition, analyzedPathsWithoutFindings, serializedFindings);
        ArrayList<String> analysisPathsWithoutFindings = new ArrayList<String>(deletedUniformPaths);
        analysisPathsWithoutFindings.addAll(analyzedPathsWithoutFindings);
        Map<String, List<AbbreviatedLocationPath>> previousAnalysisPathIndexEntries = this.loadEntriesFromAnalysisPathIndex(new ArrayList<String>(analyzedPaths), findingsIndexPartition);
        previousAnalysisPathIndexEntries.putAll(this.loadEntriesFromAnalysisPathIndex(deletedUniformPaths, findingsIndexPartition));
        List<InPlaceByteArrayWrapper> pathToFindingsIndexKeysToDelete = this.computePathToFindingsIndexKeysToDelete(findingsIndexPartition, analysisPathsWithoutFindings, previousAnalysisPathIndexEntries, updatedEntries.updatedAnalysisPathIndexEntries);
        List orphanedFindingHashes = CollectionUtils.map((Collection)this.pathsToFindingsIndex.updateValues(updatedEntries.updatedPathToFindingsIndexEntries(), pathToFindingsIndexKeysToDelete), FindingHash::new);
        orphanedFindingHashes.addAll(CollectionUtils.map(this.pathsToFindingsIndex.deleteForwardKeysWithPrefixes(this.abbreviateStrings(deletedUniformPaths)), FindingHash::new));
        this.findingsHashIndex.remove((Collection)orphanedFindingHashes);
        List<AnalysisPathIndexKey> analysisPathIndexKeysToRemove = this.computeAnalysisPathIndexKeysToRemove(findingsIndexPartition, analysisPathsWithoutFindings, deletedUniformPaths);
        this.analysisPathIndex.remove(analysisPathIndexKeysToRemove);
        this.analysisPathIndex.put(PairList.fromMap(updatedEntries.updatedAnalysisPathIndexEntries()));
        this.findingsHashIndex.put(CrossFileAnalysisFindingsIndex.transformToPairList(serializedFindings.values()));
    }

    private static PairList<FindingHash, SerializedFinding> transformToPairList(Collection<FindingHashAndSerializedFinding> findingHashAndSerializedFindings) {
        PairList newFindingsByHash = new PairList();
        for (FindingHashAndSerializedFinding findingHashAndSerializedFinding : findingHashAndSerializedFindings) {
            newFindingsByHash.add((Object)findingHashAndSerializedFinding.findingHash(), (Object)findingHashAndSerializedFinding.serializedFinding());
        }
        return newFindingsByHash;
    }

    private List<AnalysisPathIndexKey> computeAnalysisPathIndexKeysToRemove(String findingsIndexPartition, ArrayList<String> analysisPathsWithoutFindings, List<String> deletedUniformPaths) throws StorageException {
        ArrayList<AnalysisPathIndexKey> analysisPathIndexKeysToDelete = new ArrayList<AnalysisPathIndexKey>();
        for (String analysisPath : analysisPathsWithoutFindings) {
            analysisPathIndexKeysToDelete.add(this.makeAnalysisPathIndexKey(analysisPath, findingsIndexPartition));
        }
        for (String analysisPath : deletedUniformPaths) {
            analysisPathIndexKeysToDelete.add(this.makeAnalysisPathIndexKey(analysisPath, findingsIndexPartition));
        }
        return analysisPathIndexKeysToDelete;
    }

    private List<InPlaceByteArrayWrapper> computePathToFindingsIndexKeysToDelete(String findingsIndexPartition, ArrayList<String> analysisPathsWithoutFindings, Map<String, List<AbbreviatedLocationPath>> previousAnalysisPathIndexEntries, Map<AnalysisPathIndexKey, ArrayList<AbbreviatedLocationPath>> updatedAnalysisPathIndexEntries) throws StorageException {
        ArrayList<InPlaceByteArrayWrapper> pathToFindingsIndexKeysToDelete = new ArrayList<InPlaceByteArrayWrapper>();
        for (String string : analysisPathsWithoutFindings) {
            List<AbbreviatedLocationPath> associatedLocationPaths = previousAnalysisPathIndexEntries.get(string);
            if (associatedLocationPaths == null) continue;
            for (AbbreviatedLocationPath associatedLocationPath : associatedLocationPaths) {
                pathToFindingsIndexKeysToDelete.add(this.makePathToFindingIndexKey(associatedLocationPath.getBytes(), string, findingsIndexPartition));
            }
        }
        for (Map.Entry entry : previousAnalysisPathIndexEntries.entrySet()) {
            String analysisPath = (String)entry.getKey();
            List previousLocationPaths = (List)entry.getValue();
            if (previousLocationPaths.isEmpty()) continue;
            List updatedLocationPaths = updatedAnalysisPathIndexEntries.get(this.makeAnalysisPathIndexKey((String)entry.getKey(), findingsIndexPartition));
            HashSet locationPathsWithResolvedFindings = updatedLocationPaths == null ? new HashSet(previousLocationPaths) : CollectionUtils.differenceSet((Collection)previousLocationPaths, (Collection[])new Collection[]{updatedLocationPaths});
            for (AbbreviatedLocationPath associatedLocationPath : locationPathsWithResolvedFindings) {
                pathToFindingsIndexKeysToDelete.add(this.makePathToFindingIndexKey(associatedLocationPath.getBytes(), analysisPath, findingsIndexPartition));
            }
        }
        return pathToFindingsIndexKeysToDelete;
    }

    private IndexUpdateInformation computeUpdatedEntriesInAnalysisPathAndPathToFindingsIndexes(Map<String, List<IndexFinding>> findingsByAnalysisPath, String findingsIndexPartition, Set<String> analyzedPathsWithoutFindings, Map<IndexFinding, FindingHashAndSerializedFinding> serializedFindings) throws StorageException {
        HashMap<AnalysisPathIndexKey, ArrayList<AbbreviatedLocationPath>> updatedAnalysisPathIndexEntries = new HashMap<AnalysisPathIndexKey, ArrayList<AbbreviatedLocationPath>>();
        HashMap<InPlaceByteArrayWrapper, ArrayList<InPlaceByteArrayWrapper>> updatedPathToFindingsIndexEntries = new HashMap<InPlaceByteArrayWrapper, ArrayList<InPlaceByteArrayWrapper>>();
        for (Map.Entry<String, List<IndexFinding>> findingInAnalysisPath : findingsByAnalysisPath.entrySet()) {
            String analysisPath = findingInAnalysisPath.getKey();
            List<IndexFinding> findingsInAnalysisPath = findingInAnalysisPath.getValue();
            if (findingsInAnalysisPath.isEmpty()) {
                analyzedPathsWithoutFindings.add(analysisPath);
            }
            for (IndexFinding finding : findingsInAnalysisPath) {
                String locationPath = finding.getLocation().getUniformPath();
                InPlaceByteArrayWrapper pathsToFindingsIndexKey = this.makePathToFindingIndexKey(locationPath, analysisPath, findingsIndexPartition);
                updatedPathToFindingsIndexEntries.computeIfAbsent(pathsToFindingsIndexKey, k -> new ArrayList()).add(serializedFindings.get((Object)finding).findingHash);
                AnalysisPathIndexKey analysisPathKey = this.makeAnalysisPathIndexKey(analysisPath, findingsIndexPartition);
                updatedAnalysisPathIndexEntries.computeIfAbsent(analysisPathKey, k -> new ArrayList()).add(new AbbreviatedLocationPath(this.abbreviateString(locationPath)));
            }
        }
        return new IndexUpdateInformation(updatedAnalysisPathIndexEntries, updatedPathToFindingsIndexEntries);
    }

    List<KeyComponents> filterAndDecodePathToFindingForwardIndexKeys(List<byte[]> crossFileIndexKeyDelta) throws StorageException {
        byte[] prefix = ByteArrayUtils.concat((byte[][])new byte[][]{DelegatingPartitionStore.buildStoragePathPrefix((String)PATH_TO_FINDINGS_INDEX_ID), BidirectionalListIndexBase.FORWARD_INDEX_KEY_PREFIX});
        List<InPlaceByteArrayWrapper> filteredKeys = crossFileIndexKeyDelta.stream().filter(key -> ByteArrayUtils.isPrefix((byte[])prefix, (byte[])key)).map(InPlaceByteArrayWrapper::new).collect(Collectors.toList());
        return this.decodePathToFindingForwardIndexKeys(filteredKeys, prefix.length);
    }

    private List<KeyComponents> decodePathToFindingForwardIndexKeys(List<InPlaceByteArrayWrapper> keys, int keyPrefixLength) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ArrayList<KeyComponents> result = new ArrayList<KeyComponents>();
        for (InPlaceByteArrayWrapper key : keys) {
            byte[] bytes = key.getBytes();
            String locationPath = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)keyPrefixLength));
            String findingIndexPartition = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)(keyPrefixLength + 4)));
            String analyzedPath = abbreviator.unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)(keyPrefixLength + 8)));
            result.add(new KeyComponents(locationPath, analyzedPath, findingIndexPartition));
        }
        return result;
    }

    private byte[] abbreviateString(String string) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(string));
    }

    private List<byte[]> abbreviateStrings(List<String> strings) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ArrayList<byte[]> abbreviatedPaths = new ArrayList<byte[]>();
        for (String analysisPath : strings) {
            abbreviatedPaths.add(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(analysisPath)));
        }
        return abbreviatedPaths;
    }

    private Map<IndexFinding, FindingHashAndSerializedFinding> serializeFindings(List<IndexFinding> findings) throws StorageException {
        HashMap<FindingHash, FindingHashAndSerializedFinding> serializedFindingsByHashCode = new HashMap<FindingHash, FindingHashAndSerializedFinding>();
        HashMap<IndexFinding, FindingHashAndSerializedFinding> serializedFindings = new HashMap<IndexFinding, FindingHashAndSerializedFinding>();
        Map abbreviatedLocationPaths = this.store.getAbbreviator().buildAbbreviationMap(findings.stream().map(finding -> finding.getLocation().getUniformPath()).collect(Collectors.toSet()));
        Map abbreviatedAnalysisTypes = this.store.getAbbreviator().buildAbbreviationMap(findings.stream().map(IndexFinding::getTypeId).collect(Collectors.toSet()));
        for (IndexFinding finding2 : findings) {
            try {
                SerializedFinding findingBytes = new SerializedFinding(SerializationUtils.serializeToByteArray((Serializable)finding2));
                FindingHash findingHashBytes = CrossFileAnalysisFindingsIndex.computeHashForFinding(finding2, abbreviatedLocationPaths, abbreviatedAnalysisTypes, findingBytes);
                FindingHashAndSerializedFinding findingHashAndSerializedFinding = (FindingHashAndSerializedFinding)serializedFindingsByHashCode.get(findingHashBytes);
                if (findingHashAndSerializedFinding == null) {
                    findingHashAndSerializedFinding = new FindingHashAndSerializedFinding(findingHashBytes, findingBytes);
                    serializedFindingsByHashCode.put(findingHashBytes, findingHashAndSerializedFinding);
                }
                serializedFindings.put(finding2, findingHashAndSerializedFinding);
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
        return serializedFindings;
    }

    private static @NonNull FindingHash computeHashForFinding(IndexFinding finding, Map<String, Integer> abbreviatedLocationPaths, Map<String, Integer> abbreviatedAnalysisTypes, SerializedFinding findingBytes) {
        byte[] abbreviatedLocationPath = ByteArrayUtils.intToByteArray((int)abbreviatedLocationPaths.get(finding.getLocation().getUniformPath()));
        byte[] abbreviatedAnalysisType = ByteArrayUtils.intToByteArray((int)abbreviatedAnalysisTypes.get(finding.getTypeId()));
        byte[] offset = new byte[]{0};
        if (finding.getLocation() instanceof TextRegionLocation) {
            offset = ByteArrayUtils.intToByteArray((int)((TextRegionLocation)finding.getLocation()).getRawStartOffset());
        } else if (finding.getLocation() instanceof QualifiedNameLocation) {
            LOGGER.error("CrossFileAnalysis is not yet supported for Findings with QualifiedNameLocations. Got a finding for " + finding.getLocation().toLocationString());
        }
        byte[] messageHash = ByteArrayUtils.intToByteArray((int)XXHashUtils.hash32((byte[])finding.getMessage().getBytes()));
        byte[] contentHash = ByteArrayUtils.intToByteArray((int)XXHashUtils.hash32((byte[])findingBytes.getBytes()));
        return new FindingHash(ByteArrayUtils.concat((byte[][])new byte[][]{abbreviatedLocationPath, abbreviatedAnalysisType, offset, messageHash, contentHash}));
    }

    private AnalysisPathIndexKey makeAnalysisPathIndexKey(String analysisPath, String findingsIndexPartition) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return new AnalysisPathIndexKey(ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(findingsIndexPartition)), ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(analysisPath))}));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Map<String, List<AbbreviatedLocationPath>> loadEntriesFromAnalysisPathIndex(List<String> allAnalyzedPaths, String findingsIndexPartition) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ArrayList<AnalysisPathIndexKey> keysToLoad = new ArrayList<AnalysisPathIndexKey>();
        byte[] abbreviatedPartition = ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(findingsIndexPartition));
        for (String path : allAnalyzedPaths) {
            keysToLoad.add(new AnalysisPathIndexKey(ByteArrayUtils.concat((byte[][])new byte[][]{abbreviatedPartition, ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(path))})));
        }
        @Nullable List indexValues = this.analysisPathIndex.get(keysToLoad);
        HashMap<String, List<AbbreviatedLocationPath>> result = new HashMap<String, List<AbbreviatedLocationPath>>();
        for (int i = 0; i < allAnalyzedPaths.size(); ++i) {
            String analysisPath = allAnalyzedPaths.get(i);
            @Nullable ArrayList associatedLocationPaths = (ArrayList)indexValues.get(i);
            if (associatedLocationPaths == null) {
                result.put(analysisPath, Collections.emptyList());
                continue;
            }
            result.put(analysisPath, associatedLocationPaths);
        }
        return result;
    }

    private InPlaceByteArrayWrapper makePathToFindingIndexKey(String findingLocationPath, String analyzedPath, String findingIndexPartition) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return new InPlaceByteArrayWrapper(ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(findingLocationPath)), ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(findingIndexPartition)), ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(analyzedPath))}));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Map<FindingHash, IndexFinding> loadFindingsForHashes(List<FindingHash> findingHashes) throws StorageException {
        HashMap<FindingHash, IndexFinding> result = new HashMap<FindingHash, IndexFinding>();
        @Nullable List findings = this.findingsHashIndex.get(findingHashes);
        for (int i = 0; i < findingHashes.size(); ++i) {
            FindingHash findingsHash = findingHashes.get(i);
            try {
                IndexFinding finding = (IndexFinding)SerializationUtils.deserializeFromByteArray((byte[])((SerializedFinding)findings.get(i)).getBytes());
                if (finding == null) continue;
                result.put(findingsHash, finding);
                continue;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new StorageException((Throwable)e);
            }
        }
        return result;
    }

    public Map<String, CodeScopeAware<SetMap<String, IndexFinding>>> loadFindingsForLocationPaths(SetMap<String, String> locationPathsPerFindingsIndexPartition) throws StorageException {
        PairList<KeyComponents, ArrayList<InPlaceByteArrayWrapper>> pathToFindingsIndexEntries = this.loadPathToFindingsIndexEntries(locationPathsPerFindingsIndexPartition);
        Set<FindingHash> requiredFindingHashes = CrossFileAnalysisFindingsIndex.extractFindingHashesFromEntries(pathToFindingsIndexEntries);
        Map<FindingHash, List<String>> analysisPathsPerFindingHash = this.loadAllAnalysisPathsGeneratingFindings(requiredFindingHashes);
        Map<FindingHash, IndexFinding> findingsMap = this.loadFindingsForHashes(new ArrayList<FindingHash>(requiredFindingHashes));
        HashMap<String, CodeScopeAwareObjectBuilder> codeScopeAwareBuildersByPartition = new HashMap<String, CodeScopeAwareObjectBuilder>();
        for (int i = 0; i < pathToFindingsIndexEntries.size(); ++i) {
            KeyComponents decodedKey = (KeyComponents)pathToFindingsIndexEntries.getFirst(i);
            String findingsIndexPartition = decodedKey.findingIndexPartition;
            CodeScopeAwareObjectBuilder findingsInPartition = codeScopeAwareBuildersByPartition.computeIfAbsent(findingsIndexPartition, k -> new CodeScopeAwareObjectBuilder((Object)new SetMap()));
            List<FindingHash> findingHashes = ((ArrayList)pathToFindingsIndexEntries.getSecond(i)).stream().map(bytes -> new FindingHash(bytes.getBytes())).toList();
            for (FindingHash findingHash : findingHashes) {
                IndexFinding finding = findingsMap.get(findingHash);
                List<String> analysisPaths = analysisPathsPerFindingHash.get(findingHash);
                CrossFileAnalysisFindingsIndex.injectAnalysisPathsFindingProperty(finding, analysisPaths);
                CCSMAssert.isNotNull((Object)finding.getCodeScopeName());
                CodeScopeName codeScopeName = finding.getCodeScopeName();
                if (!decodedKey.findingLocationPath.equals(finding.getLocation().getUniformPath())) {
                    LOGGER.error("Loaded a finding for location path {} but the finding object was in {}. {}, {}, {}. Skipping this finding.", (Object)decodedKey.findingLocationPath, (Object)finding.getLocation().getUniformPath(), (Object)finding.getTypeId(), (Object)finding.getMessage(), (Object)finding.getLocation().toLocationString());
                    continue;
                }
                ((SetMap)findingsInPartition.computeIfAbsent(codeScopeName, SetMap::new)).add((Object)decodedKey.findingLocationPath, (Object)finding);
            }
        }
        return CollectionUtils.transformMapValues(codeScopeAwareBuildersByPartition, CodeScopeAwareObjectBuilder::build);
    }

    private static Set<FindingHash> extractFindingHashesFromEntries(PairList<KeyComponents, ArrayList<InPlaceByteArrayWrapper>> pathToFindingsIndexEntries) {
        HashSet<FindingHash> requiredFindingHashes = new HashSet<FindingHash>();
        for (List findingHashes : pathToFindingsIndexEntries.extractSecondList()) {
            requiredFindingHashes.addAll(findingHashes.stream().map(value -> new FindingHash(value.getBytes())).toList());
        }
        return requiredFindingHashes;
    }

    private static void injectAnalysisPathsFindingProperty(IndexFinding finding, List<String> analysisPaths) {
        if (finding.getProperty("Analysis Paths") != null) {
            return;
        }
        if ((analysisPaths = CrossFileAnalysisFindingsIndex.getFirstPathsWithoutDuplicates(analysisPaths, 6)).size() > 5) {
            finding.setProperty("Analysis Paths", (Object)(analysisPaths.stream().limit(5L).collect(Collectors.joining("\n")) + "\n..."));
        } else {
            finding.setProperty("Analysis Paths", (Object)analysisPaths.stream().limit(5L).collect(Collectors.joining("\n")));
        }
    }

    private static List<String> getFirstPathsWithoutDuplicates(List<String> analysisPaths, int maxNumberOfPaths) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> seenPaths = new HashSet<String>();
        for (String path : analysisPaths) {
            if (result.size() >= maxNumberOfPaths) {
                return result;
            }
            if (!seenPaths.add(path)) continue;
            result.add(path);
        }
        return result;
    }

    private PairList<KeyComponents, ArrayList<InPlaceByteArrayWrapper>> loadPathToFindingsIndexEntries(SetMap<String, String> locationPathsPerFindingsIndexPartition) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ArrayList<byte[]> pathsToFindingsIndexKeyPrefixes = new ArrayList<byte[]>();
        for (Map.Entry entry : locationPathsPerFindingsIndexPartition.entrySet()) {
            String partitionName = (String)entry.getKey();
            ArrayList locationPaths = new ArrayList((Collection)entry.getValue());
            for (String locationPath : locationPaths) {
                pathsToFindingsIndexKeyPrefixes.add(this.makePathToFindingIndexKeyPrefix(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(locationPath)), partitionName));
            }
        }
        PairList<InPlaceByteArrayWrapper, ArrayList<InPlaceByteArrayWrapper>> findingsLists = this.pathsToFindingsIndex.getForwardEntriesWithPrefix(pathsToFindingsIndexKeyPrefixes);
        List<KeyComponents> decodedKeys = this.decodePathToFindingForwardIndexKeys((List<InPlaceByteArrayWrapper>)findingsLists.getFirstList(), BidirectionalListIndexBase.FORWARD_INDEX_KEY_PREFIX.length);
        PairList result = new PairList();
        for (int i = 0; i < decodedKeys.size(); ++i) {
            result.add((Object)decodedKeys.get(i), (Object)((ArrayList)findingsLists.getSecond(i)));
        }
        return result;
    }

    private Map<FindingHash, List<String>> loadAllAnalysisPathsGeneratingFindings(Set<FindingHash> findingHashes) throws StorageException {
        HashMap<FindingHash, List<String>> result = new HashMap<FindingHash, List<String>>();
        ArrayList<FindingHash> findingHashList = new ArrayList<FindingHash>(findingHashes);
        List keysForFindingHashes = this.pathsToFindingsIndex.getKeysForValues(findingHashList.stream().map(hash -> hash).toList());
        for (int i = 0; i < findingHashList.size(); ++i) {
            FindingHash findingHash = (FindingHash)findingHashList.get(i);
            List<KeyComponents> keys = this.decodePathToFindingForwardIndexKeys((List)keysForFindingHashes.get(i), 0);
            List analyzedPaths = CollectionUtils.map(keys, KeyComponents::analyzedPath);
            result.put(findingHash, analyzedPaths);
        }
        return result;
    }

    private InPlaceByteArrayWrapper makePathToFindingIndexKey(byte[] findingLocationPath, String analyzedPath, String findingIndexPartition) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return new InPlaceByteArrayWrapper(ByteArrayUtils.concat((byte[][])new byte[][]{findingLocationPath, ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(findingIndexPartition)), ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(analyzedPath))}));
    }

    private byte[] makePathToFindingIndexKeyPrefix(byte[] findingLocationPath, String findingIndexPartition) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return ByteArrayUtils.concat((byte[][])new byte[][]{findingLocationPath, ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(findingIndexPartition))});
    }

    @IndexValueClass
    static class FindingHash
    extends InPlaceByteArrayWrapper {
        public static final ISerializer<FindingHash, byte[]> SERIALIZER = new ISerializer<FindingHash, byte[]>(){

            public byte @NonNull [] serialize(FindingHash value) {
                return value.getBytes();
            }

            public @NonNull FindingHash deserialize(byte @NonNull [] value) {
                return new FindingHash(value);
            }
        };

        private FindingHash(byte[] bytes) {
            super(bytes);
        }

        private FindingHash(InPlaceByteArrayWrapper bytes) {
            super(bytes.getBytes());
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.getBytes());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FindingHash that = (FindingHash)o;
            return Arrays.equals(this.getBytes(), that.getBytes());
        }
    }

    @IndexValueClass
    private static class SerializedFinding
    extends InPlaceByteArrayWrapper {
        public static final ISerializer<SerializedFinding, byte[]> SERIALIZER = new ISerializer<SerializedFinding, byte[]>(){

            public byte @NonNull [] serialize(SerializedFinding value) {
                return value.getBytes();
            }

            public @NonNull SerializedFinding deserialize(byte @NonNull [] value) {
                return new SerializedFinding(value);
            }
        };

        private SerializedFinding(byte[] bytes) {
            super(bytes);
        }
    }

    @IndexValueClass
    private static class AnalysisPathIndexKey
    extends InPlaceByteArrayWrapper {
        public static final ISerializer<AnalysisPathIndexKey, byte[]> SERIALIZER = new ISerializer<AnalysisPathIndexKey, byte[]>(){

            public byte @NonNull [] serialize(AnalysisPathIndexKey value) {
                return value.getBytes();
            }

            public @NonNull AnalysisPathIndexKey deserialize(byte @NonNull [] value) {
                return new AnalysisPathIndexKey(value);
            }
        };

        private AnalysisPathIndexKey(byte[] bytes) {
            super(bytes);
        }
    }

    @IndexValueClass
    private static class AbbreviatedLocationPath
    extends InPlaceByteArrayWrapper {
        public static final ISerializer<ArrayList<AbbreviatedLocationPath>, byte[]> LIST_SERIALIZER = new ISerializer<ArrayList<AbbreviatedLocationPath>, byte[]>(){

            public byte @NonNull [] serialize(@NonNull ArrayList<AbbreviatedLocationPath> value) throws StorageException {
                ArrayList<AbbreviatedLocationPath> values = new ArrayList<AbbreviatedLocationPath>(value);
                return (byte[])InPlaceByteArrayWrapper.LIST_OF_BYTE_ARRAY_SERIALIZER.serialize(values);
            }

            public @NonNull ArrayList<AbbreviatedLocationPath> deserialize(byte @NonNull [] value) throws StorageException {
                return ((ArrayList)InPlaceByteArrayWrapper.LIST_OF_BYTE_ARRAY_SERIALIZER.deserialize((Object)value)).stream().map(bytes -> new AbbreviatedLocationPath(bytes.getBytes())).collect(Collectors.toCollection(ArrayList::new));
            }
        };

        private AbbreviatedLocationPath(byte[] bytes) {
            super(bytes);
        }
    }

    private record IndexUpdateInformation(Map<AnalysisPathIndexKey, ArrayList<AbbreviatedLocationPath>> updatedAnalysisPathIndexEntries, Map<InPlaceByteArrayWrapper, ArrayList<InPlaceByteArrayWrapper>> updatedPathToFindingsIndexEntries) {
    }

    private record FindingHashAndSerializedFinding(FindingHash findingHash, SerializedFinding serializedFinding) {
    }

    public record KeyComponents(String findingLocationPath, String analyzedPath, String findingIndexPartition) {
    }
}

