/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.dart_lint;

import com.teamscale.index.findings.YamlLinterConfigurationFileGenerator;
import com.teamscale.index.findings.bandit.FindingInfo;
import com.teamscale.index.findings.dart_lint.DartLintReportParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.version.Version;

public class DartLintRunner {
    private static final String DART_EXEC = "dart";
    public static final String ANALYSIS_DIR = "src";
    private static final String CONFIG_FILE_NAME = "analysis_options.yaml";
    static final String DART_LINT_CHECK_ID_PREFIX = "dart.";
    public static final String DART_LINT_CONFIG_SECTION_NAME = "linter.rules";

    public static @NonNull Version executeVersionInfo() throws IOException, FormatException {
        List<String> command = List.of(DART_EXEC, "--version");
        ProcessUtils.ExecutionResult result = ProcessUtils.execute((ProcessBuilder)new ProcessBuilder(command));
        String firstLine = StringUtils.getFirstLine((String)result.getStdout().substring(18, 21));
        return Version.parseVersion((String)firstLine);
    }

    public static @NonNull List<FindingInfo> executeAnalysis(@Nullable CanonicalFile workingDir) throws IOException, ConQATException {
        List<String> command = List.of(DART_EXEC, "analyze", ANALYSIS_DIR, "--format=json");
        ProcessBuilder processBuilder = new ProcessBuilder(command).directory((File)workingDir);
        ProcessUtils.ExecutionResult result = ProcessUtils.execute((ProcessBuilder)processBuilder);
        return DartLintReportParser.parse(result.getStdout());
    }

    public static void prepareWorkingDirAndConfig(CanonicalFile workingDir, List<String> enabledChecks, List<String> selectedOptions, List<String> checkOptionValues, List<String> checkOptionTypes) throws IOException {
        FileSystemUtils.ensureDirectoryExists((Path)workingDir.toPath());
        CanonicalFile configFile = new CanonicalFile((File)workingDir, CONFIG_FILE_NAME);
        YamlLinterConfigurationFileGenerator config = new YamlLinterConfigurationFileGenerator(DART_LINT_CONFIG_SECTION_NAME, DartLintRunner.stripPrefix(enabledChecks), selectedOptions, checkOptionValues, checkOptionTypes);
        FileSystemUtils.writeFileUTF8((Path)configFile.toPath(), (String)config.generateConfiguration());
    }

    private static List<String> stripPrefix(List<String> checksWithPrefix) {
        return checksWithPrefix.stream().map(s -> StringUtils.getFirstPart((String)StringUtils.stripPrefix((String)s, (String)DART_LINT_CHECK_ID_PREFIX), (String)".")).toList();
    }
}

