/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.index.findings.kubescore.KubernetesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.net.UrlUtils;

public class KustomizationReader {
    private static final String CONFIG_MAP_GENERATOR = "configMapGenerator";
    private static final String RESOURCES = "resources";
    private static final String PATCHES = "patches";
    private static final String PATCHES_JSON_6902 = "patchesJson6902";
    private static final String PATCHES_STRATEGIC_MERGE = "patchesStrategicMerge";
    private static final String COMPONENTS = "components";
    private static final String REPLACEMENTS = "replacements";
    private static final String SECRET_GENERATOR = "secretGenerator";
    private static final String HELM_CHART_INFLATION_GENERATOR = "helmChartInflationGenerator";
    private static final String CRDS = "crds";
    private static final String OPENAPI = "openapi";
    private static final List<String> RELEVANT_TAGS = List.of("configMapGenerator", "resources", "patches", "patchesJson6902", "patchesStrategicMerge", "components", "replacements", "secretGenerator", "helmChartInflationGenerator", "crds", "openapi");

    private KustomizationReader() {
    }

    public static Set<String> getFilesForKustomization(String kustomizationUniformPath, @Nullable Map<String, Object> source) {
        HashSet<String> result = new HashSet<String>();
        if (source == null) {
            return result;
        }
        for (String tag : RELEVANT_TAGS) {
            Object tagContent = source.get(tag);
            if (tagContent == null) continue;
            try {
                result.addAll(KustomizationReader.extractResourcesFromTag(tag, tagContent));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(e.getMessage() + "\nTag: " + tag + "\nKustomization file: " + kustomizationUniformPath, e);
            }
        }
        return KustomizationReader.resolvePaths(kustomizationUniformPath, result);
    }

    private static List<String> extractResourcesFromTag(String tag, Object tagContent) throws IllegalArgumentException {
        return switch (tag) {
            case CONFIG_MAP_GENERATOR, SECRET_GENERATOR -> KustomizationReader.parseGeneratorForFilesAndEnvs(tagContent);
            case RESOURCES -> KustomizationReader.parseResources(tagContent);
            case PATCHES -> KustomizationReader.getPathFromListItemsOrString(tagContent);
            case PATCHES_JSON_6902, REPLACEMENTS -> KustomizationReader.getPathFromListItems(KubernetesUtils.convertToListMap(tagContent));
            case PATCHES_STRATEGIC_MERGE -> KustomizationReader.parsePatchesStrategicMerge(KubernetesUtils.convertToStringList(tagContent));
            case COMPONENTS, CRDS -> KubernetesUtils.convertToStringList(tagContent);
            case HELM_CHART_INFLATION_GENERATOR -> KustomizationReader.parseHelmChartInflationGenerator(KubernetesUtils.convertToListMap(tagContent));
            case OPENAPI -> KustomizationReader.getPathFromListItems(Collections.singletonList(KubernetesUtils.convertToMap(tagContent)));
            default -> CollectionUtils.emptyList();
        };
    }

    private static Set<String> resolvePaths(String kustomizationUniformPath, Set<String> kustomizationPaths) {
        String[] segments = UniformPathUtils.splitPath((String)kustomizationUniformPath);
        String root = segments[0];
        HashSet<String> result = new HashSet<String>();
        for (String kustomizationPath : kustomizationPaths) {
            if (!kustomizationPath.contains(root + "/")) {
                result.add(UniformPathUtils.resolveRelativePath((String)kustomizationUniformPath, (String)kustomizationPath));
                continue;
            }
            result.add(kustomizationPath.substring(kustomizationPath.indexOf(root)));
        }
        return result;
    }

    private static List<String> parseGeneratorForFilesAndEnvs(Object object) {
        List<Map<String, Object>> configMapGenerator = KubernetesUtils.convertToListMap(object);
        ArrayList<String> files = new ArrayList<String>();
        for (Map<String, Object> entity : configMapGenerator) {
            Object varsEntity;
            Object filesEntity = entity.get("files");
            if (filesEntity != null) {
                files.addAll(KustomizationReader.parseFiles(filesEntity));
            }
            if ((varsEntity = entity.get("envs")) == null) continue;
            files.addAll(KubernetesUtils.convertToStringList(varsEntity));
        }
        return files;
    }

    private static List<String> parseFiles(Object filesEntity) {
        ArrayList<String> files = new ArrayList<String>();
        List<String> filesEntityStringList = KubernetesUtils.convertToStringList(filesEntity);
        for (String file : filesEntityStringList) {
            if (file.contains("=")) {
                files.add(file.substring(file.indexOf("=") + 1));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    private static List<String> parseHelmChartInflationGenerator(List<Map<String, Object>> helmChartInflationGenerator) {
        ArrayList<String> files = new ArrayList<String>();
        for (Map<String, Object> entity : helmChartInflationGenerator) {
            if (entity.get("chartHome") != null) {
                files.add((String)entity.get("chartHome"));
            }
            if (entity.get("valuesFile") == null) continue;
            files.add((String)entity.get("valuesFile"));
        }
        return files;
    }

    private static List<String> parsePatchesStrategicMerge(List<String> patchesStrategicMerge) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String entity : patchesStrategicMerge) {
            if (!entity.endsWith(".yaml") && !entity.endsWith(".yml")) continue;
            paths.add(entity);
        }
        return paths;
    }

    private static List<String> parseResources(Object object) {
        return KubernetesUtils.convertToStringList(object).stream().filter(resource -> !UrlUtils.URL_PATTERN.matcher((CharSequence)resource).matches()).toList();
    }

    private static List<String> getPathFromListItems(List<Map<String, Object>> list) {
        return list.stream().map(entity -> entity.get("path")).filter(Objects::nonNull).map(pathEntity -> (String)pathEntity).toList();
    }

    private static List<String> getPathFromListItemsOrString(Object object) {
        List list = (List)object;
        if (list.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        if (list.get(0) instanceof String) {
            return KustomizationReader.parseResources(object);
        }
        return KustomizationReader.getPathFromListItems(KubernetesUtils.convertToListMap(object));
    }
}

