/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.issue_reference.CodeToIssueReferenceMappingSynchronizer;
import com.teamscale.index.issues.FindingIssueMappingSynchronizer;
import com.teamscale.index.issues.IssueTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.PathIssueSynchronizer;
import com.teamscale.index.repository.RepositoryCommitIssueMappingSynchronizer;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class BugTrackerConnectorDescriptorBase
extends IssueTrackerConnectorDescriptorBase {
    protected static final String PROJECTS_PARAMETER_NAME = "Projects";
    protected static final String CUSTOM_FIELDS_PARAMETER = "Custom Fields";
    public static final String ISSUE_ID_COMMITS_PATTERN = "Issue ID pattern in commit messages";
    public static final String ISSUE_ID_TRANSFORMATION_IN_COMMITS = "Issue ID transformation in commit messages";
    private static final String ISSUE_ID_IN_COMMIT_MESSAGE_EXAMPLE = "An example would be 'CR#[ :]*(\\d+)' which would link the issue '42' to the commit 'CR#42 fixed build'. ";
    private static final String ISSUE_ID_IN_BRANCH_NAME_EXAMPLE = "An example would be 'cr\\/(\\w+-\\d+)' which would link the issue 'TEST-12' to all commits in the branch 'cr/TEST-12_some_feature'. ";
    private static final String REGEX_GUIDELINE_DESCRIPTION = "This is a regular expression that must contain one or more capturing groups (enclosed in parentheses). Each capturing group matched in a commit message will be considered an issue linked to that commit. ";
    private static final String REGEX_HINTS = "Use '(?:...)' to write non-capturing groups. Leave this empty to deactivate the mapping feature.";
    public static final String ISSUE_ID_INSIDE_COMMIT_MESSAGE_PATTERN_DESCRIPTION = "The pattern used to recognize issue IDs in a commit messages. This is a regular expression that must contain one or more capturing groups (enclosed in parentheses). Each capturing group matched in a commit message will be considered an issue linked to that commit. An example would be 'CR#[ :]*(\\d+)' which would link the issue '42' to the commit 'CR#42 fixed build'. Use '(?:...)' to write non-capturing groups. Leave this empty to deactivate the mapping feature.";
    private static final String ISSUE_ID_INSIDE_BRANCH_NAME_PATTERN_DESCRIPTION = "The pattern used to recognize issue IDs in a branch names. This is a regular expression that must contain one or more capturing groups (enclosed in parentheses). Each capturing group matched in a commit message will be considered an issue linked to that commit. An example would be 'cr\\/(\\w+-\\d+)' which would link the issue 'TEST-12' to all commits in the branch 'cr/TEST-12_some_feature'. Use '(?:...)' to write non-capturing groups. Leave this empty to deactivate the mapping feature.";
    public static final String HIDE_RESOLVED_FINDINGS_OPTION_NAME = "Hide resolved findings in issue badges";
    public static final String CONNECTOR_IDENTIFIER_PARAMETER_DESCRIPTION = "A unique identifier used to reference the issue connector.";
    public static final String CONNECTOR_IDENTIFIER_PARAMETER_NAME = "Issue Connector identifier";
    public static final String DEFAULT_CONNECTOR_IDENTIFIER = "issues1";
    public static final String DEFAULT_ISSUE_PATTERN = "(\\w+-\\d+)";
    @ConfigExposed(name="Issue Connector identifier", description="A unique identifier used to reference the issue connector.", required=true)
    private String connectorIdentifier = "issues1";
    @ConfigExposed(name="Issue ID pattern in commit messages", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The pattern used to recognize issue IDs in a commit messages. This is a regular expression that must contain one or more capturing groups (enclosed in parentheses). Each capturing group matched in a commit message will be considered an issue linked to that commit. An example would be 'CR#[ :]*(\\d+)' which would link the issue '42' to the commit 'CR#42 fixed build'. Use '(?:...)' to write non-capturing groups. Leave this empty to deactivate the mapping feature.")
    protected String crIssueInCommitPattern = "(\\w+-\\d+)";
    @ConfigExposed(name="Issue ID transformation in commit messages", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A transformation expression in the form `original expression -> transformed expression` which can translate the issue references in commit messages to actual issue IDs in the issue tracker. For example, `JIRA-(\\d+) -> MY_PROJECT_KEY-$1` (using the **Issue ID pattern in commit messages** `(JIRA-\\d+)`).\n**Important**: `original expression` is applied to matches of the capturing groups in the **Issue ID pattern in commit messages** option (**not the entire commit message**).\nIn `transformed expression`, capturing groups from `original expression` can be referenced by `$1`, `$2`, ...")
    protected PairList<String, String> issueIdCommitsTransformation = new PairList();
    private static final String ISSUE_ID_BRANCHES_TRANSFORMATION = "Issue id transformation in branch names";
    @ConfigExposed(name="Issue id transformation in branch names", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A transformation expression in the form `original expression -> transformed expression` which can translate the issue references in branch names to actual issue IDs in the issue tracker. For example, `JIRA-(\\d+) -> MY_PROJECT_KEY-$1` (using the **Issue ID pattern in branch names** `(JIRA-\\d+)`).\n**Important**: `original expression` is applied to matches of the capturing groups in the **Issue ID pattern in branch names** option (**not the entire commit message**).\nIn `transformed expression`, capturing groups from `original expression` can be referenced by `$1`, `$2`, ...")
    private PairList<String, String> issueIdBranchesTransformation = new PairList();
    private static final String ISSUE_ID_BRANCHES_PATTERN = "Issue ID pattern in branch names";
    @ConfigExposed(name="Issue ID pattern in branch names", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The pattern used to recognize issue IDs in a branch names. This is a regular expression that must contain one or more capturing groups (enclosed in parentheses). Each capturing group matched in a commit message will be considered an issue linked to that commit. An example would be 'cr\\/(\\w+-\\d+)' which would link the issue 'TEST-12' to all commits in the branch 'cr/TEST-12_some_feature'. Use '(?:...)' to write non-capturing groups. Leave this empty to deactivate the mapping feature.")
    protected String crIssueInBranchPattern = null;
    private static final String ISSUE_ID_IN_COMMENT_PATTERN_NAME = "Issue ID pattern in source code comments";
    private static final String ISSUE_ID_IN_COMMENT_PATTERN_DESCRIPTION = "The pattern used to recognize issue IDs in source code comments. This will allow to jump from matching code comments to the respective issue via links in Teamscale's code view.This is a regular expression that must contain one or more capturing groups (enclosed in parentheses). Each capturing group matched in a commit message will be considered an issue linked to that commit. An example would be 'cr\\/(\\w+-\\d+)' which would link the issue 'TEST-12' to all commits in the branch 'cr/TEST-12_some_feature'. Use '(?:...)' to write non-capturing groups. Leave this empty to deactivate the mapping feature.";
    @ConfigExposed(name="Issue ID pattern in source code comments", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The pattern used to recognize issue IDs in source code comments. This will allow to jump from matching code comments to the respective issue via links in Teamscale's code view.This is a regular expression that must contain one or more capturing groups (enclosed in parentheses). Each capturing group matched in a commit message will be considered an issue linked to that commit. An example would be 'cr\\/(\\w+-\\d+)' which would link the issue 'TEST-12' to all commits in the branch 'cr/TEST-12_some_feature'. Use '(?:...)' to write non-capturing groups. Leave this empty to deactivate the mapping feature.")
    protected String issueIdInCommentPattern = null;
    @ConfigExposed(name="Projects", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The projects (or products) in the issue tracker that issues are extracted from.\nFor Jira, it is possible to specify the project key or the project name.")
    protected List<String> projects = CollectionUtils.emptyList();
    @ConfigExposed(name="Custom Fields", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Custom fields to be included. This is a pair list of the field's name and a boolean indicating whether the content of the field should be interpreted as a username. Example: 'release-relevant -> false, reviewer -> true'. Names must be unique within each issue. If an issue has multiple fields with identical names, only the first non-empty one is imported.")
    protected PairList<String, Boolean> customFields = new PairList();
    @ConfigExposed(name="Hide resolved findings in issue badges", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="If set, hides all resolved findings in the badges for a single issue (even when the findings were resolved in a different issue)")
    private boolean hideResolvedFindingsInBadges = false;

    protected BugTrackerConnectorDescriptorBase(EIssueTracker issueTrackerType) {
        super((IConnectorEnum<?>)issueTrackerType, EConnectorType.ISSUE_TRACKER);
    }

    protected BugTrackerConnectorDescriptorBase(EIssueTracker issueTrackerType, AccountCredentials accountIdentifier) {
        super((IConnectorEnum<?>)issueTrackerType, EConnectorType.ISSUE_TRACKER, accountIdentifier);
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        String connectorIdentifier = this.getConnectorIdentifier();
        TriggerBuilder issueMappingSynchronizer = BugTrackerConnectorDescriptorBase.createIssueMappingSynchronizer(connectorIdentifier);
        if (this.crIssueInCommitPattern != null) {
            issueMappingSynchronizer.setTriggerParameter("issue-in-commit-pattern", this.crIssueInCommitPattern);
            issueMappingSynchronizer.setTriggerParameter("issue-id-commit-rename-rule", ITriggerParameter.of(this.issueIdCommitsTransformation));
        }
        if (this.crIssueInBranchPattern != null) {
            issueMappingSynchronizer.setTriggerParameter("issue-in-branch-pattern", this.crIssueInBranchPattern);
            issueMappingSynchronizer.setTriggerParameter("issue-id-branch-rename-rule", ITriggerParameter.of(this.issueIdBranchesTransformation));
        }
        if (this.crIssueInBranchPattern != null || this.crIssueInCommitPattern != null) {
            triggerCreator.createTrigger(issueMappingSynchronizer, connectorIdentifier);
            triggerCreator.createTrigger(BugTrackerConnectorDescriptorBase.createPathIssueSynchronizer(), connectorIdentifier);
            triggerCreator.createTrigger(new TriggerBuilder(FindingIssueMappingSynchronizer.class, ETriggerConcurrency.PARALLEL), connectorIdentifier);
        }
        if (this.issueIdInCommentPattern != null && !this.issueIdInCommentPattern.equals("")) {
            this.createIssueReferenceMappingSynchronizer(triggerCreator, connectorIdentifier);
        }
    }

    public static TriggerBuilder createIssueMappingSynchronizer(String connectorIdentifier) {
        TriggerBuilder issueMappingSynchronizer = new TriggerBuilder(RepositoryCommitIssueMappingSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        issueMappingSynchronizer.setTriggerParameter("connector-id", connectorIdentifier);
        return issueMappingSynchronizer;
    }

    public static TriggerBuilder createPathIssueSynchronizer() {
        return new TriggerBuilder(PathIssueSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
    }

    public final String getConnectorIdentifier() {
        return this.connectorIdentifier;
    }

    @Override
    protected String getWorkItemIndexName() {
        return "issues";
    }

    private void createIssueReferenceMappingSynchronizer(ConnectorDescriptorBase.ITriggerCreator triggerCreator, String namePrefix) throws ProjectConfigurationException {
        TriggerBuilder issueReferenceMappingSynchronizer = new TriggerBuilder(CodeToIssueReferenceMappingSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        issueReferenceMappingSynchronizer.setTriggerParameter("connector-id", this.getConnectorIdentifier());
        issueReferenceMappingSynchronizer.setTriggerParameter("issue-id-in-comment-pattern", this.issueIdInCommentPattern);
        triggerCreator.createTrigger(issueReferenceMappingSynchronizer, namePrefix);
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setSchedulingParameter(ESchedulingParameter.CONCURRENCY, (Object)ETriggerConcurrency.OUTPUT_ISOLATED);
        issueTrackerTriggerBuilder.setTriggerParameter("custom-field", ITriggerParameter.of(this.customFields));
        this.setProjectsParameter(issueTrackerTriggerBuilder);
    }

    protected void setProjectsParameter(TriggerBuilder issueTrackerTriggerBuilder) {
        issueTrackerTriggerBuilder.setTriggerParameter("project", ITriggerParameter.of(this.projects));
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        ConnectorUtils.validateCapturingGroupInRegexPattern((String)this.crIssueInCommitPattern, (String)ISSUE_ID_COMMITS_PATTERN);
        ConnectorUtils.validateCapturingGroupInRegexPattern((String)this.crIssueInBranchPattern, (String)ISSUE_ID_BRANCHES_PATTERN);
        ConnectorUtils.validateCapturingGroupInRegexPattern((String)this.issueIdInCommentPattern, (String)ISSUE_ID_IN_COMMENT_PATTERN_NAME);
    }

    public String getConnectorIdentifierOptionName() {
        return CONNECTOR_IDENTIFIER_PARAMETER_NAME;
    }

    @TestOnly
    public void setProjectsForTesting(String project) {
        this.projects = new ArrayList<String>();
        this.projects.add(project);
    }

    @VisibleForTesting
    public PairList<String, Boolean> getCustomFields() {
        return this.customFields;
    }
}

