/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IStorageKeyTranslatingIndex;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public abstract class IssueIndexBase<T extends TeamscaleIssue>
implements IProjectIndex,
IStorageKeyTranslatingIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ValueIndex<T> valueDelegate;
    private final SimpleCrudIndex<SimpleCrudIndex.ESingletonKey, Integer> valueCountDelegate;
    private final SimpleCrudIndex<String, Long> lastChangeTimestampDelegate;
    private final KeysOnlyIndex storedConnectorIdsDelegate;

    protected IssueIndexBase(IStore store) {
        this.valueDelegate = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "values"));
        this.valueCountDelegate = SimpleCrudIndex.forSingleKey((IStore)new DelegatingPartitionStore(store, "count"), (ISerializer)ISerializer.forInteger());
        this.lastChangeTimestampDelegate = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, "last-change-timestamp"), ISerializer.forString(), ISerializer.forLong());
        this.storedConnectorIdsDelegate = new KeysOnlyIndex((IStore)new DelegatingPartitionStore(store, "connector-ids"));
    }

    public @Nullable T getIssue(@NonNull TeamscaleIssueId id) throws StorageException {
        CCSMAssert.isNotNull((Object)id, () -> String.format("Expected \"%s\" to be not null", "id"));
        return this.getIssueForInternalId(id.getInternalId());
    }

    public @Nullable T getIssueForInternalId(@NonNull String internalId) throws StorageException {
        return (T)((TeamscaleIssue)this.valueDelegate.getValue(internalId));
    }

    public @NonNull List<@Nullable T> getIssues(@NonNull Collection<@NonNull TeamscaleIssueId> ids) throws StorageException {
        CCSMAssert.isNotNull(ids, () -> String.format("Expected \"%s\" to be not null", "ids"));
        return this.getIssuesForInternalIds(IssueIndexBase.toInternalIds(ids, Collectors.toList()));
    }

    public @NonNull List<@Nullable T> getIssuesForInternalIds(@NonNull Collection<@NonNull String> internalIds) throws StorageException {
        CCSMAssert.isNotNull(internalIds, () -> String.format("Expected \"%s\" to be not null", "internalIds"));
        if (internalIds instanceof List) {
            this.valueDelegate.getValues((List)internalIds);
        }
        return this.valueDelegate.getValues(new ArrayList<String>(internalIds));
    }

    public @NonNull List<@NonNull T> getIssuesForExternalId(@NonNull String externalId) throws StorageException {
        return this.getIssuesForInternalOrExternalId(externalId, false);
    }

    public @NonNull List<@NonNull T> getIssuesForInternalOrExternalId(@NonNull String internalOrExternalId, boolean internalIdExpected) throws StorageException {
        List<TeamscaleIssueId> possibleIds = this.getPossibleIds(internalOrExternalId, internalIdExpected);
        return this.getIssues(possibleIds).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public @NonNull List<@NonNull TeamscaleIssueId> getPossibleIds(String internalOrExternalId, boolean internalIdExpected) throws StorageException {
        if (TeamscaleIssueId.isValidInternalId((String)internalOrExternalId)) {
            return List.of(TeamscaleIssueId.fromInternalId((String)internalOrExternalId));
        }
        if (internalIdExpected) {
            LOGGER.warn("Services should be migrated to use the new issueId format. {}", (Object)"The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\".");
        }
        return this.getAllConnectorIds().stream().map(connectorId -> new TeamscaleIssueId(connectorId, internalOrExternalId)).collect(Collectors.toList());
    }

    private void updateIssueCount() throws StorageException {
        this.valueCountDelegate.put((Object)SimpleCrudIndex.ESingletonKey.INSTANCE, (Object)this.getAllKeys().size());
    }

    public void setIssue(@NonNull T issue) throws StorageException {
        CCSMAssert.isNotNull(issue, () -> String.format("Expected \"%s\" to be not null", "issue"));
        this.valueDelegate.setValue(issue.getIdAsString(), issue);
        this.addConnectorId(issue.getId().getConnectorId());
        this.updateIssueCount();
    }

    public void setIssues(@NonNull Collection<@NonNull T> issues) throws StorageException {
        CCSMAssert.isNotNull(issues, () -> String.format("Expected \"%s\" to be not null", "issues"));
        this.valueDelegate.setValues((PairList)issues.stream().map(issue -> new Pair((Object)issue.getIdAsString(), issue)).collect(PairList.toPairList()));
        Set connectorIds = issues.stream().map(TeamscaleIssue::getId).map(TeamscaleIssueId::getConnectorId).collect(Collectors.toSet());
        for (String connectorId : connectorIds) {
            this.addConnectorId(connectorId);
        }
        this.updateIssueCount();
    }

    public @NonNull List<@NonNull T> getAllIssues() throws StorageException {
        return this.valueDelegate.getAllEntries().extractSecondList();
    }

    public @NonNull List<@NonNull TeamscaleIssueId> getAllKeys() throws StorageException {
        List allKeys = this.valueDelegate.getAllKeys();
        return IssueIndexBase.toTeamscaleIssueIds(allKeys, Collectors.toList());
    }

    public int getIssueCount() throws StorageException {
        return this.valueCountDelegate.get((Object)SimpleCrudIndex.ESingletonKey.INSTANCE).orElse(0);
    }

    public @NonNull List<@NonNull String> getAllKeysAsString() throws StorageException {
        return this.valueDelegate.getAllKeys();
    }

    public @NonNull List<@NonNull TeamscaleIssueId> getAllKeysForConnector(@NonNull String connectorId) throws StorageException {
        return this.getAllKeysStartingWith(connectorId, null);
    }

    public @NonNull List<@NonNull TeamscaleIssueId> getAllKeysStartingWith(@NonNull String connectorId, @Nullable String issuePrefix) throws StorageException {
        CCSMAssert.isNotEmpty((String)connectorId, () -> String.format("Expected \"%s\" to be not empty", "connectorId"));
        issuePrefix = StringUtils.emptyIfNull((String)issuePrefix);
        return IssueIndexBase.toTeamscaleIssueIds(this.valueDelegate.getKeysStartingWith(TeamscaleIssueId.computeInternalId((String)connectorId, (String)issuePrefix)), Collectors.toList());
    }

    private void addConnectorId(String connectorId) throws StorageException {
        this.storedConnectorIdsDelegate.storeKey(connectorId);
    }

    public @NonNull List<@NonNull String> getAllConnectorIds() throws StorageException {
        return this.storedConnectorIdsDelegate.listKeys();
    }

    public @NonNull OptionalLong getLastChange(@NonNull String connectorId) throws StorageException {
        CCSMAssert.isNotNull((Object)connectorId, () -> String.format("Expected \"%s\" to be not null", "connectorId"));
        return this.lastChangeTimestampDelegate.get((Object)connectorId).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    public void setLastChange(@NonNull String connectorId, @Nullable Long lastChange) throws StorageException {
        CCSMAssert.isNotNull((Object)connectorId, () -> String.format("Expected \"%s\" to be not null", "connectorId"));
        if (lastChange == null) {
            this.lastChangeTimestampDelegate.remove((Object)connectorId);
        } else {
            this.lastChangeTimestampDelegate.put((Object)connectorId, (Object)lastChange);
        }
    }

    public Set<TeamscaleIssueId> getContainedKeys(Collection<TeamscaleIssueId> issueIds) throws StorageException {
        Set containedKeys = this.valueDelegate.getContainedKeys(IssueIndexBase.toInternalIds(issueIds, Collectors.toList()));
        return IssueIndexBase.toTeamscaleIssueIds(containedKeys, Collectors.toSet());
    }

    public void removeIssues(Collection<TeamscaleIssueId> keys) throws StorageException {
        this.valueDelegate.removeValues(IssueIndexBase.toInternalIds(keys, Collectors.toList()));
        this.updateIssueCount();
    }

    public Set<StorageKey> resolveToPublicKeys(Collection<StorageKey> keys) throws IllegalArgumentException {
        HashSet<StorageKey> result = new HashSet<StorageKey>();
        for (StorageKey key : keys) {
            DelegatingPartitionStore valueStore;
            byte[] rawKey = key.getKey();
            IStore iStore = this.valueDelegate.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (valueStore = (DelegatingPartitionStore)iStore).isFromThisPartition(rawKey)) {
                result.add(new StorageKey(valueStore.getOriginalKey(rawKey)));
                continue;
            }
            if (this.isFromIgnoredStore(rawKey)) continue;
            throw new IllegalArgumentException("The key '%s' is not associated with this index.".formatted(key));
        }
        return result;
    }

    private boolean isFromIgnoredStore(byte[] rawKey) {
        for (IUtilityIndex iUtilityIndex : List.of(this.lastChangeTimestampDelegate, this.storedConnectorIdsDelegate, this.valueCountDelegate)) {
            if (!((DelegatingPartitionStore)iUtilityIndex.getWrappedStore(DelegatingPartitionStore.class)).isFromThisPartition(rawKey)) continue;
            return true;
        }
        return false;
    }

    public KeyDelta resolveDelta(KeyDelta delta) {
        return new KeyDelta(this.resolveToPublicKeys((Collection<StorageKey>)delta.getAddedOrChangedKeys()), this.resolveToPublicKeys((Collection<StorageKey>)delta.getDeletedKeys()));
    }

    private static <T extends Collection<String>> T toInternalIds(Collection<TeamscaleIssueId> issueIds, Collector<String, ?, T> collector) {
        return (T)((Collection)issueIds.stream().map(TeamscaleIssueId::getInternalId).collect(collector));
    }

    private static <T extends Collection<TeamscaleIssueId>> T toTeamscaleIssueIds(Collection<String> internalIds, Collector<TeamscaleIssueId, ?, T> collector) {
        return (T)((Collection)internalIds.stream().map(TeamscaleIssueId::fromInternalId).collect(collector));
    }
}

