/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.authenticate.github.GitHubUtils;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.github.client.GitHubIssueClient;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public abstract class GitHubIssueConnectorDescriptorBase
extends BugTrackerConnectorDescriptorBase {
    protected GitHubIssueConnectorDescriptorBase(EIssueTracker issueTrackerType) {
        super(issueTrackerType);
        this.autoExpose();
    }

    protected void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        Optional repositoryData = GitHubUtils.getUserAndRepositoryNameFromUrl((String)url);
        if (repositoryData.isEmpty()) {
            throw new ConnectorValidationException("Invalid repository url: " + url);
        }
        String repositoryOwner = (String)((Pair)repositoryData.get()).getFirst();
        String githubUrl = url.substring(0, url.indexOf(repositoryOwner));
        GitHubIssueClient client = new GitHubIssueClient(GitHubUtils.getApiBaseUrl((String)githubUrl), username, password, this.getLogger());
        try {
            client.testGetIssues(new PlatformRepositoryIdentifier(repositoryOwner, (String)((Pair)repositoryData.get()).getSecond()));
            if (StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)password) && ConfigurationInitializationContext.EInitializationReason.BACKUP != this.getContext().getReason()) {
                this.validateAccessToken(client);
            }
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    protected abstract void validateAccessToken(GitHubIssueClient var1) throws ServiceCallException;

    protected abstract Logger getLogger();
}

