/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.gitlab.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.issues.gitlab.client.model.EGitLabIssueState;
import com.teamscale.index.issues.gitlab.client.model.EGitLabIssueType;
import com.teamscale.index.issues.gitlab.client.model.GitLabIssueStateEvent;
import com.teamscale.index.issues.gitlab.client.model.GitLabUser;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public record GitLabIssue(@JsonProperty(value="id") long id, @JsonProperty(value="iid") long issueId, @JsonProperty(value="project_id") long projectId, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="state") EGitLabIssueState state, @JsonProperty(value="created_at") Instant createdAt, @JsonProperty(value="updated_at") Instant updatedAt, @JsonProperty(value="closed_at") @Nullable Instant closedAt, @JsonProperty(value="closed_by") @Nullable GitLabUser closedBy, @JsonProperty(value="labels") List<String> labels, @JsonProperty(value="assignees") List<GitLabUser> assignees, @JsonProperty(value="author") GitLabUser author, @JsonProperty(value="issue_type") EGitLabIssueType issueType, @JsonProperty(value="web_url") URI webUrl) {
    public GitLabIssue withStateChange(GitLabIssueStateEvent stateChange) {
        Instant closedAt = stateChange.state() == EGitLabIssueState.CLOSED ? stateChange.createdAt() : null;
        GitLabUser closedBy = stateChange.state() == EGitLabIssueState.CLOSED ? stateChange.user() : null;
        return new GitLabIssue(this.id, this.issueId, this.projectId, this.title, this.description, stateChange.state(), this.createdAt, stateChange.createdAt(), closedAt, closedBy, this.labels, this.assignees, this.author, this.issueType, this.webUrl);
    }

    public GitLabIssue atCreation() {
        return new GitLabIssue(this.id, this.issueId, this.projectId, this.title, this.description, EGitLabIssueState.OPEN, this.createdAt, this.createdAt, null, null, this.labels, this.assignees, this.author, this.issueType, this.webUrl);
    }
}

