/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.client;

import com.google.common.collect.Lists;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.issues.jira.client.IJiraCloudApi;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.client.JiraInstanceAwareClient;
import com.teamscale.index.issues.jira.model.JiraBulkFetchIssuesRequestBody;
import com.teamscale.index.issues.jira.model.JiraIssueIdSearchResponse;
import com.teamscale.index.issues.jira.model.JiraProject;
import com.teamscale.index.issues.jira.model.JiraProjectSearchResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jetbrains.annotations.VisibleForTesting;

public class JiraCloudClient
extends JiraInstanceAwareClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_RESULTS = 5000;
    private final IJiraCloudApi jira;

    public JiraCloudClient(String baseUrl, @Nullable String username, String password, List<String> cookies) {
        super(baseUrl, username, password, cookies);
        this.jira = (IJiraCloudApi)JiraCloudClient.configureAuthenticationMode(Retrofit.builder((String)baseUrl), username, password).withInteractionLogger(LOGGER).withCookies(cookies).create(IJiraCloudApi.class);
    }

    @Override
    protected List<CompletableFuture<String>> createAndStartIssueRetrieverCallables(ExecutorService executor, Set<String> projects, long lastScanTimestamp, UnmodifiableList<String> fieldsToFetch, Set<String> issueTypes) throws ServiceCallException, CompletionException {
        String jqlQuery = JiraCloudClient.createIssueQueryString(projects, lastScanTimestamp, issueTypes);
        List<String> allIssueIds = this.getAllIssueIds(jqlQuery);
        LOGGER.info("Issues to retrieve: {}", (Object)allIssueIds.size());
        if (allIssueIds.isEmpty()) {
            return new ArrayList<CompletableFuture<String>>();
        }
        List<List<String>> issueIdBatches = JiraCloudClient.splitIntoBatches(allIssueIds);
        return CollectionUtils.map(issueIdBatches, batch -> CompletableFuture.supplyAsync(() -> {
            try {
                return this.retrieveIssues((List<String>)batch, fieldsToFetch);
            }
            catch (ServiceCallException e) {
                throw new CompletionException(e);
            }
        }, executor));
    }

    private static List<List<String>> splitIntoBatches(List<String> allIssueIds) {
        if (CollectionUtils.isNullOrEmpty(allIssueIds)) {
            return new ArrayList<List<String>>();
        }
        return Lists.partition(allIssueIds, (int)ISSUE_CHUNK_SIZE);
    }

    private String retrieveIssues(List<String> issueIdsToRetrieve, UnmodifiableList<String> fieldsToFetch) throws ServiceCallException {
        LOGGER.debug("Bulk fetching issues: {}", (Object)String.join((CharSequence)", ", issueIdsToRetrieve));
        return this.bulkFetchIssues(issueIdsToRetrieve, (List<String>)fieldsToFetch);
    }

    @Override
    public Map<String, String> getProjectNamesByKey() throws ServiceCallException {
        List allProjects = HttpPaginationUtils.executeGetWithNextParameterPagination(() -> this.jira.searchProjects(this.getMaxResults()), this.jira::searchProjectsFromNextPage, JiraProjectSearchResponse::getNextPage, JiraProjectSearchResponse::getProjects);
        return allProjects.stream().collect(Collectors.toMap(JiraProject::key, JiraProject::name));
    }

    private String bulkFetchIssues(List<String> issueIdsOrKeys, List<String> fieldsToFetch) throws ServiceCallException {
        String string;
        block8: {
            JiraBulkFetchIssuesRequestBody bulkFetchIssuesRequest = new JiraBulkFetchIssuesRequestBody(issueIdsOrKeys, FIELDS_TO_EXPAND, fieldsToFetch);
            ResponseBody responseBody = (ResponseBody)Retrofit.executeServiceCall(this.jira.bulkFetchIssues(bulkFetchIssuesRequest)).orElseThrow(JiraClient::createEmptyResponseException);
            try {
                string = responseBody.string();
                if (responseBody == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (responseBody != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceCallException((Throwable)e);
                }
            }
            responseBody.close();
        }
        return string;
    }

    public List<String> getAllIssueIds(String jqlQuery) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithNextParameterPagination(() -> this.jira.searchIssueIds(jqlQuery, this.getMaxResults(), null), token -> this.jira.searchIssueIds(jqlQuery, this.getMaxResults(), (String)token), JiraIssueIdSearchResponse::getNextPageToken, JiraIssueIdSearchResponse::getIssueIds);
    }

    @VisibleForTesting
    public int getMaxResults() {
        return 5000;
    }
}

