/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.radar;

import com.google.common.base.Preconditions;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.option.AppleA3Option;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.ICustomFieldsProvidingConnectorDescriptor;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import com.teamscale.index.issues.radar.RadarIssueSynchronizer;
import com.teamscale.index.issues.radar.client.RadarClient;
import com.teamscale.index.issues.radar.model.RadarComponentBundle;
import com.teamscale.index.issues.radar.model.RadarComponentBundleGroup;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@ConnectorDescriptor(enabledByFeatureToggle=EFeatureToggle.ENABLE_APPLE_SPECIFIC_FEATURES)
public class RadarConnectorDescriptor
extends BugTrackerConnectorDescriptorBase
implements ICustomFieldsProvidingConnectorDescriptor {
    public static final String APPLE_A3_OPTION_NOT_SET_ERROR_MESSAGE = "Apple A3 Option must be set.";
    public static final String COMPONENT_FIELDS_MUST_BE_SET_MESSAGE = "At least one \"Component\", \"Component Bundle\", or \"Component Bundle Group\" must be specified.";
    private static final List<String> CUSTOM_FIELD_NAMES = List.of("actionTaken", "adcNotes", "agileAttributes", "assigneeLastModifiedAt", "attachments", "builds", "category", "ccList", "classification", "closedAt", "componentID", "configuration", "configurationSummary", "counts", "dateNeededCurrent", "dateNeededOriginal", "diagnosis", "diagnosisHistory", "dri", "duplicateOfProblemID", "effort", "enclosureLastModified", "epm", "event", "failedModule", "failureDetail", "fingerprint", "fixOrder", "hasReleaseNotes", "hasSourceChanges", "hasWorkaround", "impact", "isApproved", "isAutoCalculated", "isComponentEPMOverridden", "isExternallyViewable", "isReadByAssignee", "isReadByProxy", "isRegressionRequired", "isSecurityDefault", "isThirdPartyAppRelated", "isUmbrella", "isVerifiedByTester", "keyValues", "keywordNames", "label", "labels", "milestone", "otherRelatedItems", "pictures", "priority", "priorityText", "productSecurity", "protectionMaskList", "proxy", "recentAssignees", "relatedTests", "releaseNotes", "reproducible", "resolution", "resolutionCode", "resolvedAt", "resolvedBy", "schedule", "securityList", "smartFields", "sourceChanges", "stateCode", "stateTransitionMask", "substate", "subStateCode", "succinctSummaryRootCause", "targetCompletionCurrent", "targetCompletionOriginal", "targetStartDate", "taskOrder", "tentpole", "testCase", "thirdPartyProducts", "umbrellaPlannedEndDate", "umbrellaPlannedStartDate", "workaround");
    private static final String DEFAULT_ISSUE_PATTERN = "rdar://(?:problem/)?(\\d+)";
    @ConfigExposed(name="Components", visibility=ConfigExposed.EConfigVisibility.DEFAULT, description="List of Radar Component names separated by commas or newlines. They may be specified as a base component name (e.g. \"My Component\"), or with a version (e.g. \"My Component | Version\"). The union of Problems from ALL Components, Component Bundles, and Component Bundle Groups specified in this connector will be imported. At least one \"Component\", \"Component Bundle\", or \"Component Bundle Group\" must be specified.")
    private List<String> components;
    @ConfigExposed(name="Component Bundles", visibility=ConfigExposed.EConfigVisibility.DEFAULT, description="List of Radar Component Bundle names separated by commas or newlines. The union of Problems from ALL Components, Component Bundles, and Component Bundle Groups specified in this connector will be imported. At least one \"Component\", \"Component Bundle\", or \"Component Bundle Group\" must be specified.")
    private List<String> componentBundles;
    @ConfigExposed(name="Component Bundle Groups", visibility=ConfigExposed.EConfigVisibility.DEFAULT, description="List of Radar Component Bundle Group names separated by commas or newlines. The union of Problems from ALL Components, Component Bundles, and Component Bundle Groups specified in this connector will be imported. At least one \"Component\", \"Component Bundle\", or \"Component Bundle Group\" must be specified.")
    private List<String> componentBundleGroups;
    @ConfigExposed(name="Keywords", visibility=ConfigExposed.EConfigVisibility.DEFAULT, description="Only synchronize issues containing these keywords")
    private List<String> keywords = Collections.emptyList();
    @ConfigExposed(name="Apple A3 Option Identifier", visibility=ConfigExposed.EConfigVisibility.DEFAULT, description="Name of the Teamscale server option (multi-option identifier) of the Apple A3 option to use for this connector.")
    private @Nullable AppleA3Option appleA3MultiOptionIdentifier;
    private static final Logger LOGGER = LogManager.getLogger();

    protected RadarConnectorDescriptor() {
        super(EIssueTracker.RADAR);
        this.crIssueInCommitPattern = DEFAULT_ISSUE_PATTERN;
        this.autoExpose();
        this.hideOption("Account");
        this.hideOption("Projects");
    }

    @VisibleForTesting
    protected RadarConnectorDescriptor(List<String> components, List<String> componentBundles, List<String> componentBundleGroups, List<String> keywords, @Nullable AppleA3Option appleA3MultiOptionIdentifier, PairList<String, Boolean> customFields) {
        super(EIssueTracker.RADAR);
        this.components = components;
        this.componentBundles = componentBundles;
        this.componentBundleGroups = componentBundleGroups;
        this.keywords = keywords;
        this.appleA3MultiOptionIdentifier = appleA3MultiOptionIdentifier;
        this.customFields = customFields;
    }

    private static void validateRadarA3Authentication(RadarClient radarClient) throws ConnectorValidationException {
        try {
            radarClient.requestAuthenticationToken();
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException("Radar authentication token request failed.", (Throwable)e);
        }
    }

    private static void checkExistingAndNotAmbiguous(String elementType, String name, List<String> elementNames) throws ConnectorValidationException {
        if (elementNames.isEmpty() || !new HashSet<String>(elementNames).contains(name)) {
            throw new ConnectorValidationException(elementType + " does not exist: " + name);
        }
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        AppleA3Option a3Option = this.appleA3MultiOptionIdentifier;
        if (a3Option == null || StringUtils.isEmpty((String)a3Option.name())) {
            throw new ConnectorValidationException(APPLE_A3_OPTION_NOT_SET_ERROR_MESSAGE);
        }
        if (this.components.isEmpty() && this.componentBundles.isEmpty() && this.componentBundleGroups.isEmpty()) {
            throw new ConnectorValidationException(COMPONENT_FIELDS_MUST_BE_SET_MESSAGE);
        }
        try {
            RadarClient client = RadarClient.create((AccessTokenIndex)this.getContext().getIndexLayer().openGlobalIndex(AccessTokenIndex.class), (ServerOptionIndex)this.getContext().getIndexLayer().openGlobalIndex(ServerOptionIndex.class), a3Option.name(), LOGGER);
            RadarConnectorDescriptor.validateRadarA3Authentication(client);
            for (String keyword : this.keywords) {
                if (!client.findKeyword(keyword).isEmpty()) continue;
                throw new ConnectorValidationException("Keyword does not exist: " + keyword);
            }
            for (String component : this.components) {
                client.getComponent(component);
            }
            for (String componentBundleName : this.componentBundles) {
                RadarConnectorDescriptor.checkExistingAndNotAmbiguous("Component Bundle", componentBundleName, CollectionUtils.map(client.findComponentBundles(componentBundleName), RadarComponentBundle::name));
            }
            for (String componentBundleGroupName : this.componentBundleGroups) {
                RadarConnectorDescriptor.checkExistingAndNotAmbiguous("Component Bundle Group", componentBundleGroupName, CollectionUtils.map(client.findComponentBundleGroups(componentBundleGroupName), RadarComponentBundleGroup::name));
            }
        }
        catch (BugTrackerException | StorageException e) {
            throw new ConnectorValidationException(e);
        }
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        Preconditions.checkNotNull((Object)this.appleA3MultiOptionIdentifier, (Object)"This should have been already validated");
        issueTrackerTriggerBuilder.setTriggerParameter("keywords", ITriggerParameter.of(this.keywords));
        issueTrackerTriggerBuilder.setTriggerParameter("components", ITriggerParameter.of(this.components));
        issueTrackerTriggerBuilder.setTriggerParameter("component bundles", ITriggerParameter.of(this.componentBundles));
        issueTrackerTriggerBuilder.setTriggerParameter("component bundle groups", ITriggerParameter.of(this.componentBundleGroups));
        issueTrackerTriggerBuilder.setTriggerParameter("a3-option-identifier", this.appleA3MultiOptionIdentifier.name());
        issueTrackerTriggerBuilder.renameIndex("work-item-cleanup-index", WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(WorkItemCleanupIndex.class, WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return RadarIssueSynchronizer.class;
    }

    protected ExternalCredentials resolveExternalCredentials() throws ConnectorValidationException {
        throw new UnsupportedOperationException("Radar connector uses A3 authentication and does not support external credentials.");
    }

    protected void validateConnectionAndAuthenticationUsingExternalCredentials() {
    }

    protected void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        throw new UnsupportedOperationException("Radar connector uses A3 authentication and does not support external credentials.");
    }

    @Override
    public List<ExternalToolIssueCustomField> fetchCustomFields() {
        return CollectionUtils.map(CUSTOM_FIELD_NAMES, fieldName -> new ExternalToolIssueCustomField(fieldName, fieldName, false));
    }
}

