/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.metrics;

import com.teamscale.commons.links.TeamscaleLinkProvider;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.values.NumericMetricValue;
import com.teamscale.index.merge_request.metrics.IMergeRequestSingleMetricAssessmentEvaluationResult;
import com.teamscale.index.metrics.assessment.ETrend;
import com.teamscale.index.metrics.assessment.MetricAssessment;
import com.teamscale.index.metrics.assessment.TrendDelta;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.VisibleForTesting;

public record MergeRequestEvaluatedSingleMetricAssessment(MetricAssessment metricAssessment) implements IMergeRequestSingleMetricAssessmentEvaluationResult
{
    private static final DecimalFormat NUMERIC_NUMBER_FORMAT_FOR_VALUE = NumericMetricValue.createNumberFormat((String)"0.##");

    public String getFormattedName() {
        String metricName;
        String displayName = this.metricAssessment().getDisplayName();
        if (displayName.equals(metricName = this.metricAssessment().getMetricName()) || metricName == null) {
            return displayName;
        }
        return "%s (%s)".formatted(displayName, metricName);
    }

    private String getFormattedMetricValueAndDiff() {
        TrendDelta trendDelta = this.metricAssessment().getTrendDelta();
        String formattedTrendDelta = "";
        if (trendDelta.isAvailable()) {
            formattedTrendDelta = " (%s)".formatted(trendDelta.formattedText());
        }
        if (this.metricAssessment.getValue() == null) {
            return "N/A";
        }
        return "%s%s".formatted(MergeRequestEvaluatedSingleMetricAssessment.roundDoubleIfNumber(this.metricAssessment.getValue()), formattedTrendDelta);
    }

    @Contract(value="null -> null")
    @VisibleForTesting
    static @Nullable String roundDoubleIfNumber(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return NUMERIC_NUMBER_FORMAT_FOR_VALUE.format(value);
        }
        return value.toString();
    }

    @Override
    public String getTextDescription() {
        StringBuilder altTextBuilder = new StringBuilder();
        altTextBuilder.append(this.getFormattedName());
        MetricAssessment assessment = this.metricAssessment();
        ETrend trend = assessment.getTrend();
        if (trend != null) {
            TrendDelta trendDelta = assessment.getTrendDelta();
            if (trend == ETrend.UP || trend == ETrend.NA) {
                if (assessment.getValue() == null) {
                    altTextBuilder.append(" is not available");
                    if (!StringUtils.isEmpty((String)this.metricAssessment.getSubPath())) {
                        altTextBuilder.append(" for path '" + this.metricAssessment.getSubPath() + "'");
                    }
                } else {
                    altTextBuilder.append(" changed by ");
                    if (trendDelta.isAvailable()) {
                        altTextBuilder.append(trendDelta.formattedText());
                    } else {
                        altTextBuilder.append(MergeRequestEvaluatedSingleMetricAssessment.getMetricValueDisplayText(assessment.getValue()));
                    }
                }
            } else if (trend == ETrend.DOWN) {
                if (trendDelta.isAvailable()) {
                    altTextBuilder.append(" changed by ").append(trendDelta.formattedText());
                } else {
                    altTextBuilder.append(" is at ").append(MergeRequestEvaluatedSingleMetricAssessment.getMetricValueDisplayText(assessment.getValue()));
                }
            } else if (trend == ETrend.STABLE) {
                altTextBuilder.append(" is at ").append(MergeRequestEvaluatedSingleMetricAssessment.getMetricValueDisplayText(assessment.getValue()));
            }
        } else {
            altTextBuilder.append(" is at ").append(MergeRequestEvaluatedSingleMetricAssessment.getMetricValueDisplayText(assessment.getValue()));
        }
        altTextBuilder.append(".");
        if (assessment.getRating() != null) {
            boolean lowIsBad = assessment.getSchemaEntry().hasProperty(EMetricProperty.LOW_IS_BAD);
            switch (assessment.getRating()) {
                case RED: {
                    altTextBuilder.append(" It is ").append(lowIsBad ? "below" : "above").append(" the red threshold of ").append(assessment.getMetricThreshold().getThresholdRed()).append(".");
                    break;
                }
                case YELLOW: {
                    altTextBuilder.append(" It is ").append(lowIsBad ? "below" : "above").append(" the yellow threshold of ").append(assessment.getMetricThreshold().getThresholdYellow()).append(".");
                    break;
                }
                case GREEN: {
                    altTextBuilder.append(" It is ").append(lowIsBad ? "above" : "below").append(" the configured thresholds").append(".");
                    break;
                }
            }
        }
        return altTextBuilder.toString();
    }

    @Override
    public String getBadgeLink(TeamscaleLinkProvider linkProvider, @Nullable String incompleteBuildWarningText) {
        return linkProvider.createStaticMetricBadgeUrl(this.getFormattedName(), this.metricAssessment().getRating(), this.getFormattedMetricValueAndDiff(), incompleteBuildWarningText);
    }

    @Override
    public String getName() {
        return this.metricAssessment.getDisplayName();
    }

    @Override
    public Optional<String> getFormattedMetricValue() {
        return Optional.ofNullable(MergeRequestEvaluatedSingleMetricAssessment.getMetricValueDisplayText(this.metricAssessment.getValue()));
    }

    @Override
    public Optional<String> getFormattedMetricDelta() {
        if (!this.metricAssessment.getTrendDelta().isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(this.metricAssessment.getTrendDelta().formattedText());
    }

    @Override
    public ETrend getMetricTrend() {
        if (this.metricAssessment.getSchemaEntry().hasProperty(EMetricProperty.QUALITY_NEUTRAL)) {
            return ETrend.STABLE;
        }
        return Optional.ofNullable(this.metricAssessment.getTrend()).orElse(ETrend.NA);
    }

    @Override
    public boolean isNewThresholdViolation() {
        if (this.getMetricTrend() == ETrend.NA) {
            return false;
        }
        if (MergeRequestEvaluatedSingleMetricAssessment.violatesYellowThreshold(this.metricAssessment.getRating()) && !MergeRequestEvaluatedSingleMetricAssessment.violatesAnyThreshold(this.metricAssessment.getBaselineRating())) {
            return true;
        }
        return MergeRequestEvaluatedSingleMetricAssessment.violatesRedThreshold(this.metricAssessment.getRating()) && !MergeRequestEvaluatedSingleMetricAssessment.violatesRedThreshold(this.metricAssessment.getBaselineRating());
    }

    private static boolean violatesAnyThreshold(ETrafficLightColor rating) {
        return MergeRequestEvaluatedSingleMetricAssessment.violatesYellowThreshold(rating) || MergeRequestEvaluatedSingleMetricAssessment.violatesRedThreshold(rating);
    }

    private static boolean violatesYellowThreshold(ETrafficLightColor rating) {
        return rating == ETrafficLightColor.YELLOW;
    }

    private static boolean violatesRedThreshold(ETrafficLightColor rating) {
        return rating == ETrafficLightColor.RED;
    }

    @Override
    public Optional<String> getFormattedMetricThreshold() {
        Double threshold = this.metricAssessment.getRating() == ETrafficLightColor.RED ? this.metricAssessment.getMetricThreshold().getThresholdRed() : this.metricAssessment.getMetricThreshold().getThresholdYellow();
        if (threshold == null) {
            return Optional.empty();
        }
        return Optional.of(NUMERIC_NUMBER_FORMAT_FOR_VALUE.format(threshold));
    }

    @Override
    public boolean lowIsBad() {
        return this.metricAssessment.isLowBad();
    }

    @Contract(value="null -> null; !null -> !null")
    private static @Nullable String getMetricValueDisplayText(@Nullable Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Assessment.class, CounterSet.class, Number.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Assessment assessment = (Assessment)object;
                if (assessment.getSize() == 0) {
                    assessment = new Assessment(ETrafficLightColor.GREEN);
                }
                yield assessment.toFormattedColors();
            }
            case 1 -> {
                CounterSet counterSet = (CounterSet)object;
                yield counterSet.getKeys().stream().filter(Objects::nonNull).map(String::valueOf).filter(s -> !s.isBlank()).sorted().collect(Collectors.joining(", "));
            }
            case 2 -> {
                Number number = (Number)object;
                yield NUMERIC_NUMBER_FORMAT_FOR_VALUE.format(number);
            }
            default -> value.toString();
        };
    }

    @Override
    public boolean hasDelta() {
        return this.metricAssessment.hasDelta();
    }

    public Optional<Double> getAbsoluteDelta() {
        return this.metricAssessment.getAbsoluteDelta();
    }

    public Optional<Double> getNumericValue() {
        return this.metricAssessment.getNumericValue();
    }
}

