/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment.computation;

import com.teamscale.core.analysis.configuration.index.model.EAssessmentSpecification;
import com.teamscale.core.analysis.configuration.index.model.EThresholdEvaluationOption;
import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdBase;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.core.metrics.values.MetricValueBase;
import com.teamscale.index.metrics.assessment.ETrend;
import com.teamscale.index.metrics.assessment.TrendDelta;
import com.teamscale.index.metrics.assessment.computation.AssessmentMetricComputation;
import com.teamscale.index.metrics.assessment.computation.IMetricComputation;
import com.teamscale.index.metrics.assessment.computation.NumericMetricComputation;
import com.teamscale.index.metrics.assessment.computation.UnassessedMetricComputation;
import java.io.Serializable;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public abstract class MetricComputationBase<T>
implements IMetricComputation<T> {
    private MetricDirectorySchemaEntry schemaEntry;

    public MetricComputationBase(MetricDirectorySchemaEntry schemaEntry) {
        this.schemaEntry = schemaEntry;
    }

    protected abstract ETrend execComputeTrend(EvaluatedMetricThreshold var1, T var2, T var3);

    public static IMetricComputation<?> createInstance(IMetricValue<? extends Serializable> metricValue) {
        return MetricComputationBase.createInstance(metricValue.getSchemaEntry());
    }

    public static IMetricComputation<?> createInstance(MetricDirectorySchemaEntry schemaEntry) {
        return switch (schemaEntry.getValueType()) {
            case EMetricValueType.NUMERIC -> new NumericMetricComputation(schemaEntry);
            case EMetricValueType.ASSESSMENT -> new AssessmentMetricComputation(schemaEntry);
            default -> new UnassessedMetricComputation();
        };
    }

    public MetricDirectorySchemaEntry getSchemaEntry() {
        return this.schemaEntry;
    }

    public boolean isEvaluationOptionSet(MetricThresholdBase threshold, EThresholdEvaluationOption evaluationOption) {
        return threshold.getEvaluationOptions().contains(evaluationOption);
    }

    @Override
    public final ETrend computeTrend(EvaluatedMetricThreshold threshold, Object currentValue, @Nullable Object baselineValue) {
        if (baselineValue == null) {
            return ETrend.NA;
        }
        return this.execComputeTrend(threshold, currentValue, baselineValue);
    }

    @Override
    public final TrendDelta computeTrendDelta(Object currentValue, @Nullable Object baselineValue) {
        if (baselineValue == null) {
            return TrendDelta.EMPTY;
        }
        return this.execComputeTrendDelta(currentValue, baselineValue);
    }

    protected abstract TrendDelta execComputeTrendDelta(T var1, T var2);

    @Override
    public final ETrafficLightColor computeMetricRating(EvaluatedMetricThreshold threshold, Object value) {
        if (!threshold.isAnyThresholdSet()) {
            return ETrafficLightColor.UNKNOWN;
        }
        MetricValueBase wrappedMetricValue = MetricValueBase.createWithRawValue((MetricDirectorySchemaEntry)this.schemaEntry, (Object)value);
        return this.execComputeMetricRating(threshold, (IMetricValue<?>)wrappedMetricValue);
    }

    protected abstract ETrafficLightColor execComputeMetricRating(EvaluatedMetricThreshold var1, IMetricValue<?> var2);

    protected boolean isLowIsBad(EvaluatedMetricThreshold threshold) {
        return threshold.getAssessmentSpecification().isLowIsBad(this.getSchemaEntry());
    }

    protected ETrafficLightColor getRatingColor(EvaluatedMetricThreshold threshold, double valueForComparisonWithYellowThreshold, double valueForComparisonWithRedThreshold) {
        Double thresholdYellow = threshold.getThresholdYellow();
        Double thresholdRed = threshold.getThresholdRed();
        EAssessmentSpecification assessmentSpecification = threshold.getAssessmentSpecification();
        BiFunction exceedsThresholdFunction = assessmentSpecification.createExceedsThresholdFunction(this.schemaEntry);
        if (thresholdRed != null && ((Boolean)exceedsThresholdFunction.apply(thresholdRed, valueForComparisonWithRedThreshold)).booleanValue()) {
            return ETrafficLightColor.RED;
        }
        if (thresholdYellow != null && ((Boolean)exceedsThresholdFunction.apply(thresholdYellow, valueForComparisonWithYellowThreshold)).booleanValue()) {
            return ETrafficLightColor.YELLOW;
        }
        return ETrafficLightColor.GREEN;
    }
}

