/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.option.PairListOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.StringValuePairListOptionDescriptor;
import com.teamscale.core.migration.IJsonMigrator;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class ReportFormatDeletion
implements IJsonMigrator {
    private static final String ANALYSIS_REPORT_MAPPING_OPTION = "Analysis report mapping";
    private final String reportFormat;

    public ReportFormatDeletion(String format) {
        this.reportFormat = format;
    }

    public @NonNull String migrate(String json) throws MigrationException {
        try {
            ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
            for (ConnectorConfiguration connector : holder.connectors) {
                this.migrateAnalysisReportMapping(connector);
            }
            return JsonUtils.serializeToJSON((Object)holder);
        }
        catch (ProjectConfigurationException | JsonSerializationException e) {
            throw new MigrationException(e);
        }
    }

    private void migrateAnalysisReportMapping(ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException {
        String optionValue = connectorConfiguration.getOptionValue(ANALYSIS_REPORT_MAPPING_OPTION);
        if (StringUtils.isEmpty((String)optionValue)) {
            return;
        }
        PairList pairs = StringValuePairListOptionDescriptor.parseFromString((String)optionValue);
        for (int i = 0; i < pairs.size(); ++i) {
            String format = (String)pairs.getSecond(i);
            if (!this.reportFormat.equals(format)) continue;
            pairs.remove(i);
            --i;
        }
        connectorConfiguration.setOptionValue(ANALYSIS_REPORT_MAPPING_OPTION, PairListOptionDescriptorBase.getValueAsString((Object)pairs));
    }
}

