/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.project;

import com.teamscale.index.notifications.ENotificationThresholdViolationResult;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationMailHelperBase;
import com.teamscale.index.notifications.NotificationThresholdViolationInfo;
import com.teamscale.index.notifications.project.ProjectNotificationRule;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;

public class ProjectNotificationMailHelper
extends NotificationMailHelperBase {
    private final ProjectNotificationRule notificationRule;
    private NotificationThresholdViolationInfo info;

    public ProjectNotificationMailHelper(NotificationContext notificationContext, ProjectNotificationRule notificationRule, NotificationThresholdViolationInfo info) throws StorageException {
        super(notificationContext);
        this.notificationRule = notificationRule;
        this.info = info;
    }

    public String buildSubject() {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        writer.addText(this.notificationRule.getRuleName());
        writer.addText(" matched for commit ");
        writer.addText(this.notificationContext.getRepositoryLogEntry().getRevision());
        writer.addText(" in project '" + this.getProjectReadableName() + "'");
        if (this.didCommitResolveViolation()) {
            writer.addText(" (Resolved)");
        }
        writer.close();
        return stringWriter.toString();
    }

    public String buildContent() {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        this.appendMailContent(writer);
        writer.close();
        return stringWriter.toString();
    }

    private void appendMailContent(HTMLWriter writer) {
        boolean resolvedViolation = this.didCommitResolveViolation();
        Object title = "Metric Threshold Violation";
        if (resolvedViolation) {
            title = (String)title + " Resolved";
        }
        writer.addClosedTextElement((Enum)EHTMLElement.H3, (String)title, new Object[0]);
        writer.addText("This notification was triggered by rule ");
        writer.addText("'" + this.notificationRule.getRuleName() + "'");
        writer.addText(" for commit ");
        String revision = this.notificationContext.getRepositoryLogEntry().getRevision();
        ProjectNotificationMailHelper.appendLink(writer, this.revisionLink, revision);
        writer.addText(":");
        this.appendCommitInformationBody(writer);
        writer.addClosedElement((Enum)EHTMLElement.BR, new Object[0]);
        this.appendInformationContentText(writer, resolvedViolation);
        writer.addClosedElement((Enum)EHTMLElement.BR, new Object[0]);
        writer.addClosedElement((Enum)EHTMLElement.BR, new Object[0]);
        this.appendViewCommitInTeamscaleText(writer);
    }

    private boolean didCommitResolveViolation() {
        return this.info.getResult() == ENotificationThresholdViolationResult.RESOLVED_VIOLATION;
    }

    private void appendInformationContentText(HTMLWriter writer, boolean resolvedViolation) {
        writer.addText("We want to inform you that the value of metric ");
        writer.addText("'" + this.notificationRule.getMetricDisplayName() + "'");
        Double oldValue = this.info.getPreviousValue();
        if (oldValue != null) {
            writer.addText(" changed from ");
            writer.addClosedTextElement((Enum)EHTMLElement.B, oldValue.toString(), new Object[0]);
            writer.addText(" to ");
        } else {
            writer.addText(" is now ");
        }
        writer.addClosedTextElement((Enum)EHTMLElement.B, this.info.getCurrentValue().toString(), new Object[0]);
        writer.addText(".");
        writer.addClosedElement((Enum)EHTMLElement.BR, new Object[0]);
        if (resolvedViolation) {
            this.appendResolvedContentText(writer);
        } else {
            this.appendViolationContentText(writer);
        }
    }

    private void appendViolationContentText(HTMLWriter writer) {
        writer.addText("This violates the configured threshold of ");
        writer.addClosedTextElement((Enum)EHTMLElement.B, this.info.getCurrentThreshold().toString(), new Object[0]);
        writer.addText(".");
    }

    private void appendResolvedContentText(HTMLWriter writer) {
        writer.addText("This resolves a previously existing threshold violation. ");
        writer.addText("The current threshold is ");
        writer.addClosedTextElement((Enum)EHTMLElement.B, this.info.getCurrentThreshold().toString(), new Object[0]);
        writer.addText(".");
    }
}

