/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import java.io.Serializable;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class SelfContainedFinding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ID_PROPERTY = "id";
    private static final String ANALYSIS_TIMESTAMP_PROPERTY = "analysisTimestamp";
    private static final String BIRTH_COMMIT_PROPERTY = "birthCommit";
    private static final String DEATH_PROPERTY = "death";
    public static final String CONTENT_PROPERTY = "content";
    private static final String LOCATION_PROPERTY = "location";
    private static final String MESSAGE_PROPERTY = "message";
    private static final String ASSESSMENT_PROPERTY = "assessment";
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="analysisTimestamp")
    private final long analysisTimestamp;
    @JsonProperty(value="birthCommit")
    private final CommitDescriptor birthCommit;
    @JsonProperty(value="death")
    private final @Nullable CommitDescriptor death;
    @JsonProperty(value="content")
    private final FindingContent content;
    @JsonProperty(value="location")
    private final FindingLocation location;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="assessment")
    private final @Nullable ETrafficLightColor assessment;

    @JsonCreator
    private SelfContainedFinding(@JsonProperty(value="id") String id, @JsonProperty(value="analysisTimestamp") long analysisTimestamp, @JsonProperty(value="birthCommit") CommitDescriptor birthCommit, @JsonProperty(value="death") CommitDescriptor deathCommit, @JsonProperty(value="content") FindingContent content, @JsonProperty(value="location") FindingLocation location, @JsonProperty(value="message") String message, @JsonProperty(value="assessment") ETrafficLightColor assessment) {
        this.id = id;
        this.analysisTimestamp = analysisTimestamp;
        this.birthCommit = birthCommit;
        this.death = deathCommit;
        this.content = content;
        this.location = location;
        this.message = message;
        this.assessment = assessment;
    }

    public Integer getRawStartLine() {
        return this.location.rawStartLine;
    }

    public Integer getRawEndLine() {
        return this.location.rawEndLine;
    }

    public static SelfContainedFinding from(TrackedFinding finding, FormattedTokenElementInfo elementInfo) {
        FindingContent content = new FindingContent(elementInfo);
        FindingLocation location = FindingLocation.forElementLocation(finding.getLocation());
        return new SelfContainedFinding(finding.getId(), finding.getAnalysisTimestamp(), finding.getBirthCommit(), finding.getDeathCommit(), content, location, finding.getMessage(), finding.getAssessment());
    }

    @IndexValueClass(containedInBackup=true)
    public static class FindingContent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String LANGUAGE_PROPERTY = "language";
        private static final String TEXT_PROPERTY = "text";
        private static final String TOKENS_PROPERTY = "tokens";
        private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
        private static final String STYLES_PROPERTY = "styles";
        @JsonProperty(value="language")
        private final String language;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="tokens")
        private final List<Integer> tokens;
        @JsonProperty(value="uniformPath")
        private final String uniformPath;
        @JsonProperty(value="styles")
        private final List<FormattedTokenElementInfo.TokenStyle> styles;

        @JsonCreator
        private FindingContent(@JsonProperty(value="language") String language, @JsonProperty(value="text") String text, @JsonProperty(value="tokens") List<Integer> tokens, @JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="styles") List<FormattedTokenElementInfo.TokenStyle> styles) {
            this.language = language;
            this.text = text;
            this.tokens = tokens;
            this.uniformPath = uniformPath;
            this.styles = styles;
        }

        public FindingContent(FormattedTokenElementInfo elementInfo) {
            this(elementInfo.getLanguage().name(), elementInfo.getText(), (List<Integer>)elementInfo.getTokenStyleIndices(), elementInfo.getUniformPath(), elementInfo.getStyles());
        }

        public String getText() {
            return this.text;
        }
    }

    @IndexValueClass(containedInBackup=true)
    private static class FindingLocation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
        private static final String RAW_START_LINE_PROPERTY = "rawStartLine";
        private static final String RAW_END_LINE_PROPERTY = "rawEndLine";
        @JsonProperty(value="uniformPath")
        private final String uniformPath;
        @JsonProperty(value="rawStartLine")
        private final @Nullable Integer rawStartLine;
        @JsonProperty(value="rawEndLine")
        private final @Nullable Integer rawEndLine;

        @JsonCreator
        private FindingLocation(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="rawStartLine") @Nullable Integer rawStartLine, @JsonProperty(value="rawEndLine") @Nullable Integer rawEndLine) {
            this.uniformPath = uniformPath;
            this.rawStartLine = rawStartLine;
            this.rawEndLine = rawEndLine;
        }

        private static FindingLocation forElementLocation(ElementLocation location) {
            Integer rawStartLine = null;
            Integer rawEndLine = null;
            if (location instanceof TextRegionLocation) {
                rawStartLine = ((TextRegionLocation)location).getRawStartLine();
                rawEndLine = ((TextRegionLocation)location).getRawEndLine();
            }
            return new FindingLocation(location.getUniformPath(), rawStartLine, rawEndLine);
        }
    }
}

