/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.report.AnalysisReportIntegratorBase;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.report.parser.IUsageDataProvider;
import com.teamscale.index.resource.ReportContentIndexBase;
import com.teamscale.index.resource.SapScovReportContentIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.usage.MethodUsageCountIndex;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;

public class UsageDataReportIntegrator
extends AnalysisReportIntegratorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SapScovReportContentIndex sapScovReportContentIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private SapScovReportContentIndex previousSapScovReportContentIndex;
    @DeltaSource(value=SapScovReportContentIndex.class)
    private KeyDelta sapScovReportContentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodUsageCountIndex usageCountIndex;

    @Override
    public void executeReportIntegration() throws StorageException {
        List changedPaths = this.sapScovReportContentDelta.getAddedOrChangedKeysAsStrings();
        List<ReportContentIndexBase.ReportContent> contents = this.sapScovReportContentIndex.getReportContents(changedPaths);
        List<ReportContentIndexBase.ReportContent> oldReportContents = this.previousSapScovReportContentIndex.getReportContents(changedPaths);
        TokenElementIndexCache tokenElementIndexCache = new TokenElementIndexCache(this.tokenElementIndex, Collections.emptyList());
        for (int i = 0; i < changedPaths.size(); ++i) {
            this.parseReport((String)changedPaths.get(i), contents.get(i), oldReportContents.get(i), tokenElementIndexCache);
        }
    }

    private void parseReport(String reportPath, ReportContentIndexBase.ReportContent reportContent, ReportContentIndexBase.ReportContent oldReportContent, TokenElementIndexCache tokenElementIndexCache) throws StorageException {
        IReportParser parser = this.createAndInitParser(reportContent, tokenElementIndexCache, false);
        try {
            parser.parse(reportContent, reportPath);
            this.integrateUsageData(reportPath, (IUsageDataProvider)CCSMAssert.checkedCast((Object)parser, IUsageDataProvider.class), oldReportContent);
        }
        catch (ReportParserException e) {
            LOGGER.error("Failed parsing " + reportPath + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void integrateUsageData(String reportPath, IUsageDataProvider parser, ReportContentIndexBase.ReportContent oldReportContent) throws StorageException {
        try {
            PairList<MethodLocation, Long> locationAndDeltas = parser.extractUsageDataDelta(Optional.ofNullable(oldReportContent).map(ReportContentIndexBase.ReportContent::getContentAsString).orElse(null));
            this.usageCountIndex.addUsageCountDeltas(locationAndDeltas);
        }
        catch (ReportParserException e) {
            LOGGER.error("Failed parsing old report when persisting usage data for " + reportPath + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

