/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.bullseye;

import com.google.common.collect.Lists;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.coverage.CoverageReportParserInvokerBase;
import com.teamscale.index.report.coverage.bullseye.BullseyeCFGStrategy;
import com.teamscale.index.report.coverage.bullseye.BullseyeReportHandler;
import com.teamscale.index.report.coverage.bullseye.BullseyeSimpleHeuristicStrategy;
import com.teamscale.index.report.coverage.bullseye.BullseyeStrategyBase;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.reportparser.parser.ReportParserException;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BullseyeReportParser
extends CoverageReportParserInvokerBase {
    private static final int BATCH_SIZE = 500;
    private BullseyeReportHandler reportHandler;
    private CoverageInfoRetriever lineCoverageInfoRetriever;

    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever lineCoverageInfoRetriever) throws ReportParserException {
        try {
            this.lineCoverageInfoRetriever = lineCoverageInfoRetriever;
            this.reportHandler = new BullseyeReportHandler();
            XMLUtils.parseSAX((InputSource)XMLUtils.toInputSource((String)report), (DefaultHandler)this.reportHandler);
        }
        catch (SAXException e) {
            throw new ReportParserException("Error parsing Bullseye report. Please check if report is a valid Bullseye XML report. Beginning of uploaded report: '" + StringUtils.truncateWithEllipsis((String)report, (int)200) + "' Error: " + String.valueOf(e), (Throwable)e);
        }
        catch (IOException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    @Override
    protected ExternalAnalysisImportInfos convertToImportInfos() throws StorageException {
        if (this.reportHandler == null) {
            throw new IllegalStateException("Must parse report first");
        }
        if (EFeatureToggle.DISABLE_BULLSEYE_CONTROL_FLOW_PARSING.isEnabled()) {
            this.importCoverageUsingSimpleHeuristic();
        } else {
            this.importCoverageUsingCfgAnalysis();
        }
        return super.convertToImportInfos();
    }

    private void importCoverage(BullseyeStrategyBase strategy) throws ConQATException {
        ArrayList<String> resolvedFileNames = new ArrayList<String>();
        ArrayList<String> uniformPaths = new ArrayList<String>();
        for (String fileName : this.reportHandler.getFiles()) {
            Optional<String> optionalResolvedPath = this.resolvePath(fileName);
            if (optionalResolvedPath.isEmpty()) continue;
            resolvedFileNames.add(fileName);
            uniformPaths.add(optionalResolvedPath.get());
        }
        List fileNamePartitions = Lists.partition(resolvedFileNames, (int)500);
        List uniformPathPartitions = Lists.partition(uniformPaths, (int)500);
        for (int i = 0; i < fileNamePartitions.size(); ++i) {
            List currentFileNames = (List)fileNamePartitions.get(i);
            List currentUniformPaths = (List)uniformPathPartitions.get(i);
            this.importCoverageFileBatch(strategy, currentFileNames, currentUniformPaths);
        }
    }

    private void importCoverageFileBatch(BullseyeStrategyBase strategy, List<String> fileNames, List<String> uniformPaths) throws ConQATException {
        List<TokenElementInfo> tokenElementInfos = this.tokenElementIndexCache.getValues(uniformPaths);
        List<TokenElementLineInfo> tokenElementLineInfos = this.tokenElementLineInfoIndex.getLineInfos(uniformPaths);
        for (int j = 0; j < fileNames.size(); ++j) {
            String fileName = fileNames.get(j);
            String uniformPath = uniformPaths.get(j);
            TokenElementInfo tokenElementInfo = tokenElementInfos.get(j);
            TokenElementLineInfo tokenElementLineInfo = tokenElementLineInfos.get(j);
            if (tokenElementInfo == null || tokenElementLineInfo == null) continue;
            if (!LanguageGroups.C_AND_DERIVATIVES.contains(tokenElementInfo.getLanguage())) {
                LOGGER.warn("Failed to import coverage for file {}. Because file has no C-derivative language. Language is {}.", (Object)fileName, (Object)tokenElementInfo.getLanguage().getReadableName());
                continue;
            }
            try {
                strategy.importCoverage(fileName, uniformPath, tokenElementInfo, tokenElementLineInfo);
                continue;
            }
            catch (ConQATException exception) {
                throw new ConQATException(String.format("Failed to import coverage for file '%s'.", fileName), (Throwable)exception);
            }
        }
    }

    private void importCoverageUsingCfgAnalysis() {
        BullseyeCFGStrategy parser = new BullseyeCFGStrategy(this.reportHandler, this.lineCoverageInfoRetriever);
        try {
            this.importCoverage(parser);
        }
        catch (ConQATException e) {
            LOGGER.error("Could not retrieve coverage information using control flow analysis.", (Throwable)e);
        }
    }

    private void importCoverageUsingSimpleHeuristic() throws StorageException {
        BullseyeSimpleHeuristicStrategy parser = new BullseyeSimpleHeuristicStrategy(this.reportHandler, this.lineCoverageInfoRetriever);
        try {
            this.importCoverage(parser);
        }
        catch (ConQATException e) {
            LOGGER.error("Could not retrieve coverage information using simple heuristic.", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }
}

