/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.bullseye;

import com.teamscale.index.report.coverage.bullseye.BullseyeReportHandler;
import com.teamscale.index.report.coverage.bullseye.BullseyeStrategyBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class BullseyeSimpleHeuristicStrategy
extends BullseyeStrategyBase {
    public BullseyeSimpleHeuristicStrategy(BullseyeReportHandler reportHandler, CoverageInfoRetriever lineCoverageInfoRetriever) {
        super(reportHandler, lineCoverageInfoRetriever);
    }

    @Override
    protected void importCoverage(String fileName, String uniformPath, TokenElementInfo tokenElementInfo, TokenElementLineInfo tokenElementLineInfo) {
        UnmodifiableList<ShallowEntity> inputEntities = tokenElementInfo.getShallowEntitiesWithoutPreprocessorTokens();
        this.importCoverageForEntities(fileName, uniformPath, (List<ShallowEntity>)inputEntities);
    }

    public void importCoverageForEntities(String fileName, String uniformPath, List<ShallowEntity> inputEntities) {
        List<ShallowEntity> selectedEntities = BullseyeSimpleHeuristicStrategy.selectEntities(inputEntities);
        for (ShallowEntity entity : selectedEntities) {
            this.processEntity(uniformPath, fileName, entity);
        }
    }

    private void processEntity(String uniformPath, String file, ShallowEntity entity) {
        BullseyeReportHandler.Probe probe = this.reportHandler.getProbe(file, entity);
        if (probe == null) {
            this.processEntityWithoutOwnProbe(uniformPath, file, entity);
        } else {
            this.processWithOwnProbe(uniformPath, entity, probe);
        }
    }

    private static ELineCoverage getLineCoverageForDecision(BullseyeReportHandler.Probe decisionProbe) {
        CCSMAssert.isTrue((decisionProbe.getProbeKind() == BullseyeReportHandler.EProbeKind.DECISION || decisionProbe.getProbeKind() == BullseyeReportHandler.EProbeKind.SWITCH_LABEL ? 1 : 0) != 0, (String)"Expected to operate DECISION probes.");
        return switch (decisionProbe.getProbeEvent()) {
            case BullseyeReportHandler.EProbeEvent.FULL, BullseyeReportHandler.EProbeEvent.TRUE -> ELineCoverage.FULLY_COVERED;
            default -> ELineCoverage.NOT_COVERED;
        };
    }

    private static ELineCoverage getLineCoverageForElse(BullseyeReportHandler.Probe ifProbe) {
        return switch (ifProbe.getProbeEvent()) {
            case BullseyeReportHandler.EProbeEvent.FULL, BullseyeReportHandler.EProbeEvent.FALSE -> ELineCoverage.FULLY_COVERED;
            default -> ELineCoverage.NOT_COVERED;
        };
    }

    private void processEntityWithoutOwnProbe(String uniformPath, String file, ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return;
        }
        BullseyeReportHandler.Probe probe = this.reportHandler.getProbe(file, parent);
        LineCoverageInfo lineCoverageInfo = this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(uniformPath);
        if (probe != null) {
            if (probe.getProbeKind() == BullseyeReportHandler.EProbeKind.FUNCTION) {
                BullseyeSimpleHeuristicStrategy.addLineCoverage(lineCoverageInfo, entity, BullseyeSimpleHeuristicStrategy.getLineCoverageForCoverable(probe));
            } else if (probe.getProbeKind() == BullseyeReportHandler.EProbeKind.DECISION) {
                BullseyeSimpleHeuristicStrategy.addLineCoverage(lineCoverageInfo, entity, BullseyeSimpleHeuristicStrategy.getLineCoverageForDecision(probe));
            }
        } else if (parent.getSubtype().equals("else")) {
            ShallowEntity ifEntity = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)parent);
            if (ifEntity == null) {
                LOGGER.error("No predecessor found for else statement. Ignoring entity. " + String.valueOf(parent) + " in file " + uniformPath);
                return;
            }
            probe = this.reportHandler.getProbe(file, ifEntity);
            if (probe != null) {
                BullseyeSimpleHeuristicStrategy.addLineCoverage(lineCoverageInfo, entity, BullseyeSimpleHeuristicStrategy.getLineCoverageForElse(probe));
            }
        } else if (parent.getSubtype().equals("switch") || parent.getParent() != null && parent.getParent().getSubtype().equals("switch") && parent.getSubtype().equals("anonymous block")) {
            this.processSwitchChildEntity(file, uniformPath, entity);
        }
    }

    private void processSwitchChildEntity(String file, String uniformPath, ShallowEntity entity) {
        Optional<ShallowEntity> switchLabelEntity = BullseyeSimpleHeuristicStrategy.findPreviousSwitchLabelEntity(entity);
        if (switchLabelEntity.isEmpty()) {
            LOGGER.error("No switch label found for the current entity. Ignoring entity. " + String.valueOf(entity) + " in file " + uniformPath);
            return;
        }
        BullseyeReportHandler.Probe probe = this.reportHandler.getProbe(file, switchLabelEntity.get());
        if (probe != null) {
            BullseyeSimpleHeuristicStrategy.addLineCoverage(this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(uniformPath), entity, BullseyeSimpleHeuristicStrategy.getLineCoverageForDecision(probe));
        }
    }

    private static Optional<ShallowEntity> findPreviousSwitchLabelEntity(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent != null) {
            if (parent.getSubtype().equals("switch")) {
                return ShallowEntityTraversalUtils.getPreviousEntityWithSubtype((ShallowEntity)entity, (String[])new String[]{"case", "default"});
            }
            if (parent.getSubtype().equals("anonymous block") && parent.getParent() != null && parent.getParent().getSubtype().equals("switch")) {
                return ShallowEntityTraversalUtils.getPreviousEntityWithSubtype((ShallowEntity)parent, (String[])new String[]{"case", "default"});
            }
        }
        return Optional.empty();
    }

    private void processWithOwnProbe(String uniformPath, ShallowEntity entity, BullseyeReportHandler.Probe probe) {
        LineCoverageInfo lineCoverageInfo = this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(uniformPath);
        if (probe.getProbeKind() == BullseyeReportHandler.EProbeKind.DECISION) {
            switch (probe.getProbeEvent()) {
                case FULL: {
                    BullseyeSimpleHeuristicStrategy.addLineCoverage(lineCoverageInfo, entity, ELineCoverage.FULLY_COVERED);
                    break;
                }
                case NONE: {
                    BullseyeSimpleHeuristicStrategy.addLineCoverage(lineCoverageInfo, entity, ELineCoverage.NOT_COVERED);
                    break;
                }
                default: {
                    BullseyeSimpleHeuristicStrategy.addLineCoverage(lineCoverageInfo, entity, ELineCoverage.PARTIALLY_COVERED);
                    break;
                }
            }
        } else if (probe.getProbeKind() == BullseyeReportHandler.EProbeKind.FUNCTION) {
            BullseyeSimpleHeuristicStrategy.addLineCoverage(lineCoverageInfo, entity, BullseyeSimpleHeuristicStrategy.getLineCoverageForCoverable(probe));
        }
    }
}

