/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.bullseye;

import com.teamscale.index.report.coverage.bullseye.BullseyeReportHandler;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.engine.sourcecode.coverage.volume.CoverableLineUtils;

public abstract class BullseyeStrategyBase {
    private static final EnumSet<EShallowEntityType> SELECTED_ENTITY_TYPES = EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.METHOD);
    private static final Set<String> SELECTED_META_SUBTYPES = Set.of("case", "default", "label");
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final BullseyeReportHandler reportHandler;
    protected final CoverageInfoRetriever lineCoverageInfoRetriever;

    protected BullseyeStrategyBase(BullseyeReportHandler reportHandler, CoverageInfoRetriever lineCoverageInfoRetriever) {
        this.reportHandler = reportHandler;
        this.lineCoverageInfoRetriever = lineCoverageInfoRetriever;
    }

    abstract void importCoverage(String var1, String var2, TokenElementInfo var3, TokenElementLineInfo var4) throws ConQATException;

    static List<ShallowEntity> selectEntities(List<ShallowEntity> inputEntities) {
        return ShallowEntityTraversalUtils.selectEntities(inputEntities, entity -> SELECTED_ENTITY_TYPES.contains(entity.getType()) || entity.getType() == EShallowEntityType.META && SELECTED_META_SUBTYPES.contains(entity.getSubtype()));
    }

    static void addLineCoverage(LineCoverageInfo lineCoverageInfo, @NonNull ShallowEntity entity, ELineCoverage coverage) {
        Iterator iterator = CoverableLineUtils.determineLinesFromEntities((ELanguage)ELanguage.CPP, Collections.singleton(entity)).iterator();
        while (iterator.hasNext()) {
            int line = (Integer)iterator.next();
            lineCoverageInfo.addLineCoverage(line, coverage);
        }
    }

    static ELineCoverage getLineCoverageForCoverable(BullseyeReportHandler.Probe binaryProbe) {
        return switch (binaryProbe.getProbeEvent()) {
            default -> throw new MatchException(null, null);
            case BullseyeReportHandler.EProbeEvent.TRUE -> ELineCoverage.PARTIALLY_COVERED;
            case BullseyeReportHandler.EProbeEvent.FULL -> ELineCoverage.FULLY_COVERED;
            case BullseyeReportHandler.EProbeEvent.FALSE, BullseyeReportHandler.EProbeEvent.NONE -> ELineCoverage.NOT_COVERED;
        };
    }
}

