/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.report.parser.PlistHandler;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ClangReportParser
extends FindingCollectingReportParserBase {
    static final Set<String> KNOWN_CATEGORIES = new HashSet<String>(Arrays.asList("ARC Restrictions", "API Misuse (Apple)", "API", "Dead store", "Logic error", "Memory (Core Foundation/Objective-C)", "Memory error", "Unix API"));
    static final Map<String, String> CATEGORY_REPLACEMENTS = Map.of("Memory Error", "Memory error");
    static final String OTHER_CATEGORY_NAME = "Other";
    private List<ClangFinding> clangFindings;

    @Override
    protected void resetState() {
        super.resetState();
        this.clangFindings = new ArrayList<ClangFinding>();
    }

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            XMLUtils.parseSAX((InputSource)XMLUtils.toInputSource((String)report), (DefaultHandler)new PlistHandler(this::createClangFinding, this.tokenElementLineInfoIndex, this.matchingPathsLookup));
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    public static List<String> getClangCategoryNames() {
        ArrayList categories = CollectionUtils.sort(KNOWN_CATEGORIES);
        categories.add(OTHER_CATEGORY_NAME);
        return categories;
    }

    private void createClangFinding(String ruleId, String message, String locationInReport, int lineNumber, ArrayList<StatementPathElement> statementPath) {
        this.clangFindings.add(new ClangFinding(ruleId, message, locationInReport, lineNumber, statementPath));
    }

    @Override
    protected void collectFindings() throws StorageException {
        for (ClangFinding clangFinding : this.clangFindings) {
            Optional<String> uniformPath = this.resolvePath(clangFinding.getLocationInReport());
            if (!uniformPath.isPresent()) continue;
            for (StatementPathElement element : clangFinding.statementPath) {
                TextRegionLocation location = (TextRegionLocation)element.getLocation();
                Optional<String> statementUniformPath = this.resolvePath(location.getUniformPath());
                if (!statementUniformPath.isPresent()) continue;
                element.setLocation((ElementLocation)new TextRegionLocation(statementUniformPath.get(), location.getRawStartOffset(), location.getRawEndOffset(), location.getRawStartLine(), location.getRawEndLine()));
            }
            int lineNumber = clangFinding.getLineNumber();
            TextRegionLocation location = new TextRegionLocation(uniformPath.get(), -1, -1, lineNumber, lineNumber);
            String message = MarkupUtils.escapeMarkdownRelevantSymbols((String)clangFinding.getMessage());
            DetachedFinding finding = new DetachedFinding(clangFinding.getRuleId(), "Clang", message, (ElementLocation)location);
            finding.setStatementPath(clangFinding.statementPath);
            this.addFindingForPath(uniformPath.get(), finding);
        }
    }

    private static class ClangFinding {
        private final String ruleId;
        private final String message;
        private final String locationInReport;
        private final int lineNumber;
        private final ArrayList<StatementPathElement> statementPath;

        private ClangFinding(String ruleId, String message, String locationInReport, int lineNumber, ArrayList<StatementPathElement> statementPath) {
            this.ruleId = ruleId;
            this.message = message;
            this.locationInReport = locationInReport;
            this.lineNumber = lineNumber;
            this.statementPath = statementPath;
        }

        private String getRuleId() {
            return this.ruleId;
        }

        private String getMessage() {
            return this.message;
        }

        private String getLocationInReport() {
            return this.locationInReport;
        }

        private int getLineNumber() {
            return this.lineNumber;
        }
    }
}

