/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionedIndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.engine.sourcecode.coverage.MultiFileRangeCoverageInfo;
import org.conqat.lib.commons.collections.PairList;

@Index(name="coverage-unit-temp", options={EStorageOption.VIRTUAL})
public class CoverageUnitTempIndex
extends PartitionedIndexBase<MultiFileRangeCoverageInfo>
implements IProjectIndex {
    protected static final String NAME = "coverage-unit-temp";

    public CoverageUnitTempIndex(IStore store) {
        super(store, true);
    }

    public void setPartitions(Set<String> partitions) throws StorageException {
        this.store.putWithString("#-#partition-list#-#", StorageUtils.serialize(new ArrayList<String>(partitions)));
    }

    public void addCoverage(String partition, PairList<String, MultiFileRangeCoverageInfo> multiFileRangeCoverageInfos) throws StorageException {
        PairList keysValues = new PairList();
        for (int i = 0; i < multiFileRangeCoverageInfos.size(); ++i) {
            String key = CoverageUnitTempIndex.makeKey((String)partition, (String)((String)multiFileRangeCoverageInfos.getFirst(i)));
            byte[] value = StorageUtils.serialize((Serializable)((Serializable)multiFileRangeCoverageInfos.getSecond(i)));
            keysValues.add((Object)key, (Object)value);
        }
        this.store.putWithStrings(keysValues);
    }

    public List<MultiFileRangeCoverageInfo> getCoverage(List<PartitionAndPath> partitionAndPaths) throws StorageException {
        return this.getValues(partitionAndPaths);
    }
}

