/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.FindingsDeletionFilterUtils;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.index.external.result.ExternalAnalysisResultFindings;
import com.teamscale.index.findings.IntegratedToolUtils;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ExternalAnalysisResultFindingsProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultFindings> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CODE_INSPECTOR_TYPE_ID_PREFIX = "Code Inspector/";
    public static final String EXTERNAL_FINDINGS_PARTITION_PREFIX = "external:";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex findingsSchemaIndex;
    @IndexAccess(indexName="basic-token-elements", value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex contentIndex;
    private final Map<String, ListMap<String, IndexFinding>> findingsWithPartition = new HashMap<String, ListMap<String, IndexFinding>>();
    private final Map<String, ArrayList<IndexFinding>> explicitlyDeletedReviewFindings = new HashMap<String, ArrayList<IndexFinding>>();

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isCodePath();
    }

    @Override
    public Class<ExternalAnalysisResultFindings> getResultClass() {
        return ExternalAnalysisResultFindings.class;
    }

    public static boolean isReviewFindingPartition(String partition) {
        return "code-review-findings".equals(partition);
    }

    @Override
    public boolean isPartOfPartialReport(String partition, ExternalAnalysisResultFindings result) {
        return ExternalAnalysisResultFindingsProcessor.isReviewFindingPartition(partition);
    }

    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultFindings analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        List filteredFindings = FindingsDeletionFilterUtils.filterFindings((List)analysisResult.getData(), (List)element.getFilterDeletions(), (int)element.getText().length());
        this.findingsWithPartition.computeIfAbsent(ExternalAnalysisResultFindingsProcessor.makeExternalFindingsPartition(partition), x -> new ListMap()).addAll((Object)uniformPath.toString(), ExternalAnalysisResultFindingsProcessor.fixFinding(uniformPath.toString(), new ArrayList<IndexFinding>(filteredFindings), resultsCommit));
        this.explicitlyDeletedReviewFindings.computeIfAbsent(uniformPath.toString(), x -> new ArrayList()).addAll(analysisResult.getDeletedFindings());
        return true;
    }

    private static boolean containsEqualReviewFinding(List<IndexFinding> findings, IndexFinding referenceFinding) {
        return findings.stream().anyMatch(f -> ExternalAnalysisResultFindingsProcessor.areReviewFindingsEquals((DetachedFinding)f, (DetachedFinding)referenceFinding));
    }

    private static boolean areReviewFindingsEquals(DetachedFinding finding1, DetachedFinding finding2) {
        return finding1.getMessage().equals(finding2.getMessage()) && finding1.getLocationString().equals(finding2.getLocationString());
    }

    public static String makeExternalFindingsPartition(String partition) {
        return EXTERNAL_FINDINGS_PARTITION_PREFIX + partition;
    }

    private static ArrayList<IndexFinding> fixFinding(String uniformPath, ArrayList<IndexFinding> findings, CommitDescriptor commit) {
        for (IndexFinding finding : findings) {
            if (!uniformPath.equals(finding.getLocation().getUniformPath())) {
                finding.setLocation(ExternalAnalysisResultFindingsProcessor.fixFindingLocation(finding.getLocation(), uniformPath));
            }
            finding.setAnalysisTimestamp(commit.getTimestamp());
            ExternalAnalysisResultFindingsProcessor.addCodeInspectorRuleId(finding);
        }
        return findings;
    }

    private static ElementLocation fixFindingLocation(ElementLocation location, String adjustedUniformPath) {
        if (location instanceof TextRegionLocation) {
            TextRegionLocation textRegionLocation = (TextRegionLocation)location;
            return new TextRegionLocation(adjustedUniformPath, textRegionLocation.getRawStartOffset(), textRegionLocation.getRawEndOffset(), textRegionLocation.getRawStartLine(), textRegionLocation.getRawEndLine());
        }
        if (location instanceof QualifiedNameLocation) {
            return new QualifiedNameLocation(((QualifiedNameLocation)location).getQualifiedName(), adjustedUniformPath);
        }
        return new ElementLocation(adjustedUniformPath);
    }

    private static void addCodeInspectorRuleId(IndexFinding finding) {
        if (!finding.getTypeId().startsWith(CODE_INSPECTOR_TYPE_ID_PREFIX)) {
            return;
        }
        if (finding.getProperties().containsKey("Rule ID")) {
            return;
        }
        String ruleId = StringUtils.stripPrefix((String)finding.getTypeId(), (String)CODE_INSPECTOR_TYPE_ID_PREFIX);
        finding.setProperty("Rule ID", (Object)ruleId);
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        ListMap<String, IndexFinding> reviewFindings = this.findingsWithPartition.get(ExternalAnalysisResultFindingsProcessor.makeExternalFindingsPartition("code-review-findings"));
        if (reviewFindings != null && !reviewFindings.isEmpty()) {
            this.appendExistingReviewFindings(reviewFindings);
        }
        for (Map.Entry<String, ListMap<String, IndexFinding>> entry : this.findingsWithPartition.entrySet()) {
            String partition = entry.getKey();
            ListMap<String, IndexFinding> findings = entry.getValue();
            List<BasicTokenElementInfo> tokenElements = ExternalAnalysisResultFindingsProcessor.getTokenElementInfos(this.contentIndex, new ArrayList<String>((Collection<String>)findings.getKeys()));
            CodeScopeAware<ListMap<String, IndexFinding>> findingsByCodeScope = IntegratedToolUtils.splitFindingsByCodeScope(tokenElements, findings);
            CodeScopeAware<CounterSet<String>> droppedFindingsByCodeScope = this.storeFindings(partition, findingsByCodeScope, tokenElements, findings);
            for (CodeScopeName codeScopeName : droppedFindingsByCodeScope.getCodeScopeNames()) {
                CounterSet droppedFindings = (CounterSet)droppedFindingsByCodeScope.getValue(codeScopeName);
                if (droppedFindings.isEmpty()) continue;
                this.warnAboutDroppedFindings((CounterSet<String>)droppedFindings, codeScopeName);
            }
        }
    }

    private void warnAboutDroppedFindings(CounterSet<String> droppedFindings, CodeScopeName codeScopeName) {
        for (Pair findingTypeAndCount : droppedFindings) {
            String warningMessage = "Dropped " + String.valueOf(findingTypeAndCount.getSecond()) + " findings of type '" + (String)findingTypeAndCount.getFirst() + "' in code scope '" + String.valueOf(codeScopeName) + "' as the corresponding check is unknown or disabled in the analysis profile";
            this.addUploadStatusMessage(warningMessage);
            LOGGER.warn(warningMessage);
        }
    }

    private CodeScopeAware<CounterSet<String>> storeFindings(String partition, CodeScopeAware<ListMap<String, IndexFinding>> findingsByCodeScope, List<BasicTokenElementInfo> tokenElements, ListMap<String, IndexFinding> findings) throws StorageException {
        CodeScopeAware codeScopeToFindingsSchemaMapping = CodeScopeAware.empty();
        for (Object codeScopeName : findingsByCodeScope.getCodeScopeNames()) {
            codeScopeToFindingsSchemaMapping.setValue((CodeScopeName)codeScopeName, (Object)this.findingsSchemaIndex.getFindingsSchema((CodeScopeName)codeScopeName));
        }
        HashMap<String, CodeScopeName> uniformPathToCodeScopeMapping = new HashMap<String, CodeScopeName>();
        for (BasicTokenElementInfo tokenElementInfo : tokenElements) {
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElementInfo);
            uniformPathToCodeScopeMapping.put(tokenElementInfo.getUniformPath(), codeScopeName);
        }
        PairList findingsPairList = new PairList();
        for (String uniformPath : findings.getKeys()) {
            findingsPairList.add((Object)uniformPath, (Object)((List)findings.getCollectionOrEmpty((Object)uniformPath)));
        }
        return this.findingsIndex.setFindings(partition, findingsPairList, codeScopeToFindingsSchemaMapping, uniformPathToCodeScopeMapping);
    }

    private static List<BasicTokenElementInfo> getTokenElementInfos(BasicTokenElementIndex contentIndex, List<String> processedPaths) throws StorageException {
        return CollectionUtils.filterNullEntries(contentIndex.getTokenElements(processedPaths));
    }

    private void appendExistingReviewFindings(ListMap<String, IndexFinding> reviewFindings) throws StorageException {
        ArrayList uniformPaths = new ArrayList(reviewFindings.getKeys());
        List existingFindings = this.findingsIndex.getFindings(ExternalAnalysisResultFindingsProcessor.makeExternalFindingsPartition("code-review-findings"), uniformPaths);
        CollectionUtils.forEach(uniformPaths, (Iterable)existingFindings, (uniformPath, existingFindingsForPath) -> this.appendExistingReviewFindingsForPath(reviewFindings, (String)uniformPath, Optional.ofNullable(existingFindingsForPath).orElseGet(ArrayList::new)));
    }

    private void appendExistingReviewFindingsForPath(ListMap<String, IndexFinding> reviewFindings, String uniformPath, ArrayList<IndexFinding> existingFindingsForPath) {
        List deletedFindings = this.explicitlyDeletedReviewFindings.get(uniformPath);
        existingFindingsForPath.removeIf(finding -> ExternalAnalysisResultFindingsProcessor.containsEqualReviewFinding(deletedFindings, finding));
        List newFindings = (List)reviewFindings.getCollectionOrEmpty((Object)uniformPath);
        if (!deletedFindings.isEmpty()) {
            for (int i = 0; i < existingFindingsForPath.size(); ++i) {
                ExternalAnalysisResultFindingsProcessor.setReviewFindingRuleIdProperty(existingFindingsForPath.get(i), i);
            }
        }
        if (!newFindings.isEmpty()) {
            for (IndexFinding newFinding : newFindings) {
                ExternalAnalysisResultFindingsProcessor.setReviewFindingRuleIdProperty(newFinding, existingFindingsForPath.size());
            }
        }
        newFindings.addAll(existingFindingsForPath);
    }

    private static void setReviewFindingRuleIdProperty(IndexFinding reviewFinding, int reviewCommentNumber) {
        reviewFinding.setProperty("Rule ID", (Object)("review-comment-" + reviewCommentNumber));
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        List externalFindingsPartitionAndPath = CollectionUtils.map(deletedPartitionAndPaths, ExternalAnalysisResultFindingsProcessor::makeExternalFindingsPartitionAndPath);
        this.findingsIndex.removeFindingsForPartitionsAndPaths((Collection)externalFindingsPartitionAndPath);
    }

    private static @NonNull PartitionAndPath makeExternalFindingsPartitionAndPath(PartitionAndPath partitionAndPath) {
        return new PartitionAndPath(ExternalAnalysisResultFindingsProcessor.makeExternalFindingsPartition(partitionAndPath.getPartition()), partitionAndPath.getUniformPath());
    }

    @Override
    public void reset() {
        this.findingsWithPartition.clear();
        this.explicitlyDeletedReviewFindings.clear();
    }
}

