/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeInfo;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import java.util.Date;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass
public class RepositoryChangeEntry
extends RepositoryChangeInfo {
    private static final long serialVersionUID = 1L;
    private final UniformPath path;
    private final String revision;
    private final CommitDescriptor commit;
    private final @NonNull EChangeEntryOrigin changeEntryOrigin;

    public RepositoryChangeEntry(UniformPath path, String revision, ERepositoryChangeType changeType, CommitDescriptor commit, EChangeEntryOrigin changeEntryOrigin) {
        this(path, revision, changeType, commit, null, null, changeEntryOrigin);
    }

    public RepositoryChangeEntry(UniformPath path, String revision, CommitDescriptor commit, RepositoryChangeInfo changeInfo, EChangeEntryOrigin changeEntryOrigin) {
        this(path, revision, changeInfo.getChangeType(), commit, changeInfo.getOriginPath(), changeInfo.getOriginCommit(), changeEntryOrigin);
    }

    public RepositoryChangeEntry(UniformPath path, UniformPath originPath, RepositoryChangeEntry entry) {
        this(path, entry.revision, entry.changeType, entry.commit, originPath, entry.originCommit, entry.changeEntryOrigin);
    }

    public RepositoryChangeEntry(@NonNull UniformPath path, @NonNull String revision, @NonNull ERepositoryChangeType changeType, @NonNull CommitDescriptor commit, @Nullable UniformPath originPath, @Nullable CommitDescriptor originCommit, @NonNull EChangeEntryOrigin changeEntryOrigin) {
        super(originPath, originCommit, changeType);
        CCSMAssert.isNotNull((Object)((Object)changeType), (String)"The change type may not be null for a repository change entry");
        CCSMAssert.isNotNull((Object)path, (String)"The path may not be null for a repository change entry");
        this.path = path;
        CCSMAssert.isNotNull((Object)revision, (String)"The revision may not be null for a repository change entry");
        this.revision = revision;
        CCSMAssert.isNotNull((Object)commit, (String)"The commit may not be null for a repository change entry");
        this.commit = commit;
        CCSMAssert.isFalse((originPath == null && originCommit != null ? 1 : 0) != 0, (String)"Invalid combination of origin path (null) and origin timestamp (not -1) in RepositoryChangeEntry constructor");
        this.changeEntryOrigin = changeEntryOrigin;
    }

    @VisibleForTesting
    public RepositoryChangeEntry(String uniformPath, String revision, ERepositoryChangeType repositoryChangeType, CommitDescriptor secondForkCommit, EChangeEntryOrigin changeEntryOrigin) {
        this(UniformPath.parse((String)uniformPath), revision, repositoryChangeType, secondForkCommit, changeEntryOrigin);
    }

    @VisibleForTesting
    public RepositoryChangeEntry(String uniformPath, String revision, ERepositoryChangeType repositoryChangeType, CommitDescriptor commit, String originPath, CommitDescriptor originCommit, EChangeEntryOrigin changeEntryOrigin) {
        this(UniformPath.parse((String)uniformPath), revision, repositoryChangeType, commit, UniformPath.parse((String)originPath), originCommit, changeEntryOrigin);
    }

    public UniformPath getRepositoryPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision;
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public @NonNull EChangeEntryOrigin getChangeEntryOrigin() {
        return this.changeEntryOrigin;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.path);
        result.append('|');
        result.append(this.revision);
        result.append('|');
        result.append((Object)this.changeType);
        result.append('|');
        result.append((Object)this.changeEntryOrigin);
        result.append('|');
        result.append(new Date(this.commit.getTimestamp())).append(" (").append(this.commit.getBranchName()).append(":").append(this.commit.getTimestamp()).append(")");
        if (this.originPath != null) {
            result.append("| origin: ");
            result.append(this.originPath);
            result.append(" @ ");
            result.append(this.originCommit);
        } else {
            result.append("| no change in origin");
        }
        return result.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.revision, this.changeType, this.commit, this.originPath, this.originCommit, this.changeEntryOrigin});
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepositoryChangeEntry) {
            RepositoryChangeEntry other = (RepositoryChangeEntry)obj;
            return this.path.equals((Object)other.path) && Objects.equals(this.originPath, other.originPath) && this.revision.equals(other.revision) && this.changeType == other.changeType && this.commit.equals((Object)other.commit) && Objects.equals(this.originCommit, other.originCommit) && this.changeEntryOrigin == other.changeEntryOrigin;
        }
        return false;
    }
}

