/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.google.common.base.Suppliers;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.pattern.PatternTransformationList;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.RegexReplacement;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;

public class RepositoryPathTransformationSupport {
    public static final String PREPEND_REPOSITORY_IDENTIFIER = "prepended-repository-identifier";
    public static final String PATH_TRANSFORMATION_PARAMETER = "path-transformation";
    private final Supplier<String> repositoryIdentifier;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private RepositoryOriginalPathIndex originalPathIndex;
    private final Map<String, String> originalPathValues = new HashMap<String, String>();
    @StepParameter(value="prepended-repository-identifier", optional=true)
    private boolean prependRepositoryIdentifier = false;
    @StepParameter(value="path-transformation", optional=true)
    @VisibleForTesting
    final PairList<String, String> pathTransformation = new PairList();
    private final Supplier<PatternTransformationList> pathTransformationList = Suppliers.memoize(() -> this.pathTransformation.stream().map(pathTransformation -> new RegexReplacement((String)pathTransformation.getFirst(), (String)pathTransformation.getSecond())).collect(Collectors.toCollection(PatternTransformationList::new)));

    public RepositoryPathTransformationSupport(Supplier<String> repositoryIdentifier) {
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public UniformPath recordPathTransformation(RepositoryChangeEntry changeEntry) {
        UniformPath uniformPath = this.getUniformPath(changeEntry);
        this.originalPathValues.put(uniformPath.toStringAsMigrationFrontier(), changeEntry.getRepositoryPath().toStringAsMigrationFrontier());
        return uniformPath;
    }

    public void persistRecordedPathTransformations() throws StorageException {
        if (!this.originalPathValues.isEmpty()) {
            this.originalPathIndex.addAll(this.repositoryIdentifier.get(), this.originalPathValues);
        }
    }

    public void removeStoredPathTransformations(List<UniformPath> deletedPaths) throws StorageException {
        this.originalPathIndex.removeAll(this.repositoryIdentifier.get(), UniformPathCompatibilityUtil.asUniformPathStrings(deletedPaths));
    }

    public UniformPath getUniformPath(RepositoryChangeEntry change) {
        return this.transformPath(change.getRepositoryPath());
    }

    protected UniformPath getUniformOriginPath(RepositoryChangeEntry change) {
        return this.transformPath(change.getOriginPath());
    }

    public UniformPath transformPath(@Nullable UniformPath path) {
        if (path == null) {
            return null;
        }
        String transformedPath = path.toString();
        if (!this.pathTransformationList.get().isEmpty()) {
            transformedPath = this.pathTransformationList.get().applyTransformation(transformedPath);
        }
        if (this.prependRepositoryIdentifier) {
            transformedPath = UniformPathUtils.concatenate((String[])new String[]{this.repositoryIdentifier.get(), transformedPath});
        }
        return UniformPath.parse((String)UniformPathUtils.cleanPath((String)transformedPath));
    }

    List<String> untransformPaths(List<String> paths) throws StorageException {
        Map<String, String> mapping = this.originalPathIndex.getRepositoryPaths(this.repositoryIdentifier.get(), paths);
        return CollectionUtils.map(paths, mapping::get);
    }
}

