/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.external.input.external_storage.IOutgoingExternalAnalysisArchive;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.ItemQueryResultData;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.BiConsumerWithTwoExceptions;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class SimpleArtifactStoreClientBase<T extends ArtifactStoreRepositoryInfoBase> {
    protected static final Duration TIMEOUT = Duration.ofMinutes(10L);
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    public abstract void forEachEntryInArchive(String var1, String var2, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> var3) throws RepositoryException, StorageException, ProjectConfigurationException;

    @VisibleForTesting
    public static void forEachEntryInArchiveStream(String path, InputStream contentStream, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> consumer) throws IOException, StorageException {
        String lowerCasePath = path.toLowerCase();
        if (lowerCasePath.endsWith(".zip")) {
            SimpleArtifactStoreClientBase.forEachEntryInZipStream(contentStream, consumer);
        } else if (lowerCasePath.endsWith(".tar")) {
            SimpleArtifactStoreClientBase.forEachEntryInTarStream(contentStream, consumer);
        } else if (StringUtils.endsWithOneOf((String)lowerCasePath, (String[])new String[]{".tar.bz2", ".tbz2"})) {
            SimpleArtifactStoreClientBase.forEachEntryInTarStream((InputStream)new BZip2CompressorInputStream(contentStream), consumer);
        } else if (StringUtils.endsWithOneOf((String)lowerCasePath, (String[])new String[]{".tar.gz", ".tgz"})) {
            SimpleArtifactStoreClientBase.forEachEntryInTarStream((InputStream)new GzipCompressorInputStream(contentStream), consumer);
        } else {
            contentStream.close();
            throw new IOException("Unknown/unsupported archive file extension in archive " + path);
        }
    }

    private static void forEachEntryInZipStream(InputStream contentStream, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> consumer) throws IOException, StorageException {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(contentStream);){
            ZipArchiveEntry zipEntry = zis.getNextZipEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    consumer.accept((Object)zis, (Object)zipEntry);
                }
                zipEntry = zis.getNextZipEntry();
            }
        }
    }

    private static void forEachEntryInTarStream(InputStream uncompressedStream, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> consumer) throws IOException, StorageException {
        try (TarArchiveInputStream tarStream = new TarArchiveInputStream(uncompressedStream);){
            TarArchiveEntry tarEntry = tarStream.getNextTarEntry();
            while (tarEntry != null) {
                if (!tarEntry.isDirectory()) {
                    consumer.accept((Object)tarStream, (Object)tarEntry);
                }
                tarEntry = tarStream.getNextTarEntry();
            }
        }
    }

    public abstract ItemQueryResultData findItems(T var1, int var2) throws RepositoryException, ProjectConfigurationException, RescheduleRequestedException;

    public abstract void putArchive(String var1, IOutgoingExternalAnalysisArchive var2) throws RepositoryException;

    public abstract void deleteArchive(String var1, String var2) throws RepositoryException;

    @VisibleForTesting
    public static List<ArtifactStoreItemData> filterDuplicateItems(ItemQueryResultData items) {
        HashMap itemByFullPath = new HashMap();
        items.forEach((Consumer<? super ArtifactStoreItemData>)((Consumer<ArtifactStoreItemData>)item -> itemByFullPath.merge(item.getFullPath(), item, (item1, item2) -> {
            if (item1.getCreationTimestamp() <= item2.getCreationTimestamp()) {
                return item1;
            }
            return item2;
        })));
        return new ArrayList<ArtifactStoreItemData>(itemByFullPath.values());
    }

    public abstract Set<String> fetchBranches(T var1) throws RepositoryException, ProjectConfigurationException;

    public abstract void testConnection(String var1, String var2) throws RepositoryException, ProjectConfigurationException;
}

