/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.committree;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.index.repository.committree.IBranchRenameHandler;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class CachingBranchRenameHandler
implements IBranchRenameHandler,
Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final StringTransformation branchTransformation;
    private final Map<String, String> renameMapping = new HashMap<String, String>();
    private final Map<String, String> unrenameMapping = new HashMap<String, String>();

    public CachingBranchRenameHandler(StringTransformation branchTransformation, PairList<String, String> sortedRenameMapping) {
        CCSMAssert.isTrue((boolean)branchTransformation.containsTransformations(), (String)"branchTransformation must contain transformations! This is a programming error.");
        this.branchTransformation = branchTransformation;
        for (Pair renaming : sortedRenameMapping) {
            LOGGER.debug("Caching branch name mapping: {} -> {}", renaming.getFirst(), renaming.getSecond());
            this.renameMapping.put((String)renaming.getFirst(), (String)renaming.getSecond());
            this.unrenameMapping.put((String)renaming.getSecond(), (String)renaming.getFirst());
        }
    }

    private static void logBranchNameMapping(String origin, String renamed) {
        LOGGER.debug("Storing branch name mapping: {} -> {}", (Object)origin, (Object)renamed);
    }

    @Override
    public PairList<String, String> getSortedMapping() {
        PairList sortedMapping = new PairList();
        for (Map.Entry<String, String> entry : this.renameMapping.entrySet()) {
            sortedMapping.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        CollectionUtils.sortByFirst((PairList)sortedMapping);
        return sortedMapping;
    }

    @Override
    public CommitDescriptor renameBranch(CommitDescriptor commitDescriptor) {
        if (commitDescriptor == null) {
            return null;
        }
        LOGGER.debug("Renaming branch based on commit descriptor: {}", new Supplier[]{() -> commitDescriptor});
        return new CommitDescriptor(this.renameBranch(commitDescriptor.getBranchName()), commitDescriptor.getTimestamp());
    }

    @Override
    public String renameBranch(String branchName) {
        if (this.renameMapping.containsKey(branchName)) {
            return this.renameMapping.get(branchName);
        }
        String renamedBranchName = this.branchTransformation.apply(branchName);
        CachingBranchRenameHandler.logBranchNameMapping(branchName, renamedBranchName);
        this.renameMapping.put(branchName, renamedBranchName);
        if (this.unrenameMapping.containsKey(renamedBranchName)) {
            String preRenamedBranch = this.unrenameMapping.get(renamedBranchName);
            if (renamedBranchName.equals(branchName) || preRenamedBranch.equals(branchName)) {
                LOGGER.error("Branch '{}' was renamed to an existing branch. This may happen if the renaming target contains a capture group, since we can not dynamically add excluded branches. Please consider excluding '{}' explicitly in the connector configuration.", (Object)branchName, (Object)branchName);
            } else {
                LOGGER.warn("Encountered different branches that lead to same renamed branch name '{}': '{}' and '{}'", (Object)renamedBranchName, (Object)branchName, (Object)preRenamedBranch);
            }
            if (LOGGER.isTraceEnabled()) {
                StackTraceElement[] stackTrace = new Throwable().getStackTrace();
                LOGGER.trace("Stacktrace: \n{}", new Supplier[]{() -> Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n"))});
            }
        }
        this.unrenameMapping.put(renamedBranchName, branchName);
        return renamedBranchName;
    }

    @Override
    public String unrenameBranch(String branchName) {
        String original = this.unrenameMapping.get(branchName);
        CCSMAssert.isNotNull((Object)original, (String)("Did not find original branch name for renamed branch " + branchName));
        return original;
    }

    @Override
    public CommitTreeRevision renameBranch(CommitTreeRevision revision) {
        LOGGER.debug("Renaming branch based on revision: {}", (Object)revision.toString());
        return new CommitTreeRevision(revision.getRevision(), this.renameBranch(revision.getBranchName()));
    }

    @Override
    public CommitTreeRevision unrenameBranch(CommitTreeRevision revision) {
        return new CommitTreeRevision(revision.getRevision(), this.unrenameBranch(revision.getBranchName()));
    }

    @Override
    public String peekRenameBranch(String branchName) {
        return this.branchTransformation.apply(branchName);
    }

    @Override
    public boolean isRenamed(CommitTreeRevision revision) {
        return this.unrenameMapping.containsKey(revision.getBranchName());
    }
}

