/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem.multiversion;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.index.repository.filesystem.FileSystemRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemChangeRetriever;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemCommit;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemContentUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@ConnectorDescriptor(disabledByFeatureToggle=EFeatureToggle.DISABLE_FILE_SYSTEM_CONNECTOR)
public class MultiVersionFileSystemRepositoryConnectorDescriptor
extends FileSystemRepositoryConnectorDescriptorBase {
    public MultiVersionFileSystemRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.MULTI_VERSION_FILE_SYSTEM);
        this.autoExpose();
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return MultiVersionFileSystemChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return MultiVersionFileSystemContentUpdater.class;
    }

    public static List<String> getRevisionDirectoryNames(File baseDirectory) {
        File[] filesInDirectory = baseDirectory.listFiles(file -> file.isDirectory() && !file.isHidden());
        if (filesInDirectory == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.map(Arrays.asList(filesInDirectory), File::getName);
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        List<String> directoryNames = MultiVersionFileSystemRepositoryConnectorDescriptor.getRevisionDirectoryNames(new File(this.inputDir));
        if (directoryNames.isEmpty()) {
            throw new ConnectorValidationException("No revisions/subdirectories found!");
        }
        ArrayList<MultiVersionFileSystemCommit> allCommits = new ArrayList<MultiVersionFileSystemCommit>();
        for (String name : directoryNames) {
            try {
                if (FileSystemUtils.isSystemFileName((String)name)) continue;
                allCommits.add(new MultiVersionFileSystemCommit(name, this.defaultBranchName));
            }
            catch (RepositoryException e) {
                throw new ConnectorValidationException((Throwable)e);
            }
        }
        MultiVersionFileSystemCommit firstCommit = (MultiVersionFileSystemCommit)Collections.min(allCommits);
        if (firstCommit.getTimestamp() < 2L) {
            throw new ConnectorValidationException("The timestamp of the directory \"" + firstCommit.getDirectoryName() + "\"must be greater than 1.");
        }
    }
}

