/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.index.repository.git.DisabledSubModuleRegistry;
import com.teamscale.index.repository.git.GitRepositoryBase;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.ISubModuleRegistry;
import com.teamscale.index.repository.git.RecursiveSubModuleRegistry;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitMainRepository
extends GitRepositoryBase {
    protected GitMainRepository(GitRepositoryConnection connection) {
        super(connection);
    }

    public GitMainRepository(GitRepositoryConnection connection, URI repositoryPath, ICancelable cancelable) throws RepositoryException {
        super(connection, repositoryPath, cancelable);
    }

    @Override
    protected ISubModuleRegistry createSubModuleRegistry() {
        if (this.connection.gitParameters.isIncludeSubModules()) {
            return new RecursiveSubModuleRegistry(this, this.connection.convertSubmoduleSshToHttpsUrl);
        }
        return new DisabledSubModuleRegistry();
    }

    public String getLocationDescription() throws RepositoryException {
        try {
            return this.repository.getFullBranch();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Set<String> crawl(RevCommit commit, int recursionDepth) throws RepositoryException {
        return this.crawl(commit, "", recursionDepth);
    }

    public Optional<Long> convertRevisionToTimestamp(String revision) {
        return GitUtils.getTimestampFromRevision(this.repository, revision);
    }
}

