/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BitbucketInstallationRepositories {

    public static class Project {
        private static final String KEY_PROPERTY_NAME = "key";
        @JsonProperty(value="key")
        private String key;

        @JsonCreator
        public Project(@JsonProperty(value="key") String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }

    public static class CloneUrl {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="href")
        private String href;

        String getCloneHref() {
            return this.href;
        }

        String getCloneName() {
            return this.name;
        }
    }

    public static class CloneLinks {
        @JsonProperty(value="clone")
        private CloneUrl[] clone;

        public Optional<String> getHttpCloneUrl() {
            return Arrays.stream(this.clone).filter(cloneUrl -> cloneUrl.getCloneName().startsWith("http")).findFirst().map(CloneUrl::getCloneHref);
        }
    }

    public static class InstallationRepository {
        private static final String SLUG_PROPERTY_NAME = "slug";
        private static final String LINKS_PROPERTY_NAME = "links";
        private static final String PROJECT_PROPERTY_NAME = "project";
        @JsonProperty(value="slug")
        private String slug;
        @JsonProperty(value="links")
        private @Nullable CloneLinks links;
        @JsonProperty(value="project")
        private Project project;

        @JsonCreator
        public InstallationRepository(@JsonProperty(value="slug") String slug, @JsonProperty(value="links") @Nullable CloneLinks links, @JsonProperty(value="project") Project project) {
            this.slug = slug;
            this.links = links;
            this.project = project;
        }

        public Optional<String> getHttpCloneUrl() {
            if (this.links == null) {
                return Optional.empty();
            }
            return this.links.getHttpCloneUrl();
        }

        public String getProjectKey() {
            return this.project.getKey();
        }

        public String getSlug() {
            return this.slug;
        }
    }

    public static class InstallationRepositories {
        @JsonProperty(value="values")
        private InstallationRepository[] values;

        public Optional<InstallationRepository> getRepositoryByName(String name) {
            return Arrays.stream(this.values).filter(repo -> name.equals(repo.slug)).findFirst();
        }
    }
}

