/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestAnnotationUtils;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.bitbucket.BitbucketUtils;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudMergeRequestProvider;
import com.teamscale.index.repository.git.bitbucket.cloud.client.BitbucketCloudClientHelper;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequest;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequestComment;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReport;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReportAnnotation;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.report.BitbucketCloudCommitReportData;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;

public class BitbucketCloudMergeRequestAnnotationTrigger
extends MergeRequestAnnotationTriggerBase<BitbucketCloudPullRequest, MergeRequestBuildJob> {
    private static final String MARKER_START = "---";
    private static final String MARKER_END = "---";
    private BitbucketCloudClientHelper clientHelper;
    private static final Logger LOGGER = LogManager.getLogger();
    private BitbucketCloudCommitReport report;
    private @Nullable List<BitbucketCloudCommitReportAnnotation> annotations;

    @Override
    protected VotingRecord.EVotingState performVoting(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        this.prepareReport(schedulingParams, input);
        VotingRecord.EVotingState state = super.performVoting(schedulingParams, input);
        try {
            this.clientHelper.deleteReport(input.mergeRequest.sourceHead);
            this.verifyNotCanceled();
            this.sendReport(input);
        }
        catch (ServiceCallException e) {
            throw new VotingException.Error(schedulingParams.schedulingCommit(), (Throwable)e);
        }
        return state;
    }

    private void sendReport(MergeRequestAnnotationInput input) throws ServiceCallException {
        this.report = this.clientHelper.postCommitReport(input.mergeRequest.sourceHead, this.report);
        if (!CollectionUtils.isNullOrEmpty(this.annotations)) {
            this.clientHelper.postAnnotations(input.mergeRequest.sourceHead, this.annotations);
        }
    }

    private void prepareReport(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
        this.report = new BitbucketCloudCommitReport();
        this.report.setReporter("Teamscale");
        this.report.setLink(schedulingParams.linkProvider().createMergeRequestDetailsLink(input.mergeRequest.identifier));
        this.report.setLogoUrl(schedulingParams.linkProvider().createTeamscaleNotificationLogoLink());
        this.report.setData(new ArrayList<BitbucketCloudCommitReportData>());
        this.report.setReportState(BitbucketCloudCommitReport.EBitbucketCloudReportState.PENDING);
        this.report.setExternalId("teamscale-insights");
        this.report.setReportType(BitbucketCloudCommitReport.EBitBucketCloudReportType.BUG);
        this.report.setDetails("Teamscale");
        this.report.setTitle("Teamscale Insights  ");
    }

    protected BitbucketCloudMergeRequestProvider createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException, ServiceCallException {
        GlobalStorageSystem globalPartition = this.indexLayer.openGlobalStorageSystem();
        this.clientHelper = new BitbucketCloudClientHelper(BitbucketCloudMergeRequestAnnotationTrigger.getRepositoryName(schedulingParameters.connector()), (BitbucketCloudInstallationIndex)globalPartition.openGlobalIndex(BitbucketCloudInstallationIndex.class), (AccessTokenIndex)globalPartition.openGlobalIndex(AccessTokenIndex.class));
        return new BitbucketCloudMergeRequestProvider(this.clientHelper);
    }

    @Override
    public String buildMergeRequestMarkdownContent(MergeRequestAnnotationInput input, TeamscaleCommitLinkProvider linkProvider) {
        boolean projectHasRequirementsConnector = false;
        try {
            projectHasRequirementsConnector = VotingConnectorUtils.projectHasRequirementsConnector((MetaIndex)this.openIndexInProject(MetaIndex.class), LOGGER);
        }
        catch (StorageException e) {
            LOGGER.error("Error opening MetaIndex for project, assuming no requirements connector enabled", (Throwable)e);
        }
        return input.buildMergeBadgesAsMarkdownTableBitbucketCloud((TeamscaleProjectLinkProvider)linkProvider, projectHasRequirementsConnector);
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) throws ServiceCallException, StorageException {
        BitbucketCloudPullRequest pullRequest = this.clientHelper.getPullRequest(input.mergeRequest.getId());
        Pattern oldBadgesPattern = Pattern.compile(Pattern.quote("---".trim()) + "[\\S\\n\\r\\s]*?" + Pattern.quote("Open in Teamscale") + "[\\S\\n\\r\\s]*?" + Pattern.quote("---".trim()), 32);
        MergeRequestAnnotationUtils.updateDescription(pullRequest.getDescription(), badgeAsMarkdown, "---", "---", oldBadgesPattern, BitbucketCloudMergeRequestAnnotationTrigger.isBadgeSetToTopPosition(schedulingParams.connector()), (ConsumerWithTwoExceptions<String, ServiceCallException, StorageException>)((ConsumerWithTwoExceptions)newDescription -> {
            pullRequest.setDescription((String)newDescription);
            this.clientHelper.putUpdatePullRequest(pullRequest);
        }));
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(FindingsVotingInfo findingsVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, ServiceCallException {
        CommitStatus status = BitbucketUtils.createFindingsCommitStatus(findingsVotingInfo, input.createMergeRequestDetailsLink(schedulingParams.linkProvider()));
        this.clientHelper.postNewCommitStatus(status, input.mergeRequest.sourceHead);
        this.report.setDetails(status.getDescription());
        if (findingsVotingInfo.isPositiveVote()) {
            this.report.setReportState(BitbucketCloudCommitReport.EBitbucketCloudReportState.PASSED);
            return VotingRecord.EVotingState.VOTED_POSITIVE;
        }
        this.report.setReportState(BitbucketCloudCommitReport.EBitbucketCloudReportState.FAILED);
        return VotingRecord.EVotingState.VOTED_NEGATIVE;
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) {
        this.annotations = reviewComments.stream().map(BitbucketCloudCommitReportAnnotation::fromReviewComment).toList();
        LOGGER.debug("Prepare inline comments: {}", new Supplier[]{() -> this.annotations.toString()});
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, JsonSerializationException {
        long pullRequestId = input.mergeRequest.getId();
        List<BitbucketCloudPullRequestComment> pullRequestComments = this.clientHelper.getAllPullRequestComments(pullRequestId);
        List existingAggregatedTeamscaleComments = CollectionUtils.filter(pullRequestComments, comment -> CcpCommentUtils.isTeamscaleTestGapSummaryComment(comment.getRawContent()));
        for (BitbucketCloudPullRequestComment comment2 : existingAggregatedTeamscaleComments) {
            this.clientHelper.deletePullRequestComment(pullRequestId, comment2.id().intValue());
        }
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) throws ServiceCallException {
        this.clientHelper.postPullRequestComment(pullRequestId, commentContent);
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) throws ServiceCallException, StorageException {
        BitbucketCloudPullRequest pullRequest = this.clientHelper.getPullRequest(input.mergeRequest.getId());
        String newDescription = MergeRequestAnnotationUtils.compileDescriptionWithLimitCommentWarning(commentLimitWarningExceededMessage, pullRequest.getDescription(), "---", "---", commentLimitWarningFormat);
        pullRequest.setDescription(newDescription);
        this.clientHelper.putUpdatePullRequest(pullRequest);
    }

    protected EnumSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        return EnumSet.of(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.PLATFORM_SPECIFIC);
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException {
        this.clientHelper.deleteReport(input.mergeRequest.sourceHead);
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.clientHelper.deleteReport(input.mergeRequest.sourceHead);
    }

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.BITBUCKET;
    }
}

