/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryIdentifier;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class BitbucketDataCenterGitUtils {
    public static @NonNull URI getRepositoryUri(@NonNull ConnectorConfiguration connectorConfiguration, @NonNull ExternalCredentials credentials, @NonNull Logger interactionLogger) throws RepositoryException, ProjectConfigurationException {
        BitbucketServerRepositoryIdentifier repositoryIdentifier = Optional.ofNullable(connectorConfiguration.getOptionValue("Repository name")).map(BitbucketServerRepositoryIdentifier::fromRepositoryName).orElseThrow(() -> new ProjectConfigurationException("Repository name is null."));
        BitbucketServerClient client = new BitbucketServerClient(credentials.uri, credentials.username, credentials.password, interactionLogger);
        try {
            String url = client.getBitbucketRepository(repositoryIdentifier).getHttpCloneUrl().orElseThrow(() -> new RepositoryException("Could not retrieve clone URL for repository: " + String.valueOf(repositoryIdentifier)));
            return UrlUtils.parseUri((String)url);
        }
        catch (URISyntaxException e) {
            throw new ProjectConfigurationException("Invalid repository url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceCallException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private BitbucketDataCenterGitUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

