/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestBuildStatus;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerCrossRepositoryMergeRequestHandler;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestBuildJobHandler;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerClient;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequest;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.jetbrains.annotations.VisibleForTesting;

public class BitbucketServerMergeRequestProvider
extends MergeRequestProvider<BitbucketServerPullRequest, CommitStatus> {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    static final String OPEN_STATE = "OPEN";
    @VisibleForTesting
    static final String MERGED_STATE = "MERGED";
    private final PlatformRepositoryIdentifier repositoryIdentifier;
    private final BitbucketServerClient client;

    public BitbucketServerMergeRequestProvider(PlatformRepositoryIdentifier repositoryIdentifier, BitbucketServerClient client, IncludeExcludeRegexSupport buildIncludeExcludeRegexSupport) {
        super(new BitbucketServerCrossRepositoryMergeRequestHandler(), new BitbucketServerMergeRequestBuildJobHandler(client, buildIncludeExcludeRegexSupport));
        this.repositoryIdentifier = repositoryIdentifier;
        this.client = client;
    }

    @Override
    public List<BitbucketServerPullRequest> getAllOpenPlatformMergeRequests() throws ServiceCallException {
        return this.client.getOpenPullRequests(this.repositoryIdentifier);
    }

    @Override
    public @Nullable BitbucketServerPullRequest getPlatformMergeRequest(long id) throws ServiceCallException {
        try {
            return this.client.getPullRequest(this.repositoryIdentifier, id);
        }
        catch (ServiceCallException sce) {
            if (BitbucketServerMergeRequestProvider.wasPullRequestDeleted(sce)) {
                return null;
            }
            throw sce;
        }
    }

    private static boolean wasPullRequestDeleted(ServiceCallException sce) {
        if (sce.getStatusCode() != 404) {
            return false;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode payload = objectMapper.readTree(sce.getResponseBody());
            if (!payload.hasNonNull("errors")) {
                return false;
            }
            JsonNode errors = payload.get("errors");
            if (!errors.isArray()) {
                return false;
            }
            for (JsonNode error : errors) {
                if (!error.has("exceptionName") || !error.get("exceptionName").asText().equalsIgnoreCase("com.atlassian.bitbucket.pull.NoSuchPullRequestException")) continue;
                return true;
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not parse JSON response from BitBucket. Full response: {}", (Object)sce.getResponseBody(), (Object)e);
        }
        return false;
    }

    @Override
    protected MergeRequestProvider.IMergeRequestAdapter createMergeRequestAdapter(final BitbucketServerPullRequest pullRequest) {
        return new MergeRequestProvider.IMergeRequestAdapter(){

            @Override
            public MergeRequestIdentifier getIdentifier() {
                return new MergeRequestIdentifier(BitbucketServerMergeRequestProvider.this.repositoryIdentifier.asRepositoryName(), pullRequest.id());
            }

            @Override
            public EMergeRequestStatus getStatus() {
                return switch (pullRequest.state()) {
                    case BitbucketServerMergeRequestProvider.OPEN_STATE -> EMergeRequestStatus.OPEN;
                    case BitbucketServerMergeRequestProvider.MERGED_STATE -> EMergeRequestStatus.MERGED;
                    default -> EMergeRequestStatus.OTHER;
                };
            }

            @Override
            public String getTitle() {
                return pullRequest.title();
            }

            @Override
            public String getSourceBranch() {
                return pullRequest.sourceBranch().displayId();
            }

            @Override
            public String getCommit() {
                return pullRequest.sourceBranch().latestCommit();
            }

            @Override
            public String getTargetBranch() {
                return pullRequest.targetBranch().displayId();
            }

            @Override
            public String getUrl() {
                return BitbucketServerMergeRequestProvider.this.client.getHtmlPullRequestUrl(BitbucketServerMergeRequestProvider.this.repositoryIdentifier, pullRequest.id());
            }

            @Override
            public Long getCreatedAt() {
                return pullRequest.createdDate();
            }

            @Override
            public Long getUpdatedAt() {
                return pullRequest.updatedDate();
            }
        };
    }

    @Override
    protected MergeRequestProvider.IMergeRequestBuildJobAdapter createMergeRequestBuildJobAdapter(CommitStatus commitStatus) {
        return new BitbucketServerMergeRequestBuildJobAdapter(commitStatus);
    }

    @Override
    protected boolean isCrossRepositoryMergeRequest(@NonNull BitbucketServerPullRequest pullRequest) {
        return !pullRequest.sourceBranch().repository().getProjectKey().equalsIgnoreCase(pullRequest.targetBranch().repository().getProjectKey()) || !pullRequest.sourceBranch().repository().getSlug().equalsIgnoreCase(pullRequest.targetBranch().repository().getSlug());
    }

    public BitbucketServerClient getClient() {
        return this.client;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryIdentifier.asRepositoryName();
    }

    private record BitbucketServerMergeRequestBuildJobAdapter(CommitStatus commitStatus) implements MergeRequestProvider.IMergeRequestBuildJobAdapter
    {
        @Override
        public EMergeRequestBuildStatus getStatus() {
            return switch (this.commitStatus.getState()) {
                case "SUCCESSFUL", "FAILED" -> EMergeRequestBuildStatus.COMPLETED;
                case "INPROGRESS" -> EMergeRequestBuildStatus.IN_PROGRESS;
                default -> EMergeRequestBuildStatus.UNKNOWN;
            };
        }

        @Override
        public @NonNull String getName() {
            return Objects.requireNonNullElseGet(this.commitStatus.getName(), this.commitStatus::getKey);
        }
    }
}

